/*
 * Decompiled with CFR 0.152.
 */
package club.mcams.carpet.api.recipe;

import club.mcams.carpet.api.recipe.AmsRecipeBuilder;
import club.mcams.carpet.api.recipe.template.ShapedRecipeTemplate;
import club.mcams.carpet.api.recipe.template.ShapelessRecipeTemplate;
import club.mcams.carpet.api.recipe.template.SmeltingRecipeTemplate;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1860;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8786;

public class AmsRecipeManager {
    private final List<ShapelessRecipeTemplate> shapelessRecipes;
    private final List<ShapedRecipeTemplate> shapedRecipes;
    private final List<SmeltingRecipeTemplate> smeltingRecipes;

    public AmsRecipeManager(AmsRecipeBuilder builder) {
        this.shapelessRecipes = builder.getShapelessRecipeList();
        this.shapedRecipes = builder.getShapedRecipeList();
        this.smeltingRecipes = builder.getSmeltingRecipeList();
    }

    public void registerRecipes(Map<class_2960, class_1860<?>> map, class_7225.class_7874 wrapperLookup) {
        HashMap<class_2960, JsonElement> recipeMap = new HashMap<class_2960, JsonElement>();
        this.registerAllRecipes(recipeMap);
        recipeMap.forEach((id, json) -> this.addRecipe(map, wrapperLookup, (class_2960)id, (JsonElement)json));
    }

    private void addRecipe(Map<class_2960, class_1860<?>> map, class_7225.class_7874 wrapperLookup, class_2960 id, JsonElement json) {
        class_8786<?> recipeEntry = this.deserializeRecipe(class_5321.method_29179((class_5321)class_7924.field_52178, (class_2960)id), json.getAsJsonObject(), wrapperLookup);
        map.put(id, recipeEntry.comp_1933());
    }

    private class_8786<?> deserializeRecipe(class_5321<class_1860<?>> key, JsonObject json, class_7225.class_7874 registries) {
        return new class_8786(key, (class_1860)class_1860.field_47319.parse((DynamicOps)registries.method_57093((DynamicOps)JsonOps.INSTANCE), (Object)json).getOrThrow(JsonParseException::new));
    }

    private void registerAllRecipes(Map<class_2960, JsonElement> recipeMap) {
        this.shapelessRecipes.forEach(recipe -> recipe.addToRecipeMap(recipeMap));
        this.shapedRecipes.forEach(recipe -> recipe.addToRecipeMap(recipeMap));
        this.smeltingRecipes.forEach(recipe -> recipe.addToRecipeMap(recipeMap));
    }

    public static void clearRecipeListMemory(AmsRecipeBuilder amsRecipeBuilder) {
        amsRecipeBuilder.getShapedRecipeList().clear();
        amsRecipeBuilder.getShapelessRecipeList().clear();
        amsRecipeBuilder.getSmeltingRecipeList().clear();
    }
}

