/*
 * Decompiled with CFR 0.152.
 */
package club.mcams.carpet.commands.rule.commandGetSaveSize;

import club.mcams.carpet.AmsServerSettings;
import club.mcams.carpet.translations.Translator;
import club.mcams.carpet.utils.CommandHelper;
import club.mcams.carpet.utils.EntityUtil;
import club.mcams.carpet.utils.Messenger;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.io.File;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public class GetSaveSizeCommandRegistry {
    private static final Translator translator = new Translator("command.getSaveSize");

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"getSaveSize").requires(source -> CommandHelper.canUseCommand(source, AmsServerSettings.commandGetSaveSize))).executes(context -> GetSaveSizeCommandRegistry.executeGetSaveSize((class_1657)((class_2168)context.getSource()).method_9207())));
    }

    private static int executeGetSaveSize(class_1657 player) {
        MinecraftServer server = EntityUtil.getEntityServer((class_1297)player);
        GetSaveSizeCommandRegistry.saveWorld(server, player);
        long size = GetSaveSizeCommandRegistry.getFolderSize(GetSaveSizeCommandRegistry.getSaveFolder(server));
        String sizeString = GetSaveSizeCommandRegistry.formatSize(size);
        player.method_7353((class_2561)Messenger.s(String.format("\u00a7e%s \u00a7a\u00a7l\u00a7n%s", translator.tr("size_msg", new Object[0]).getString(), sizeString)), false);
        return 1;
    }

    private static void saveWorld(MinecraftServer server, class_1657 player) {
        if (server != null) {
            String SUCCESS_MSG = translator.tr("save_success_msg", new Object[0]).getString();
            String FAIL_MSG = translator.tr("save_fail_msg", new Object[0]).getString();
            boolean saveAllSuccess = server.method_39218(false, true, true);
            String saveAllMessage = saveAllSuccess ? SUCCESS_MSG : FAIL_MSG;
            player.method_7353((class_2561)Messenger.s(saveAllMessage).method_10862(class_2583.field_24360.method_10977(class_124.field_1080)), false);
        }
    }

    private static File getSaveFolder(MinecraftServer server) {
        return Objects.requireNonNull(server).method_27050(class_5218.field_24188).toFile();
    }

    private static long getFolderSize(File folder) {
        long length = 0L;
        File[] files = folder.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isFile()) {
                    length += file.length();
                    continue;
                }
                length += GetSaveSizeCommandRegistry.getFolderSize(file);
            }
        }
        return length;
    }

    private static String formatSize(long size) {
        double sizeGB = (double)size / 1.073741824E9;
        return String.format("%.3f GB", sizeGB);
    }
}

