/*
 * Decompiled with CFR 0.152.
 */
package club.mcams.carpet;

import carpet.CarpetExtension;
import carpet.CarpetServer;
import club.mcams.carpet.AmsServerCustomRecipes;
import club.mcams.carpet.AmsServerMod;
import club.mcams.carpet.AmsServerSettings;
import club.mcams.carpet.api.recipe.AmsRecipeBuilder;
import club.mcams.carpet.api.recipe.AmsRecipeManager;
import club.mcams.carpet.commands.RegisterCommands;
import club.mcams.carpet.commands.rule.commandPlayerLeader.LeaderCommandRegistry;
import club.mcams.carpet.config.LoadConfigFromJson;
import club.mcams.carpet.config.rule.welcomeMessage.CustomWelcomeMessageConfig;
import club.mcams.carpet.helpers.rule.fancyFakePlayerName.FancyFakePlayerNameTeamController;
import club.mcams.carpet.helpers.rule.recipeRule.RecipeRuleHelper;
import club.mcams.carpet.logging.AmsCarpetLoggerRegistry;
import club.mcams.carpet.network.rule.commandCustomBlockHardness.CustomBlockHardnessS2CPacket;
import club.mcams.carpet.settings.CarpetRuleRegistrar;
import club.mcams.carpet.translations.AMSTranslations;
import club.mcams.carpet.translations.TranslationConstants;
import club.mcams.carpet.utils.AutoCleaner;
import club.mcams.carpet.utils.CommandHelper;
import club.mcams.carpet.utils.CountRulesUtil;
import club.mcams.carpet.utils.MinecraftServerUtil;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.mojang.brigadier.CommandDispatcher;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AmsServer
implements CarpetExtension {
    public static long serverStartTimeMillis;
    public static final int ruleCount;
    public static final String fancyName = "Carpet AMS Addition";
    public static final String name;
    public static final String compactName;
    public static final Logger LOGGER;
    private static MinecraftServer minecraftServer;
    private static final AmsServer INSTANCE;

    public static AmsServer getInstance() {
        return INSTANCE;
    }

    public MinecraftServer getMinecraftServer() {
        return minecraftServer;
    }

    public static void init() {
        CarpetServer.manageExtension((CarpetExtension)INSTANCE);
        AMSTranslations.loadTranslations();
    }

    public void onGameStarted() {
        LOGGER.info("{} v{} loaded! (Total rules: {})", (Object)fancyName, (Object)AmsServerMod.getVersion(), (Object)ruleCount);
        LOGGER.info("Open Source: https://github.com/Minecraft-AMS/Carpet-AMS-Addition");
        LOGGER.info("Issues: https://github.com/Minecraft-AMS/Carpet-AMS-Addition/issues");
        LOGGER.info("Wiki: https://minecraft-ams.github.io/carpetamsaddition/");
        CarpetRuleRegistrar.register(CarpetServer.settingsManager, AmsServerSettings.class);
    }

    public String version() {
        return AmsServerMod.getModId();
    }

    public void onTick(MinecraftServer server) {
        LeaderCommandRegistry.tick();
    }

    public void registerLoggers() {
        AmsCarpetLoggerRegistry.registerLoggers();
    }

    public void registerCommands(CommandDispatcher<class_2168> dispatcher) {
        RegisterCommands.registerCommands(dispatcher);
    }

    public void registerCustomRecipes(Map<class_2960, JsonElement> map) {
        AmsRecipeManager amsRecipeManager = new AmsRecipeManager(AmsRecipeBuilder.getInstance());
        AmsRecipeManager.clearRecipeListMemory(AmsRecipeBuilder.getInstance());
        AmsServerCustomRecipes.getInstance().buildRecipes();
        amsRecipeManager.registerRecipes(map);
    }

    public void onPlayerLoggedIn(class_3222 player) {
        CustomWelcomeMessageConfig.getConfig().sendWelcomeMessage((class_1657)player, MinecraftServerUtil.getServer());
        LeaderCommandRegistry.onPlayerLoggedIn((class_1657)player);
        RecipeRuleHelper.onPlayerLoggedIn(MinecraftServerUtil.getServer(), player);
        CustomBlockHardnessS2CPacket.sendToPlayer(player);
    }

    public void onServerLoaded(MinecraftServer server) {
        serverStartTimeMillis = System.currentTimeMillis();
        minecraftServer = server;
        LoadConfigFromJson.load(server);
        CommandHelper.updateAllCommandPermissions(server);
    }

    public void onServerClosed(MinecraftServer server) {
        FancyFakePlayerNameTeamController.removeBotTeam(server, AmsServerSettings.fancyFakePlayerName);
    }

    public void onServerLoadedWorlds(MinecraftServer server) {
        FancyFakePlayerNameTeamController.removeBotTeam(server, AmsServerSettings.fancyFakePlayerName);
        AutoCleaner.removeAmsDataFolder(server);
    }

    public void afterServerLoadWorlds(MinecraftServer server) {
        RecipeRuleHelper.needReloadServerResources(server);
    }

    public Map<String, String> canHasTranslations(String lang) {
        HashMap trimmedTranslation = Maps.newHashMap();
        String prefix = TranslationConstants.CARPET_TRANSLATIONS_KEY_PREFIX;
        AMSTranslations.getTranslation(lang).forEach((key, value) -> {
            if (key.startsWith(prefix)) {
                String newKey = key.substring(prefix.length());
                trimmedTranslation.put(newKey, value);
            }
        });
        return trimmedTranslation;
    }

    static {
        ruleCount = CountRulesUtil.countRules();
        name = AmsServerMod.getModId();
        compactName = name.replace("-", "");
        LOGGER = LogManager.getLogger((String)fancyName);
        INSTANCE = new AmsServer();
    }
}

