/*
 * Decompiled with CFR 0.152.
 */
package club.mcams.carpet.commands.rule.commandCustomBlockBlastResistance;

import club.mcams.carpet.AmsServerSettings;
import club.mcams.carpet.config.rule.commandCustomBlockBlastResistance.CustomBlockBlastResistanceConfig;
import club.mcams.carpet.translations.Translator;
import club.mcams.carpet.utils.CommandHelper;
import club.mcams.carpet.utils.Messenger;
import club.mcams.carpet.utils.RegexTools;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2257;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.server.MinecraftServer;

public class CustomBlockBlastResistanceCommandRegistry {
    private static final Translator translator = new Translator("command.customBlockBlastResistance");
    private static final String MSG_HEAD = "<customBlockBlastResistance> ";
    public static final Map<class_2680, Float> CUSTOM_BLOCK_BLAST_RESISTANCE_MAP = new HashMap<class_2680, Float>();

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"customBlockBlastResistance").requires(source -> CommandHelper.canUseCommand(source, AmsServerSettings.commandCustomBlockBlastResistance))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"block", (ArgumentType)class_2257.method_9653()).then(class_2170.method_9244((String)"resistance", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> CustomBlockBlastResistanceCommandRegistry.set(class_2257.method_9655((CommandContext)context, (String)"block").method_9494(), FloatArgumentType.getFloat((CommandContext)context, (String)"resistance"), ((class_2168)context.getSource()).method_9211(), (class_1657)((class_2168)context.getSource()).method_9207())))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"block", (ArgumentType)class_2257.method_9653()).executes(context -> CustomBlockBlastResistanceCommandRegistry.remove(class_2257.method_9655((CommandContext)context, (String)"block").method_9494(), ((class_2168)context.getSource()).method_9211(), (class_1657)((class_2168)context.getSource()).method_9207()))))).then(class_2170.method_9247((String)"removeAll").executes(context -> CustomBlockBlastResistanceCommandRegistry.removeAll(((class_2168)context.getSource()).method_9211(), (class_1657)((class_2168)context.getSource()).method_9207())))).then(class_2170.method_9247((String)"list").executes(context -> CustomBlockBlastResistanceCommandRegistry.list((class_1657)((class_2168)context.getSource()).method_9207())))).then(class_2170.method_9247((String)"help").executes(context -> CustomBlockBlastResistanceCommandRegistry.help((class_1657)((class_2168)context.getSource()).method_9207()))));
    }

    private static int set(class_2680 state, float blastResistance, MinecraftServer server, class_1657 player) {
        if (CUSTOM_BLOCK_BLAST_RESISTANCE_MAP.containsKey(state)) {
            float oldBlastResistance = CUSTOM_BLOCK_BLAST_RESISTANCE_MAP.get(state).floatValue();
            player.method_7353((class_2561)Messenger.s(MSG_HEAD + CustomBlockBlastResistanceCommandRegistry.getBlockRegisterName(state) + "/" + oldBlastResistance + " -> " + CustomBlockBlastResistanceCommandRegistry.getBlockRegisterName(state) + "/" + blastResistance).method_10862(class_2583.field_24360.method_10977(class_124.field_1060).method_10982(Boolean.valueOf(true))), false);
        } else {
            player.method_7353((class_2561)Messenger.s("<customBlockBlastResistance> + " + CustomBlockBlastResistanceCommandRegistry.getBlockRegisterName(state) + "/" + blastResistance).method_10862(class_2583.field_24360.method_10977(class_124.field_1060).method_10982(Boolean.valueOf(true))), false);
        }
        CUSTOM_BLOCK_BLAST_RESISTANCE_MAP.put(state, Float.valueOf(blastResistance));
        CustomBlockBlastResistanceCommandRegistry.saveToJson(server);
        return 1;
    }

    private static int remove(class_2680 state, MinecraftServer server, class_1657 player) {
        if (CUSTOM_BLOCK_BLAST_RESISTANCE_MAP.containsKey(state)) {
            float blastResistance = CUSTOM_BLOCK_BLAST_RESISTANCE_MAP.get(state).floatValue();
            CUSTOM_BLOCK_BLAST_RESISTANCE_MAP.remove(state);
            CustomBlockBlastResistanceCommandRegistry.saveToJson(server);
            player.method_7353((class_2561)Messenger.s("<customBlockBlastResistance> - " + CustomBlockBlastResistanceCommandRegistry.getBlockRegisterName(state) + "/" + blastResistance).method_10862(class_2583.field_24360.method_10977(class_124.field_1061).method_10982(Boolean.valueOf(true))), false);
            return 1;
        }
        player.method_7353((class_2561)Messenger.s(MSG_HEAD + CustomBlockBlastResistanceCommandRegistry.getBlockRegisterName(state) + translator.tr("not_found", new Object[0]).getString()).method_10862(class_2583.field_24360.method_10977(class_124.field_1061).method_10982(Boolean.valueOf(true))), false);
        return 0;
    }

    private static int removeAll(MinecraftServer server, class_1657 player) {
        CUSTOM_BLOCK_BLAST_RESISTANCE_MAP.clear();
        CustomBlockBlastResistanceCommandRegistry.saveToJson(server);
        player.method_7353((class_2561)Messenger.s(MSG_HEAD + translator.tr("removeAll", new Object[0]).getString()).method_10862(class_2583.field_24360.method_10977(class_124.field_1061).method_10982(Boolean.valueOf(true))), false);
        return 1;
    }

    private static int list(class_1657 player) {
        player.method_7353((class_2561)Messenger.s(translator.tr("list", new Object[0]).getString() + "\n-------------------------------").method_10862(class_2583.field_24360.method_10977(class_124.field_1060).method_10982(Boolean.valueOf(true))), false);
        for (Map.Entry<class_2680, Float> entry : CUSTOM_BLOCK_BLAST_RESISTANCE_MAP.entrySet()) {
            class_2680 state = entry.getKey();
            float blastResistance = entry.getValue().floatValue();
            String blockName = CustomBlockBlastResistanceCommandRegistry.getBlockRegisterName(state);
            player.method_7353((class_2561)Messenger.s(blockName + " / " + blastResistance).method_10862(class_2583.field_24360.method_10977(class_124.field_1060)), false);
        }
        return 1;
    }

    private static int help(class_1657 player) {
        String setHelpText = translator.tr("help.set", new Object[0]).getString();
        String removeHelpText = translator.tr("help.remove", new Object[0]).getString();
        String removeAllHelpText = translator.tr("help.removeAll", new Object[0]).getString();
        String listHelpText = translator.tr("help.list", new Object[0]).getString();
        player.method_7353((class_2561)Messenger.s("\n" + setHelpText + "\n" + removeHelpText + "\n" + removeAllHelpText + "\n" + listHelpText).method_10862(class_2583.field_24360.method_10977(class_124.field_1080)), false);
        return 1;
    }

    private static String getBlockRegisterName(class_2680 state) {
        return RegexTools.getBlockRegisterName(state.method_26204().toString());
    }

    private static void saveToJson(MinecraftServer server) {
        String CONFIG_FILE_PATH = CustomBlockBlastResistanceConfig.getPath(server);
        CustomBlockBlastResistanceConfig.saveToJson(CUSTOM_BLOCK_BLAST_RESISTANCE_MAP, CONFIG_FILE_PATH);
    }
}

