/*
 * Decompiled with CFR 0.152.
 */
package club.mcams.carpet.commands.rule.commandPlayerLeader;

import club.mcams.carpet.AmsServerSettings;
import club.mcams.carpet.commands.rule.commandWhere.WhereCommandRegistry;
import club.mcams.carpet.commands.suggestionProviders.SetSuggestionProvider;
import club.mcams.carpet.config.rule.commandLeader.LeaderConfig;
import club.mcams.carpet.translations.Translator;
import club.mcams.carpet.utils.CommandHelper;
import club.mcams.carpet.utils.Messenger;
import club.mcams.carpet.utils.MinecraftServerUtil;
import com.google.common.collect.ImmutableSet;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class LeaderCommandRegistry {
    private static final Translator translator = new Translator("command.leader");
    private static final String MSG_HEAD = "<commandPlayerLeader> ";
    private static final int GLOWING_TIME = Integer.MAX_VALUE;
    private static final Set<Integer> suggestionIntervalOptions = ImmutableSet.of((Object)20, (Object)40, (Object)80, (Object)160, (Object)320, (Object)640, (Object[])new Integer[]{-1024});
    private static final Map<String, Integer> PLAYER_TICK_INTERVAL = new ConcurrentHashMap<String, Integer>();
    private static final Map<String, Integer> PLAYER_TICK_COUNTER = new ConcurrentHashMap<String, Integer>();
    public static final class_1293 HIGH_LIGHT = new class_1293(class_1294.field_5912, Integer.MAX_VALUE);
    public static final Map<String, String> LEADER_LIST = new HashMap<String, String>();

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"leader").requires(source -> CommandHelper.canUseCommand(source, AmsServerSettings.commandPlayerLeader))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> LeaderCommandRegistry.add(((class_2168)context.getSource()).method_9211(), (class_1657)class_2186.method_9315((CommandContext)context, (String)"player")))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> LeaderCommandRegistry.remove(((class_2168)context.getSource()).method_9211(), (class_1657)class_2186.method_9315((CommandContext)context, (String)"player")))))).then(class_2170.method_9247((String)"removeAll").executes(context -> LeaderCommandRegistry.removeAll(((class_2168)context.getSource()).method_9211(), (class_1657)((class_2168)context.getSource()).method_9207())))).then(class_2170.method_9247((String)"list").executes(context -> LeaderCommandRegistry.list((class_1657)((class_2168)context.getSource()).method_9207())))).then(class_2170.method_9247((String)"help").executes(context -> LeaderCommandRegistry.help((class_1657)((class_2168)context.getSource()).method_9207())))).then(class_2170.method_9247((String)"broadcastLeaderPos").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9247((String)"interval").then(class_2170.method_9244((String)"interval", (ArgumentType)IntegerArgumentType.integer()).suggests(new SetSuggestionProvider<Integer>(suggestionIntervalOptions)).executes(context -> LeaderCommandRegistry.broadcastPosTickInterval((class_1657)class_2186.method_9315((CommandContext)context, (String)"player"), ((class_2168)context.getSource()).method_9211(), IntegerArgumentType.getInteger((CommandContext)context, (String)"interval"))))))));
    }

    public static int broadcastPosTickInterval(class_1657 targetPlayer, MinecraftServer server, int interval) {
        if (!LEADER_LIST.containsKey(LeaderCommandRegistry.getPlayerName(targetPlayer))) {
            Messenger.sendServerMessage(server, (class_2561)Messenger.s(String.format(MSG_HEAD + LeaderCommandRegistry.getPlayerName(targetPlayer) + " " + translator.tr("is_not_leader", new Object[0]).getString(), new Object[0])).method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}));
            return 0;
        }
        String playerUUID = LeaderCommandRegistry.getPlayerUUID(targetPlayer);
        PLAYER_TICK_INTERVAL.put(playerUUID, interval);
        PLAYER_TICK_COUNTER.put(playerUUID, 0);
        if (LeaderCommandRegistry.canBroadcastPos(targetPlayer)) {
            WhereCommandRegistry.sendMessage(targetPlayer);
        }
        return 1;
    }

    public static void tick() {
        if (!(Objects.equals(AmsServerSettings.commandPlayerLeader, "false") || PLAYER_TICK_INTERVAL.isEmpty() || PLAYER_TICK_COUNTER.isEmpty())) {
            int interval;
            String playerUUID;
            ArrayList<String> needRemovePlayer = new ArrayList<String>();
            for (Map.Entry<String, Integer> entry : PLAYER_TICK_INTERVAL.entrySet()) {
                playerUUID = entry.getKey();
                interval = entry.getValue();
                if (interval > -1 && LEADER_LIST.containsValue(playerUUID)) continue;
                needRemovePlayer.add(playerUUID);
            }
            needRemovePlayer.forEach(uuid -> {
                PLAYER_TICK_INTERVAL.remove(uuid);
                PLAYER_TICK_COUNTER.remove(uuid);
            });
            for (Map.Entry<String, Integer> entry : PLAYER_TICK_INTERVAL.entrySet()) {
                playerUUID = entry.getKey();
                interval = entry.getValue();
                int tickCounter = PLAYER_TICK_COUNTER.getOrDefault(playerUUID, 0);
                if (++tickCounter >= interval && MinecraftServerUtil.serverIsRunning()) {
                    class_3222 player = MinecraftServerUtil.getServer().method_3760().method_14602(UUID.fromString(playerUUID));
                    if (LeaderCommandRegistry.canBroadcastPos((class_1657)player)) {
                        WhereCommandRegistry.sendMessage((class_1657)player);
                    }
                    PLAYER_TICK_COUNTER.put(playerUUID, 0);
                    continue;
                }
                PLAYER_TICK_COUNTER.put(playerUUID, tickCounter);
            }
        }
    }

    private static boolean canBroadcastPos(class_1657 player) {
        return player != null && player.method_5805() && LEADER_LIST.containsValue(LeaderCommandRegistry.getPlayerUUID(player)) && LEADER_LIST.containsKey(LeaderCommandRegistry.getPlayerName(player));
    }

    private static int add(MinecraftServer server, class_1657 targetPlayer) {
        if (!LEADER_LIST.containsValue(LeaderCommandRegistry.getPlayerUUID(targetPlayer))) {
            targetPlayer.method_6092(HIGH_LIGHT);
            Messenger.sendServerMessage(server, (class_2561)Messenger.s(String.format("%s %s %s", MSG_HEAD, LeaderCommandRegistry.getPlayerName(targetPlayer), translator.tr("add", new Object[0]).getString())).method_27692(class_124.field_1080));
            LEADER_LIST.put(LeaderCommandRegistry.getPlayerName(targetPlayer), LeaderCommandRegistry.getPlayerUUID(targetPlayer));
            LeaderCommandRegistry.saveToJson(server);
        } else {
            Messenger.sendServerMessage(server, (class_2561)Messenger.s(MSG_HEAD + LeaderCommandRegistry.getPlayerName(targetPlayer) + " " + translator.tr("is_already_leader", new Object[0]).getString()).method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}));
        }
        return 1;
    }

    private static int remove(MinecraftServer server, class_1657 targetPlayer) {
        if (LEADER_LIST.containsValue(LeaderCommandRegistry.getPlayerUUID(targetPlayer))) {
            targetPlayer.method_6016(HIGH_LIGHT.method_5579());
            Messenger.sendServerMessage(server, (class_2561)Messenger.s(String.format("%s %s %s", MSG_HEAD, LeaderCommandRegistry.getPlayerName(targetPlayer), translator.tr("remove", new Object[0]).getString())).method_27692(class_124.field_1080));
            LEADER_LIST.remove(LeaderCommandRegistry.getPlayerName(targetPlayer), LeaderCommandRegistry.getPlayerUUID(targetPlayer));
            LeaderCommandRegistry.saveToJson(server);
        } else {
            Messenger.sendServerMessage(server, (class_2561)Messenger.s(String.format(MSG_HEAD + LeaderCommandRegistry.getPlayerName(targetPlayer) + " " + translator.tr("is_not_leader", new Object[0]).getString(), new Object[0])).method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}));
        }
        return 1;
    }

    private static int removeAll(MinecraftServer server, class_1657 player) {
        Iterator<Map.Entry<String, String>> iterator = LEADER_LIST.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            String playerUUID = entry.getValue();
            class_3222 targetPlayer = server.method_3760().method_14602(UUID.fromString(playerUUID));
            if (targetPlayer != null) {
                targetPlayer.method_6016(HIGH_LIGHT.method_5579());
            }
            iterator.remove();
        }
        LEADER_LIST.clear();
        LeaderCommandRegistry.saveToJson(server);
        player.method_7353((class_2561)Messenger.s(MSG_HEAD + translator.tr("removeAll", new Object[0]).getString()).method_27692(class_124.field_1054), false);
        return 1;
    }

    private static int list(class_1657 player) {
        String LINE = "-----------------------------------------";
        player.method_7353((class_2561)Messenger.s(translator.tr("list", new Object[0]).getString() + "\n" + "-----------------------------------------").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067}), false);
        for (Map.Entry<String, String> entry : LEADER_LIST.entrySet()) {
            String playerName = entry.getKey();
            String playerUUID = LeaderCommandRegistry.getPlayerUUID(player);
            player.method_7353((class_2561)Messenger.s(playerName + " - " + playerUUID).method_27692(class_124.field_1062), false);
        }
        return 1;
    }

    private static int help(class_1657 player) {
        String addHelp = translator.tr("help.add", new Object[0]).getString();
        String removeHelp = translator.tr("help.remove", new Object[0]).getString();
        String removeAllHelp = translator.tr("help.removeAll", new Object[0]).getString();
        String broadcastLeaderPos = translator.tr("help.broadcast_leader_pos", new Object[0]).getString();
        String listHelp = translator.tr("help.list", new Object[0]).getString();
        player.method_7353((class_2561)Messenger.s(addHelp + "\n" + removeHelp + "\n" + removeAllHelp + "\n" + broadcastLeaderPos + "\n" + listHelp).method_10862(class_2583.field_24360.method_10977(class_124.field_1080)), false);
        return 1;
    }

    public static void onPlayerLoggedIn(class_1657 player) {
        if (player.method_6088().containsKey(HIGH_LIGHT.method_5579()) && !LEADER_LIST.containsValue(LeaderCommandRegistry.getPlayerUUID(player)) && !LEADER_LIST.containsKey(LeaderCommandRegistry.getPlayerName(player))) {
            player.method_6016(HIGH_LIGHT.method_5579());
        }
        if (LEADER_LIST.containsValue(player.method_5845())) {
            player.method_6092(HIGH_LIGHT);
        }
    }

    private static String getPlayerName(class_1657 player) {
        return player.method_7334().getName();
    }

    private static String getPlayerUUID(class_1657 player) {
        return player.method_5845();
    }

    private static void saveToJson(MinecraftServer server) {
        String CONFIG_FILE_PATH = LeaderConfig.getPath(server);
        LeaderConfig.saveToJson(LEADER_LIST, CONFIG_FILE_PATH);
    }
}

