/*
 * Decompiled with CFR 0.152.
 */
package club.mcams.carpet.config.rule.commandCustomCommandPermissionLevel;

import club.mcams.carpet.AmsServer;
import club.mcams.carpet.commands.rule.commandCustomCommandPermissionLevel.CustomCommandPermissionLevelRegistry;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public class CustomCommandPermissionLevelConfig {
    public static void loadFromJson(String configFilePath) {
        Gson gson = new Gson();
        Path path = Paths.get(configFilePath, new String[0]);
        CustomCommandPermissionLevelRegistry.COMMAND_PERMISSION_MAP.clear();
        if (Files.exists(path, new LinkOption[0])) {
            try {
                String json = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
                Type type = new TypeToken<Map<String, Integer>>(){}.getType();
                Map simplifiedMap = (Map)gson.fromJson(json, type);
                CustomCommandPermissionLevelRegistry.COMMAND_PERMISSION_MAP.putAll(simplifiedMap);
            }
            catch (IOException e) {
                AmsServer.LOGGER.warn("Failed to load config", (Throwable)e);
            }
        }
    }

    public static void saveToJson(Map<String, Integer> customCommandPermissionLevelMap, String configFilePath) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        HashMap<String, Integer> simplifiedMap = new HashMap<String, Integer>(customCommandPermissionLevelMap);
        String json = gson.toJson(simplifiedMap);
        try {
            Path path = Paths.get(configFilePath, new String[0]);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.write(path, json.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            AmsServer.LOGGER.warn("Failed to save config", (Throwable)e);
        }
    }

    public static String getPath(MinecraftServer server) {
        return server.method_27050(class_5218.field_24188).resolve("carpetamsaddition/customCommandPermissionLevel.json").toString();
    }
}

