/*
 * Decompiled with CFR 0.152.
 */
package club.mcams.carpet.commands.rule.commandGetClientPlayerFps;

import club.mcams.carpet.AmsServerSettings;
import club.mcams.carpet.helpers.FakePlayerHelper;
import club.mcams.carpet.network.payloads.rule.commandGetClientPlayerFPS.ClientPlayerFpsPayload_S2C;
import club.mcams.carpet.translations.Translator;
import club.mcams.carpet.utils.CommandHelper;
import club.mcams.carpet.utils.Messenger;
import club.mcams.carpet.utils.NetworkUtil;
import club.mcams.carpet.utils.PlayerUtil;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_3222;

public class GetClientPlayerFpsRegistry {
    private static final Translator tr = new Translator("command.getClientPlayerFps");
    private static final Map<UUID, class_2168> pendingQueries = new ConcurrentHashMap<UUID, class_2168>();

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"getClientPlayerFps").requires(source -> CommandHelper.canUseCommand(source, AmsServerSettings.commandGetClientPlayerFps))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(ctx -> GetClientPlayerFpsRegistry.requestFps(class_2186.method_9315((CommandContext)ctx, (String)"player"), (class_2168)ctx.getSource())))).then(class_2170.method_9247((String)"help").executes(ctx -> GetClientPlayerFpsRegistry.help((class_2168)ctx.getSource()))));
    }

    private static int requestFps(class_3222 targetPlayer, class_2168 source) {
        pendingQueries.put(targetPlayer.method_5667(), source);
        NetworkUtil.sendS2CPacketIfSupport(targetPlayer, ClientPlayerFpsPayload_S2C.create(targetPlayer.method_5667()));
        return 1;
    }

    public static void sendFpsResult(UUID playerUuid, int fps) {
        class_3222 player;
        class_2168 source = pendingQueries.remove(playerUuid);
        if (source != null && !FakePlayerHelper.isFakePlayer((class_1657)(player = PlayerUtil.getServerPlayerEntity(playerUuid))) && player != null) {
            Messenger.tell(source, Messenger.formatting(tr.tr("feedback", PlayerUtil.getName((class_1657)player), String.valueOf(fps)), class_124.field_1060));
        }
    }

    private static int help(class_2168 source) {
        Messenger.tell(source, Messenger.formatting(tr.tr("help", new Object[0]), class_124.field_1080));
        return 1;
    }
}

