/*
 * Decompiled with CFR 0.152.
 */
package club.mcams.carpet.config.rule.amsUpdateSuppressionCrashFix;

import club.mcams.carpet.AmsServer;
import club.mcams.carpet.commands.rule.amsUpdateSuppressionCrashFix.AmsUpdateSuppressionCrashFixCommandRegistry;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public class ForceModeCommandConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void saveConfigToJson(MinecraftServer server) {
        boolean dirsCreated;
        File configFile = new File(ForceModeCommandConfig.getPath(server));
        JsonObject json = new JsonObject();
        if (!configFile.getParentFile().exists() && !(dirsCreated = configFile.getParentFile().mkdirs())) {
            AmsServer.LOGGER.error("Failed to create directories for config file: {}", (Object)configFile.getParentFile().getPath());
            return;
        }
        json.addProperty("amsUpdateSuppressionCrashFixForceMode", Boolean.valueOf(AmsUpdateSuppressionCrashFixCommandRegistry.amsUpdateSuppressionCrashFixForceMode));
        try (FileWriter writer = new FileWriter(configFile);){
            GSON.toJson((JsonElement)json, (Appendable)writer);
        }
        catch (IOException e) {
            AmsServer.LOGGER.warn("Failed to save config", (Throwable)e);
        }
    }

    public static void loadConfigFromJson(MinecraftServer server) {
        File configFile = new File(ForceModeCommandConfig.getPath(server));
        if (configFile.exists()) {
            try (FileReader reader = new FileReader(configFile);){
                JsonObject json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                if (json.has("amsUpdateSuppressionCrashFixForceMode")) {
                    AmsUpdateSuppressionCrashFixCommandRegistry.amsUpdateSuppressionCrashFixForceMode = json.get("amsUpdateSuppressionCrashFixForceMode").getAsBoolean();
                }
            }
            catch (IOException e) {
                AmsServer.LOGGER.warn("Failed to load config", (Throwable)e);
            }
        }
    }

    public static String getPath(MinecraftServer server) {
        return server.method_27050(class_5218.field_24188).resolve("carpetamsaddition/amsUpdateSuppressionCrashFixForceMode.json").toString();
    }
}

