/*
 * Decompiled with CFR 0.152.
 */
package club.mcams.carpet.commands.rule.commandCustomMovableBlock;

import club.mcams.carpet.AmsServerSettings;
import club.mcams.carpet.config.rule.commandCustomMovableBlock.CustomMovableBlockConfig;
import club.mcams.carpet.translations.Translator;
import club.mcams.carpet.utils.CommandHelper;
import club.mcams.carpet.utils.Messenger;
import club.mcams.carpet.utils.RegexTools;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2257;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

public class CustomMovableBlockCommandRegistry {
    private static final Translator translator = new Translator("command.customMovableBlock");
    private static final String MSG_HEAD = "<customMovableBlock> ";
    public static final List<String> CUSTOM_MOVABLE_BLOCKS = new ArrayList<String>();

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandRegistryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"customMovableBlock").requires(source -> CommandHelper.canUseCommand(source, AmsServerSettings.commandCustomMovableBlock))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"block", (ArgumentType)class_2257.method_9653((class_7157)commandRegistryAccess)).executes(context -> CustomMovableBlockCommandRegistry.add((class_1657)((class_2168)context.getSource()).method_9207(), class_2257.method_9655((CommandContext)context, (String)"block").method_9494()))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"block", (ArgumentType)class_2257.method_9653((class_7157)commandRegistryAccess)).executes(context -> CustomMovableBlockCommandRegistry.remove((class_1657)((class_2168)context.getSource()).method_9207(), class_2257.method_9655((CommandContext)context, (String)"block").method_9494()))))).then(class_2170.method_9247((String)"removeAll").executes(context -> CustomMovableBlockCommandRegistry.removeAll((class_1657)((class_2168)context.getSource()).method_9207())))).then(class_2170.method_9247((String)"list").executes(context -> CustomMovableBlockCommandRegistry.list(((class_2168)context.getSource()).method_9207())))).then(class_2170.method_9247((String)"help").executes(context -> CustomMovableBlockCommandRegistry.help(((class_2168)context.getSource()).method_9207()))));
    }

    private static int add(class_1657 player, class_2680 blockState) {
        if (!CUSTOM_MOVABLE_BLOCKS.contains(CustomMovableBlockCommandRegistry.getBlockName(blockState))) {
            CUSTOM_MOVABLE_BLOCKS.add(CustomMovableBlockCommandRegistry.getBlockName(blockState));
            CustomMovableBlockCommandRegistry.saveToJson();
            player.method_7353((class_2561)Messenger.s("<customMovableBlock> + " + CustomMovableBlockCommandRegistry.getBlockName(blockState)).method_27692(class_124.field_1060), false);
        } else {
            player.method_7353((class_2561)Messenger.s(MSG_HEAD + CustomMovableBlockCommandRegistry.getBlockName(blockState) + translator.tr("already_exists", new Object[0]).getString()).method_27692(class_124.field_1054), false);
        }
        return 1;
    }

    private static int remove(class_1657 player, class_2680 blockState) {
        if (CUSTOM_MOVABLE_BLOCKS.contains(CustomMovableBlockCommandRegistry.getBlockName(blockState))) {
            CUSTOM_MOVABLE_BLOCKS.remove(CustomMovableBlockCommandRegistry.getBlockName(blockState));
            CustomMovableBlockCommandRegistry.saveToJson();
            player.method_7353((class_2561)Messenger.s("<customMovableBlock> - " + CustomMovableBlockCommandRegistry.getBlockName(blockState)).method_27692(class_124.field_1061), false);
        } else {
            player.method_7353((class_2561)Messenger.s(MSG_HEAD + CustomMovableBlockCommandRegistry.getBlockName(blockState) + translator.tr("not_found", new Object[0]).getString()).method_27692(class_124.field_1061), false);
        }
        return 1;
    }

    private static int removeAll(class_1657 player) {
        CUSTOM_MOVABLE_BLOCKS.clear();
        CustomMovableBlockCommandRegistry.saveToJson();
        player.method_7353((class_2561)Messenger.s(MSG_HEAD + translator.tr("removeAll", new Object[0]).getString()).method_27692(class_124.field_1061), false);
        return 1;
    }

    private static int list(class_3222 player) {
        player.method_7353((class_2561)Messenger.s(translator.tr("list", new Object[0]).getString() + "\n-------------------------------").method_27692(class_124.field_1060), false);
        for (String blockName : CUSTOM_MOVABLE_BLOCKS) {
            player.method_7353((class_2561)Messenger.s(blockName).method_27692(class_124.field_1060), false);
        }
        return 1;
    }

    private static int help(class_3222 player) {
        String setHelpText = translator.tr("help.set", new Object[0]).getString();
        String removeHelpText = translator.tr("help.remove", new Object[0]).getString();
        String removeAllHelpText = translator.tr("help.removeAll", new Object[0]).getString();
        String listHelpText = translator.tr("help.list", new Object[0]).getString();
        player.method_7353((class_2561)Messenger.s("\n" + setHelpText + "\n" + removeHelpText + "\n" + removeAllHelpText + "\n" + listHelpText).method_10862(class_2583.field_24360.method_10977(class_124.field_1080)), false);
        return 1;
    }

    private static void saveToJson() {
        CustomMovableBlockConfig.getInstance().saveToJson(CUSTOM_MOVABLE_BLOCKS);
    }

    private static String getBlockName(class_2680 blockState) {
        return RegexTools.getBlockRegisterName(blockState);
    }
}

