/*
 * Decompiled with CFR 0.152.
 */
package club.mcams.carpet.config.template;

import club.mcams.carpet.AmsServer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Map;

public abstract class AbstractMapJsonConfig<K, V> {
    protected final Path configPath;
    protected final Gson gson;
    private final Type mapType;

    protected AbstractMapJsonConfig(Path configPath) {
        this.configPath = configPath;
        this.gson = new GsonBuilder().setPrettyPrinting().create();
        this.mapType = TypeToken.getParameterized(Map.class, (Type[])new Type[]{this.getKeyType(), this.getValueType()}).getType();
    }

    protected abstract Class<K> getKeyType();

    protected abstract Class<V> getValueType();

    public void loadFromJson(Map<K, V> targetMap) {
        targetMap.clear();
        try {
            if (Files.notExists(this.configPath, new LinkOption[0])) {
                this.saveToJson(Collections.emptyMap());
                return;
            }
            byte[] bytes = Files.readAllBytes(this.configPath);
            Map loadedMap = (Map)this.gson.fromJson(new String(bytes, StandardCharsets.UTF_8), this.mapType);
            if (loadedMap != null) {
                targetMap.putAll(loadedMap);
            }
        }
        catch (IOException e) {
            AmsServer.LOGGER.error("Failed to load map config: {}", (Object)this.configPath, (Object)e);
        }
    }

    public void saveToJson(Map<K, V> map) {
        try {
            Files.createDirectories(this.configPath.getParent(), new FileAttribute[0]);
            Files.write(this.configPath, this.gson.toJson(map, this.mapType).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            AmsServer.LOGGER.error("Failed to save map config: {}", (Object)this.configPath, (Object)e);
        }
    }
}

