/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.geng.init;

import net.mcreator.geng.potion.GetRichQuickMobEffect;
import net.mcreator.geng.potion.ResourceDepletionMobEffect;
import net.mcreator.geng.potion.WeightGainMobEffect;
import net.mcreator.geng.procedures.GetRichQuickOverProcedure;
import net.mcreator.geng.procedures.ResourceDepletionOverProcedure;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber
public class GengModMobEffects {
    public static final DeferredRegister<MobEffect> REGISTRY = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)"geng");
    public static final DeferredHolder<MobEffect, MobEffect> WEIGHT_GAIN = REGISTRY.register("weight_gain", () -> new WeightGainMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> GET_RICH_QUICK = REGISTRY.register("get_rich_quick", () -> new GetRichQuickMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> RESOURCE_DEPLETION = REGISTRY.register("resource_depletion", () -> new ResourceDepletionMobEffect());

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            GengModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            GengModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    private static void expireEffects(Entity entity, MobEffectInstance effectInstance) {
        if (effectInstance.getEffect().is(GET_RICH_QUICK)) {
            GetRichQuickOverProcedure.execute((LevelAccessor)entity.level(), entity);
        } else if (effectInstance.getEffect().is(RESOURCE_DEPLETION)) {
            ResourceDepletionOverProcedure.execute((LevelAccessor)entity.level(), entity.getX(), entity.getY(), entity.getZ(), entity);
        }
    }
}

