/*
 * Decompiled with CFR 0.152.
 */
package net.idothehax.blackhole;

import java.util.List;
import net.idothehax.blackhole.BlackHole;
import net.idothehax.blackhole.config.BlackHoleConfig;
import net.idothehax.blackhole.mixin.DisplayEntityAccessor;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1540;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2806;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5819;
import net.minecraft.class_811;
import net.minecraft.class_8113;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class BlackHoleBlockEntity
extends class_2586 {
    public float scale = 1.0f;
    public boolean isGrowing = true;
    @Nullable
    private class_8113.class_8122 itemDisplayEntity;
    private class_1923 chunkPos;
    private boolean chunksLoaded = false;
    private int recreateAttempts = 0;
    private static final int MAX_RECREATE_ATTEMPTS = 3;
    private final boolean isMarkedForRemoval = false;
    private int tickCounter = 0;
    private double currentBreakRadius = 0.0;
    private boolean shouldFollow;
    public double followRange = BlackHoleConfig.getDefaultFollowRange();

    public BlackHoleBlockEntity(class_2338 pos, class_2680 state) {
        super(BlackHole.BLACK_HOLE_BLOCK_ENTITY, pos, state);
        this.chunkPos = new class_1923(pos);
        this.shouldFollow = true;
    }

    public void startGrowth() {
        if (this.field_11863 != null && !this.field_11863.method_8320(this.field_11867).method_27852((class_2248)BlackHole.BLACK_HOLE_BLOCK)) {
            BlackHole.LOGGER.warn("Cannot start growth at " + String.valueOf(this.field_11867) + " - block is not a black hole block");
            return;
        }
        this.isGrowing = true;
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            if (this.itemDisplayEntity != null && !this.itemDisplayEntity.method_31481()) {
                BlackHole.LOGGER.info("Discarding existing display entity at " + String.valueOf(this.itemDisplayEntity.method_19538()));
                this.itemDisplayEntity.method_31472();
            }
            this.itemDisplayEntity = null;
            class_8113.class_8122 itemDisplay = new class_8113.class_8122(class_1299.field_42456, (class_1937)serverWorld);
            class_243 positionOfHole = new class_243((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5);
            itemDisplay.method_5808(positionOfHole.field_1352, positionOfHole.field_1351, positionOfHole.field_1350, 0.0f, 0.0f);
            itemDisplay.method_5875(true);
            itemDisplay.method_48897(new class_1799((class_1935)BlackHole.BLACK_HOLE_ITEM));
            itemDisplay.method_48896(class_811.field_4319);
            ((DisplayEntityAccessor)itemDisplay).invokeSetBillboardMode(class_8113.class_8114.field_42409);
            this.setScale(itemDisplay, new Vector3f(this.scale), positionOfHole);
            ((DisplayEntityAccessor)itemDisplay).invokeSetInterpolationDuration(20);
            ((DisplayEntityAccessor)itemDisplay).invokeSetStartInterpolation(0);
            boolean spawned = serverWorld.method_8649((class_1297)itemDisplay);
            BlackHole.LOGGER.info("Black hole display entity spawned: " + spawned + " at " + String.valueOf(positionOfHole) + ", UUID: " + String.valueOf(itemDisplay.method_5667()));
            if (!spawned) {
                BlackHole.LOGGER.warn("Failed to spawn black hole display entity at " + String.valueOf(positionOfHole));
                return;
            }
            this.itemDisplayEntity = itemDisplay;
            this.recreateAttempts = 0;
            serverWorld.method_64310(this.field_11867, this.method_11010().method_26204(), 1);
        }
    }

    private void moveBlackHole(class_3218 serverWorld, class_2338 newBlockPos) {
        class_1923 newChunkPos = new class_1923(newBlockPos);
        try {
            if (!serverWorld.method_8393(newChunkPos.field_9181, newChunkPos.field_9180)) {
                serverWorld.method_22342(newChunkPos.field_9181, newChunkPos.field_9180, class_2806.field_12803);
            }
        }
        catch (Exception e) {
            BlackHole.LOGGER.error("Failed to load chunk at " + String.valueOf(newChunkPos) + ": " + e.getMessage());
            return;
        }
        class_2680 currentState = serverWorld.method_8320(this.field_11867);
        if (currentState.method_27852((class_2248)BlackHole.BLACK_HOLE_BLOCK)) {
            serverWorld.method_8652(this.field_11867, class_2246.field_10124.method_9564(), 3);
            serverWorld.method_8652(newBlockPos, BlackHole.BLACK_HOLE_BLOCK.method_9564(), 3);
            class_2586 class_25862 = serverWorld.method_8321(newBlockPos);
            if (class_25862 instanceof BlackHoleBlockEntity) {
                BlackHoleBlockEntity newEntity = (BlackHoleBlockEntity)class_25862;
                newEntity.scale = this.scale;
                newEntity.isGrowing = this.isGrowing;
                newEntity.shouldFollow = this.shouldFollow;
                newEntity.followRange = this.followRange;
                newEntity.chunkPos = newChunkPos;
                newEntity.chunksLoaded = false;
                newEntity.startGrowth();
                class_243 fromPos = class_243.method_24953((class_2382)this.field_11867);
                class_243 toPos = class_243.method_24953((class_2382)newBlockPos);
                class_243 direction = toPos.method_1020(fromPos).method_1029();
                for (int i = 0; i < 10; ++i) {
                    double progress = (double)i / 10.0;
                    class_243 particlePos = fromPos.method_1019(direction.method_1021(progress));
                    this.spawnParticlesIfEnabled(serverWorld, (class_2394)class_2398.field_11237, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 1, 0.1, 0.1, 0.1, 0.01);
                }
                BlackHole.LOGGER.info("Black hole moved from " + String.valueOf(this.field_11867) + " to " + String.valueOf(newBlockPos));
            }
        }
    }

    public void grow() {
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        class_243 positionOfHole = new class_243((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5);
        if (this.itemDisplayEntity != null && !this.itemDisplayEntity.method_31481()) {
            if (this.scale < BlackHoleConfig.getMaxScale()) {
                this.scale += BlackHoleConfig.getGrowthRate();
            }
            ((DisplayEntityAccessor)this.itemDisplayEntity).invokeSetInterpolationDuration(20);
            ((DisplayEntityAccessor)this.itemDisplayEntity).invokeSetStartInterpolation(0);
            ((DisplayEntityAccessor)this.itemDisplayEntity).invokeSetDisplayWidth(this.scale);
            ((DisplayEntityAccessor)this.itemDisplayEntity).invokeSetDisplayHeight(this.scale);
            this.setScale(this.itemDisplayEntity, new Vector3f(this.scale), positionOfHole);
            this.itemDisplayEntity.method_33574(positionOfHole);
            serverWorld.method_64310(this.field_11867, this.method_11010().method_26204(), 1);
        } else {
            BlackHole.LOGGER.warn("No item display entity found or it was removed. Attempting to recreate it.");
            this.startGrowth();
        }
    }

    public boolean isBlackHoleGrowing() {
        return this.isGrowing;
    }

    public void toggleBlackHoleGrowth() {
        class_1937 class_19372;
        boolean bl = this.isGrowing = !this.isGrowing;
        if (this.isGrowing && (class_19372 = this.field_11863) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            serverWorld.method_64310(this.field_11867, this.method_11010().method_26204(), 1);
        }
    }

    public void toggleFollowing() {
        this.shouldFollow = !this.shouldFollow;
        BlackHole.LOGGER.info("Black hole at " + String.valueOf(this.field_11867) + " following players: " + this.shouldFollow);
    }

    public boolean isFollowing() {
        return this.shouldFollow;
    }

    public void setFollowRange(double range) {
        this.followRange = range;
        BlackHole.LOGGER.info("Black hole at " + String.valueOf(this.field_11867) + " follow range set to: " + range);
    }

    public class_2338 getPosition() {
        return this.field_11867;
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 blockState) {
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        if (!blockState.method_27852((class_2248)BlackHole.BLACK_HOLE_BLOCK)) {
            BlackHole.LOGGER.warn("Black hole block entity exists but block is " + String.valueOf(blockState) + " at " + String.valueOf(pos));
            return;
        }
        if (!this.chunksLoaded || this.tickCounter % 100 == 0) {
            this.forceLoadChunks(serverWorld);
            this.chunksLoaded = true;
        }
        if (this.isGrowing) {
            this.grow();
        }
        if (this.itemDisplayEntity == null || this.itemDisplayEntity.method_31481()) {
            if (this.recreateAttempts < 3) {
                BlackHole.LOGGER.warn("Black hole display entity is null or removed during tick at " + String.valueOf(this.field_11867) + ". Attempt " + (this.recreateAttempts + 1) + " of 3 to recreate.");
                ++this.recreateAttempts;
                this.startGrowth();
                return;
            }
            BlackHole.LOGGER.error("Failed to recreate black hole display entity after 3 attempts at " + String.valueOf(this.field_11867) + ". Giving up.");
            this.isGrowing = false;
            return;
        }
        this.recreateAttempts = 0;
        class_243 expectedPos = new class_243((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5);
        if (!this.itemDisplayEntity.method_19538().equals((Object)expectedPos)) {
            BlackHole.LOGGER.warn("Display entity position mismatch at " + String.valueOf(this.field_11867) + ". Expected: " + String.valueOf(expectedPos) + ", Actual: " + String.valueOf(this.itemDisplayEntity.method_19538()));
            this.itemDisplayEntity.method_33574(expectedPos);
        }
        double blackHoleMass = 4.1887902047863905 * (double)this.scale * (double)this.scale * (double)this.scale;
        double effectRadius = this.scale;
        class_238 areaOfEffect = new class_238(this.field_11867).method_1014(effectRadius);
        ++this.tickCounter;
        if (this.shouldFollow && this.tickCounter % BlackHoleConfig.getPlayerDetectionInterval() == 0) {
            BlackHole.LOGGER.debug("Checking for player to follow at " + String.valueOf(this.field_11867) + ", shouldFollow: " + this.shouldFollow);
            class_1657 closestPlayer = null;
            double closestDistance = this.followRange * this.followRange;
            for (class_1657 player : serverWorld.method_18456()) {
                if (player.method_68878() || player.method_7325()) {
                    BlackHole.LOGGER.debug("Skipping player " + player.method_5477().getString() + " (creative/spectator)");
                    continue;
                }
                double distance = player.method_5707(class_243.method_24953((class_2382)this.field_11867));
                BlackHole.LOGGER.debug("Player " + player.method_5477().getString() + " at distance " + Math.sqrt(distance));
                if (!(distance < closestDistance)) continue;
                closestDistance = distance;
                closestPlayer = player;
            }
            if (closestPlayer != null) {
                BlackHole.LOGGER.debug("Closest player: " + closestPlayer.method_5477().getString() + " at " + String.valueOf(closestPlayer.method_19538()));
                class_243 currentPosition = class_243.method_24953((class_2382)this.field_11867);
                class_243 playerPosition = closestPlayer.method_19538();
                class_243 movementDirection = playerPosition.method_1020(currentPosition).method_1029();
                class_243 newPosition = currentPosition.method_1019(movementDirection.method_1021(BlackHoleConfig.getMovementSpeed()));
                class_2338 newBlockPos = class_2338.method_49638((class_2374)newPosition);
                BlackHole.LOGGER.debug("Calculated new position: " + String.valueOf(newPosition) + ", new block pos: " + String.valueOf(newBlockPos));
                if (!newBlockPos.equals((Object)this.field_11867)) {
                    class_1923 newChunkPos = new class_1923(newBlockPos);
                    try {
                        if (!serverWorld.method_8393(newChunkPos.field_9181, newChunkPos.field_9180)) {
                            BlackHole.LOGGER.debug("Loading chunk " + String.valueOf(newChunkPos));
                            serverWorld.method_22342(newChunkPos.field_9181, newChunkPos.field_9180, class_2806.field_12803);
                        }
                        class_2680 stateAtNewPos = serverWorld.method_8320(newBlockPos);
                        BlackHole.LOGGER.debug("State at new pos: " + String.valueOf(stateAtNewPos));
                        if (stateAtNewPos.method_26215() || stateAtNewPos.method_45474()) {
                            BlackHole.LOGGER.info("Moving black hole to " + String.valueOf(newBlockPos));
                            this.moveBlackHole(serverWorld, newBlockPos);
                            return;
                        }
                        if (stateAtNewPos.method_26214((class_1922)serverWorld, newBlockPos) >= 0.0f) {
                            serverWorld.method_8652(newBlockPos, class_2246.field_10124.method_9564(), 48);
                            BlackHole.LOGGER.debug("Broke block at " + String.valueOf(newBlockPos) + " to allow movement");
                            this.moveBlackHole(serverWorld, newBlockPos);
                            return;
                        }
                        BlackHole.LOGGER.debug("Cannot move to " + String.valueOf(newBlockPos) + " - unbreakable block");
                    }
                    catch (Exception e) {
                        BlackHole.LOGGER.error("Failed to move black hole to " + String.valueOf(newChunkPos) + ": " + e.getMessage());
                        return;
                    }
                } else {
                    BlackHole.LOGGER.debug("New position same as current: " + String.valueOf(this.field_11867));
                }
            } else {
                BlackHole.LOGGER.debug("No eligible players found within range " + this.followRange);
            }
        }
        this.breakBlocksInRadius(serverWorld, areaOfEffect);
        List affectedEntities = serverWorld.method_8390(class_1297.class, areaOfEffect, entity -> {
            class_1657 player;
            return entity != this.itemDisplayEntity && entity.method_19538().method_1022(this.field_11867.method_46558()) < (double)this.scale && (!(entity instanceof class_1657) || !(player = (class_1657)entity).method_68878());
        });
        for (class_1297 entity2 : affectedEntities) {
            double mass;
            class_1657 player;
            double distanceToBlackHole = entity2.method_19538().method_1022(class_243.method_24953((class_2382)pos));
            if (!(!(distanceToBlackHole <= (double)(this.scale / 2.0f)) || entity2 instanceof class_1657 && (player = (class_1657)entity2).method_68878())) {
                if (entity2 instanceof class_1542) {
                    entity2.method_31472();
                    continue;
                }
                entity2.method_64397(serverWorld, this.field_11863.method_48963().method_48829(), Float.MAX_VALUE);
                continue;
            }
            if (entity2 instanceof class_1657) {
                mass = BlackHoleConfig.getPlayerMass();
            } else if (entity2 instanceof class_1540) {
                mass = BlackHoleConfig.getBlockMass();
            } else if (entity2 instanceof class_1542) {
                mass = BlackHoleConfig.getItemEntityMass();
            } else {
                if (!(entity2 instanceof class_1309)) continue;
                mass = BlackHoleConfig.getAnimalMass();
            }
            this.applyGravitationalPull(entity2.method_19538(), entity2, blackHoleMass, mass, serverWorld);
        }
        this.emitParticles(serverWorld);
    }

    private void breakBlocksInRadius(class_3218 serverWorld, class_238 areaOfEffect) {
        class_243 center = this.field_11867.method_46558();
        double maxBreakRadius = this.scale;
        double gravitationalRadius = this.scale * 2.0f;
        double radiusIncrement = 0.5;
        if (this.tickCounter % 5 == 0) {
            this.currentBreakRadius = Math.min(this.currentBreakRadius + radiusIncrement, maxBreakRadius);
        }
        int minX = class_3532.method_15357((double)(center.field_1352 - gravitationalRadius));
        int maxX = class_3532.method_15384((double)(center.field_1352 + gravitationalRadius));
        int minY = class_3532.method_15357((double)(center.field_1351 - gravitationalRadius));
        int maxY = class_3532.method_15384((double)(center.field_1351 + gravitationalRadius));
        int minZ = class_3532.method_15357((double)(center.field_1350 - gravitationalRadius));
        int maxZ = class_3532.method_15384((double)(center.field_1350 + gravitationalRadius));
        class_2338.class_2339 mutablePos = new class_2338.class_2339();
        class_5819 random = serverWorld.method_8409();
        int blocksProcessed = 0;
        for (int i = 0; i < BlackHoleConfig.getMaxBlocksPerTick() && blocksProcessed < BlackHoleConfig.getMaxBlocksPerTick(); ++i) {
            double probability;
            double angle = random.method_43058() * Math.PI * 2.0;
            double theta = random.method_43058() * Math.PI;
            double r = random.method_43058() * gravitationalRadius;
            int x = class_3532.method_15357((double)(center.field_1352 + r * Math.sin(theta) * Math.cos(angle)));
            int y = class_3532.method_15357((double)(center.field_1351 + r * Math.cos(theta)));
            int z = class_3532.method_15357((double)(center.field_1350 + r * Math.sin(theta) * Math.sin(angle)));
            if (x < minX || x > maxX || y < minY || y > maxY || z < minZ || z > maxZ) continue;
            mutablePos.method_10103(x, y, z);
            if (mutablePos.equals((Object)this.field_11867)) continue;
            double distanceToCenter = center.method_1022(class_243.method_24953((class_2382)mutablePos));
            class_2680 blockState = serverWorld.method_8320((class_2338)mutablePos);
            if (blockState.method_26215()) continue;
            if (distanceToCenter <= this.currentBreakRadius) {
                if (blockState.method_26204() instanceof class_2404 || blockState.method_26227().method_39360((class_3611)class_3612.field_15910) || blockState.method_26227().method_39360((class_3611)class_3612.field_15908)) {
                    serverWorld.method_8652((class_2338)mutablePos, class_2246.field_10124.method_9564(), 48);
                    this.spawnParticlesIfEnabled(serverWorld, (class_2394)class_2398.field_11202, (double)mutablePos.method_10263() + 0.5, (double)mutablePos.method_10264() + 0.5, (double)mutablePos.method_10260() + 0.5, 5, 0.2, 0.2, 0.2, 0.01);
                    ++blocksProcessed;
                    continue;
                }
                if (!(blockState.method_26214((class_1922)serverWorld, (class_2338)mutablePos) >= 0.0f)) continue;
                this.breakBlock(serverWorld, (class_2338)mutablePos, blockState);
                ++blocksProcessed;
                continue;
            }
            if (!(distanceToCenter <= gravitationalRadius)) continue;
            if (blockState.method_26204() instanceof class_2404 || blockState.method_26227().method_39360((class_3611)class_3612.field_15910)) {
                probability = 0.05 * (gravitationalRadius - distanceToCenter) / gravitationalRadius;
                if (!(random.method_43058() < probability)) continue;
                serverWorld.method_8650((class_2338)mutablePos, false);
                this.spawnParticlesIfEnabled(serverWorld, (class_2394)class_2398.field_11202, (double)mutablePos.method_10263() + 0.5, (double)mutablePos.method_10264() + 0.5, (double)mutablePos.method_10260() + 0.5, 3, 0.2, 0.2, 0.2, 0.01);
                ++blocksProcessed;
                continue;
            }
            if (!(blockState.method_26214((class_1922)serverWorld, (class_2338)mutablePos) >= 0.0f)) continue;
            probability = 0.05 * (gravitationalRadius - distanceToCenter) / gravitationalRadius;
            if (!(random.method_43058() < probability)) continue;
            this.createFallingBlock(serverWorld, (class_2338)mutablePos, blockState);
            ++blocksProcessed;
        }
        if (blocksProcessed >= BlackHoleConfig.getMaxBlocksPerTick()) {
            BlackHole.LOGGER.debug("Reached block processing limit of " + BlackHoleConfig.getMaxBlocksPerTick() + " at " + String.valueOf(this.field_11867));
        }
    }

    private void breakBlock(class_3218 serverWorld, class_2338 pos, class_2680 blockState) {
        if (this.shouldCreateFallingBlock(blockState) && serverWorld.field_9229.method_43057() < 0.3f) {
            this.createFallingBlock(serverWorld, pos, blockState);
        } else {
            serverWorld.method_8652(pos, class_2246.field_10124.method_9564(), 48);
            this.spawnParticlesIfEnabled(serverWorld, (class_2394)class_2398.field_11251, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 2, 0.2, 0.2, 0.2, 0.01);
        }
    }

    private boolean shouldCreateFallingBlock(class_2680 blockState) {
        class_2248 block = blockState.method_26204();
        return block != class_2246.field_9987 && block != class_2246.field_10124 && !(block instanceof class_2343) && !(block instanceof class_2404) && blockState.method_26214((class_1922)this.field_11863, this.field_11867) >= 0.0f && blockState.method_26214((class_1922)this.field_11863, this.field_11867) < 50.0f;
    }

    private void createFallingBlock(class_3218 serverWorld, class_2338 pos, class_2680 blockState) {
        class_1540 fallingBlock;
        if (!blockState.method_26215() && blockState.method_26214((class_1922)serverWorld, pos) >= 0.0f && (fallingBlock = class_1540.method_40005((class_1937)serverWorld, (class_2338)pos, (class_2680)blockState)) != null) {
            class_243 direction = this.field_11867.method_46558().method_1020(pos.method_46558()).method_1029();
            fallingBlock.method_18799(direction.method_1021(0.1));
            fallingBlock.field_6037 = true;
            serverWorld.method_8650(pos, false);
        }
    }

    private void forceLoadChunks(class_3218 serverWorld) {
        int dz;
        int dx;
        class_3215 chunkManager = serverWorld.method_14178();
        class_1923 currentChunkPos = new class_1923(this.field_11867);
        if (!currentChunkPos.equals((Object)this.chunkPos)) {
            chunkManager.method_66010(BlackHole.BLACK_HOLE_TICKET_TYPE, this.chunkPos, BlackHoleConfig.getChunkLoadRadius());
            for (dx = -BlackHoleConfig.getChunkLoadRadius(); dx <= BlackHoleConfig.getChunkLoadRadius(); ++dx) {
                for (dz = -BlackHoleConfig.getChunkLoadRadius(); dz <= BlackHoleConfig.getChunkLoadRadius(); ++dz) {
                    class_1923 oldChunkPos = new class_1923(this.chunkPos.field_9181 + dx, this.chunkPos.field_9180 + dz);
                    chunkManager.method_12124(oldChunkPos, false);
                }
            }
            this.chunkPos = currentChunkPos;
            BlackHole.LOGGER.debug("Removed chunk tickets for old position: " + String.valueOf(this.chunkPos));
        }
        chunkManager.method_66009(BlackHole.BLACK_HOLE_TICKET_TYPE, this.chunkPos, BlackHoleConfig.getChunkLoadRadius());
        for (dx = -BlackHoleConfig.getChunkLoadRadius(); dx <= BlackHoleConfig.getChunkLoadRadius(); ++dx) {
            for (dz = -BlackHoleConfig.getChunkLoadRadius(); dz <= BlackHoleConfig.getChunkLoadRadius(); ++dz) {
                class_1923 loadChunkPos = new class_1923(this.chunkPos.field_9181 + dx, this.chunkPos.field_9180 + dz);
                try {
                    serverWorld.method_22342(loadChunkPos.field_9181, loadChunkPos.field_9180, class_2806.field_12803);
                    chunkManager.method_12124(loadChunkPos, true);
                    continue;
                }
                catch (Exception e) {
                    BlackHole.LOGGER.error("Failed to force load chunk " + String.valueOf(loadChunkPos) + ": " + e.getMessage());
                    this.chunksLoaded = false;
                    return;
                }
            }
        }
        this.chunksLoaded = true;
        BlackHole.LOGGER.debug("Forced loaded chunks around " + String.valueOf(this.chunkPos));
    }

    private void emitParticles(class_3218 serverWorld) {
        double particleRadius = (double)this.scale * 1.2;
        int particleCount = Math.min(200, (int)(this.scale * 30.0f));
        if (particleRadius <= 0.0 || !BlackHoleConfig.areParticlesEnabled()) {
            return;
        }
        class_243 center = this.field_11867.method_46558();
        class_5819 random = serverWorld.method_8409();
        for (int i = 0; i < particleCount; ++i) {
            double angle = (double)i * Math.PI * 2.0 / (double)particleCount;
            double spiralRadius = particleRadius * (0.5 + 0.5 * random.method_43058());
            double heightVariation = (random.method_43058() - 0.5) * particleRadius;
            double xPos = center.method_10216() + spiralRadius * Math.cos(angle);
            double yPos = center.method_10214() + heightVariation;
            double zPos = center.method_10215() + spiralRadius * Math.sin(angle);
            if ((double)random.method_43057() < 0.7) {
                this.spawnParticlesIfEnabled(serverWorld, (class_2394)class_2398.field_11240, xPos, yPos, zPos, 1, 0.0, 0.0, 0.0, 0.0);
                continue;
            }
            if ((double)random.method_43057() < 0.5) {
                this.spawnParticlesIfEnabled(serverWorld, (class_2394)class_2398.field_11251, xPos, yPos, zPos, 1, 0.0, 0.0, 0.0, 0.0);
                continue;
            }
            this.spawnParticlesIfEnabled(serverWorld, (class_2394)class_2398.field_22246, xPos, yPos, zPos, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private void applyGravitationalPull(class_243 entityPos, class_1297 entity, double blackHoleMass, double entityMass, class_3218 serverWorld) {
        class_243 blackHolePos = this.field_11867.method_46558();
        double distanceToBlackHole = entityPos.method_1022(blackHolePos);
        if (distanceToBlackHole > 0.1) {
            class_243 directionFromEntityToHole = blackHolePos.method_1020(entityPos).method_1029();
            double forceMagnitude = BlackHoleConfig.getGravity() * entityMass * blackHoleMass / (distanceToBlackHole * distanceToBlackHole);
            forceMagnitude = Math.min(forceMagnitude, 5.0);
            class_243 velocityToAdd = directionFromEntityToHole.method_1021(forceMagnitude / 1000.0);
            entity.method_5762(velocityToAdd.field_1352, velocityToAdd.field_1351, velocityToAdd.field_1350);
            entity.field_6037 = true;
        }
    }

    private void setScale(class_8113.class_8122 itemDisplayEntity, Vector3f scale, class_243 pos) {
        itemDisplayEntity.method_5841().method_12778(DisplayEntityAccessor.getScale(), (Object)scale);
        itemDisplayEntity.method_33574(pos);
    }

    public void setScale(float size) {
        this.scale = size;
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            if (this.itemDisplayEntity != null) {
                class_243 positionOfHole = new class_243((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5);
                this.setScale(this.itemDisplayEntity, new Vector3f(this.scale), positionOfHole);
            }
        }
    }

    private void spawnParticlesIfEnabled(class_3218 serverWorld, class_2394 particleType, double x, double y, double z, int count, double deltaX, double deltaY, double deltaZ, double speed) {
        if (BlackHoleConfig.areParticlesEnabled()) {
            serverWorld.method_65096(particleType, x, y, z, count, deltaX, deltaY, deltaZ, speed);
        }
    }
}

