/*
 * Decompiled with CFR 0.152.
 */
package net.idothehax.blackhole.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.idothehax.blackhole.BlackHole;

public class BlackHoleConfig {
    private static float MAX_SCALE = 40.0f;
    private static double GRAVITY = 60.0;
    private static double PLAYER_MASS = 700.0;
    private static double BLOCK_MASS = 10.0;
    private static double ITEM_ENTITY_MASS = 0.1;
    private static double ANIMAL_MASS = 50.0;
    private static int CHUNK_LOAD_RADIUS = 2;
    private static int MAX_BLOCKS_PER_TICK = 500;
    private static double MOVEMENT_SPEED = 1.0;
    private static double DEFAULT_FOLLOW_RANGE = 256.0;
    private static int PLAYER_DETECTION_INTERVAL = 60;
    private static float GROWTH_RATE = 0.04f;
    private static boolean PARTICLES_ENABLED = true;
    private static final String CONFIG_FILE = "config/black_hole.json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void loadConfig() {
        Path configPath = Paths.get(CONFIG_FILE, new String[0]);
        if (Files.exists(configPath, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(configPath);){
                JsonObject json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                if (json.has("maxScale")) {
                    MAX_SCALE = json.get("maxScale").getAsFloat();
                }
                if (json.has("gravity")) {
                    GRAVITY = json.get("gravity").getAsDouble();
                }
                if (json.has("playerMass")) {
                    PLAYER_MASS = json.get("playerMass").getAsDouble();
                }
                if (json.has("blockMass")) {
                    BLOCK_MASS = json.get("blockMass").getAsDouble();
                }
                if (json.has("itemEntityMass")) {
                    ITEM_ENTITY_MASS = json.get("itemEntityMass").getAsDouble();
                }
                if (json.has("animalMass")) {
                    ANIMAL_MASS = json.get("animalMass").getAsDouble();
                }
                if (json.has("chunkLoadRadius")) {
                    CHUNK_LOAD_RADIUS = json.get("chunkLoadRadius").getAsInt();
                }
                if (json.has("maxBlocksPerTick")) {
                    MAX_BLOCKS_PER_TICK = json.get("maxBlocksPerTick").getAsInt();
                }
                if (json.has("movementSpeed")) {
                    MOVEMENT_SPEED = json.get("movementSpeed").getAsDouble();
                }
                if (json.has("defaultFollowRange")) {
                    DEFAULT_FOLLOW_RANGE = json.get("defaultFollowRange").getAsDouble();
                }
                if (json.has("playerDetectionInterval")) {
                    PLAYER_DETECTION_INTERVAL = json.get("playerDetectionInterval").getAsInt();
                }
                if (json.has("growthRate")) {
                    GROWTH_RATE = json.get("growthRate").getAsFloat();
                }
                if (json.has("particlesEnabled")) {
                    PARTICLES_ENABLED = json.get("particlesEnabled").getAsBoolean();
                }
                BlackHole.LOGGER.info("Loaded black hole config from config/black_hole.json");
            }
            catch (IOException e) {
                BlackHole.LOGGER.error("Failed to load black hole config: " + e.getMessage());
            }
        } else {
            BlackHole.LOGGER.info("No black hole config found, creating default config at config/black_hole.json");
            BlackHoleConfig.saveConfig();
        }
    }

    public static void saveConfig() {
        Path configDir = Paths.get("config", new String[0]);
        if (!Files.exists(configDir, new LinkOption[0])) {
            try {
                Files.createDirectories(configDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                BlackHole.LOGGER.error("Failed to create config directory: " + e.getMessage());
                return;
            }
        }
        JsonObject json = new JsonObject();
        json.addProperty("maxScale", (Number)Float.valueOf(MAX_SCALE));
        json.addProperty("gravity", (Number)GRAVITY);
        json.addProperty("playerMass", (Number)PLAYER_MASS);
        json.addProperty("blockMass", (Number)BLOCK_MASS);
        json.addProperty("itemEntityMass", (Number)ITEM_ENTITY_MASS);
        json.addProperty("animalMass", (Number)ANIMAL_MASS);
        json.addProperty("chunkLoadRadius", (Number)CHUNK_LOAD_RADIUS);
        json.addProperty("maxBlocksPerTick", (Number)MAX_BLOCKS_PER_TICK);
        json.addProperty("movementSpeed", (Number)MOVEMENT_SPEED);
        json.addProperty("defaultFollowRange", (Number)DEFAULT_FOLLOW_RANGE);
        json.addProperty("playerDetectionInterval", (Number)PLAYER_DETECTION_INTERVAL);
        json.addProperty("growthRate", (Number)Float.valueOf(GROWTH_RATE));
        json.addProperty("particlesEnabled", Boolean.valueOf(PARTICLES_ENABLED));
        try (BufferedWriter writer = Files.newBufferedWriter(Paths.get(CONFIG_FILE, new String[0]), new OpenOption[0]);){
            GSON.toJson((JsonElement)json, (Appendable)writer);
            BlackHole.LOGGER.info("Saved black hole config to config/black_hole.json");
        }
        catch (IOException e) {
            BlackHole.LOGGER.error("Failed to save black hole config: " + e.getMessage());
        }
    }

    public static float getMaxScale() {
        return MAX_SCALE;
    }

    public static double getGravity() {
        return GRAVITY;
    }

    public static double getPlayerMass() {
        return PLAYER_MASS;
    }

    public static double getBlockMass() {
        return BLOCK_MASS;
    }

    public static double getItemEntityMass() {
        return ITEM_ENTITY_MASS;
    }

    public static double getAnimalMass() {
        return ANIMAL_MASS;
    }

    public static int getChunkLoadRadius() {
        return CHUNK_LOAD_RADIUS;
    }

    public static int getMaxBlocksPerTick() {
        return MAX_BLOCKS_PER_TICK;
    }

    public static double getMovementSpeed() {
        return MOVEMENT_SPEED;
    }

    public static double getDefaultFollowRange() {
        return DEFAULT_FOLLOW_RANGE;
    }

    public static int getPlayerDetectionInterval() {
        return PLAYER_DETECTION_INTERVAL;
    }

    public static float getGrowthRate() {
        return GROWTH_RATE;
    }

    public static boolean areParticlesEnabled() {
        return PARTICLES_ENABLED;
    }

    public static void setMaxScale(float maxScale) {
        MAX_SCALE = maxScale;
        BlackHoleConfig.saveConfig();
    }

    public static void setGravity(double gravity) {
        GRAVITY = gravity;
        BlackHoleConfig.saveConfig();
    }

    public static void setPlayerMass(double playerMass) {
        PLAYER_MASS = playerMass;
        BlackHoleConfig.saveConfig();
    }

    public static void setBlockMass(double blockMass) {
        BLOCK_MASS = blockMass;
        BlackHoleConfig.saveConfig();
    }

    public static void setItemEntityMass(double itemEntityMass) {
        ITEM_ENTITY_MASS = itemEntityMass;
        BlackHoleConfig.saveConfig();
    }

    public static void setAnimalMass(double animalMass) {
        ANIMAL_MASS = animalMass;
        BlackHoleConfig.saveConfig();
    }

    public static void setChunkLoadRadius(int chunkLoadRadius) {
        CHUNK_LOAD_RADIUS = chunkLoadRadius;
        BlackHoleConfig.saveConfig();
    }

    public static void setMaxBlocksPerTick(int maxBlocksPerTick) {
        MAX_BLOCKS_PER_TICK = maxBlocksPerTick;
        BlackHoleConfig.saveConfig();
    }

    public static void setMovementSpeed(double movementSpeed) {
        MOVEMENT_SPEED = movementSpeed;
        BlackHoleConfig.saveConfig();
    }

    public static void setDefaultFollowRange(double defaultFollowRange) {
        DEFAULT_FOLLOW_RANGE = defaultFollowRange;
        BlackHoleConfig.saveConfig();
    }

    public static void setPlayerDetectionInterval(int playerDetectionInterval) {
        PLAYER_DETECTION_INTERVAL = playerDetectionInterval;
        BlackHoleConfig.saveConfig();
    }

    public static void setGrowthRate(float growthRate) {
        GROWTH_RATE = growthRate;
        BlackHoleConfig.saveConfig();
    }

    public static void setParticlesEnabled(boolean enabled) {
        PARTICLES_ENABLED = enabled;
        BlackHoleConfig.saveConfig();
    }

    public static void toggleParticles() {
        PARTICLES_ENABLED = !PARTICLES_ENABLED;
        BlackHoleConfig.saveConfig();
    }
}

