/*
 * Decompiled with CFR 0.152.
 */
package com.fisfis.siteverywhere;

import com.fisfis.siteverywhere.SitEverywhere;
import com.fisfis.siteverywhere.SitManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;

public class SitListener
implements Listener {
    private final SitEverywhere plugin;
    private final Map<UUID, Long> cooldown = new HashMap<UUID, Long>();

    public SitListener(SitEverywhere plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onBlockRightClick(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getClickedBlock();
        SitManager sitManager = this.plugin.getSitManager();
        if (player.getVehicle() == null && sitManager.isSitting(player)) {
            sitManager.unsitPlayer(player);
        }
        if (block == null || sitManager.isSitting(player) || !player.hasPermission("siteverywhere.block")) {
            return;
        }
        if (player.getItemInHand() != null && player.getItemInHand().getType() != Material.AIR) {
            return;
        }
        if (this.isSittable(block)) {
            sitManager.sitPlayerOnBlock(player, block);
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerRightClick(PlayerInteractAtEntityEvent event) {
        Player clicker = event.getPlayer();
        if (this.cooldown.containsKey(clicker.getUniqueId()) && System.currentTimeMillis() - this.cooldown.get(clicker.getUniqueId()) < 250L) {
            return;
        }
        this.cooldown.put(clicker.getUniqueId(), System.currentTimeMillis());
        if (!(event.getRightClicked() instanceof Player)) {
            return;
        }
        Player target = (Player)event.getRightClicked();
        SitManager sitManager = this.plugin.getSitManager();
        if (clicker.getVehicle() == null && sitManager.isSitting(clicker)) {
            sitManager.unsitPlayer(clicker);
        }
        if (sitManager.isSitting(clicker) || !clicker.hasPermission("siteverywhere.player")) {
            return;
        }
        sitManager.sitPlayerOnPlayer(clicker, target);
        event.setCancelled(true);
    }

    @EventHandler
    public void onDismount(VehicleExitEvent event) {
        if (!(event.getExited() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getExited();
        this.plugin.getSitManager().unsitPlayer(player);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.plugin.getSitManager().unsitPlayer(event.getPlayer());
    }

    private boolean isSittable(Block block) {
        String typeName = block.getType().name();
        return typeName.contains("STAIRS") || typeName.contains("SLAB") || typeName.contains("STEP") || typeName.contains("CARPET");
    }
}

