/*
 * Decompiled with CFR 0.152.
 */
package com.fisfis.siteverywhere;

import com.fisfis.siteverywhere.SitEverywhere;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class SitManager {
    private final SitEverywhere plugin;
    private final Map<UUID, ArmorStand> sittingPlayers = new HashMap<UUID, ArmorStand>();

    public SitManager(SitEverywhere plugin) {
        this.plugin = plugin;
    }

    public void sitPlayerOnGround(Player player) {
        Location sitLocation = player.getLocation().add(0.0, -1.7, 0.0);
        this.createStandAndSit(player, sitLocation);
    }

    public void sitPlayerOnBlock(Player player, Block block) {
        String typeName = block.getType().name();
        double offset = typeName.contains("CARPET") ? -1.45 : -0.95;
        Location sitLocation = block.getLocation().add(0.5, offset, 0.5);
        this.createStandAndSit(player, sitLocation);
    }

    public void sitPlayerOnPlayer(Player sitter, Player target) {
        if (target.getPassenger() != null) {
            sitter.sendMessage(this.plugin.getMessage("player-occupied"));
            return;
        }
        ArmorStand stand = this.createSitArmorStand(target.getLocation());
        stand.setPassenger((Entity)sitter);
        target.setPassenger((Entity)stand);
        this.sittingPlayers.put(sitter.getUniqueId(), stand);
    }

    public void unsitPlayer(Player player) {
        ArmorStand stand = this.sittingPlayers.remove(player.getUniqueId());
        if (stand != null) {
            stand.remove();
        }
    }

    private void createStandAndSit(Player player, Location location) {
        ArmorStand armorStand = this.createSitArmorStand(location);
        armorStand.setPassenger((Entity)player);
        this.sittingPlayers.put(player.getUniqueId(), armorStand);
    }

    private ArmorStand createSitArmorStand(Location location) {
        ArmorStand armorStand = (ArmorStand)location.getWorld().spawnEntity(location, EntityType.ARMOR_STAND);
        armorStand.setVisible(false);
        armorStand.setGravity(false);
        armorStand.setCanPickupItems(false);
        armorStand.setCustomName("SitStand");
        return armorStand;
    }

    public boolean isSitting(Player player) {
        return this.sittingPlayers.containsKey(player.getUniqueId());
    }

    public void clearAllSittingPlayers() {
        for (ArmorStand stand : this.sittingPlayers.values()) {
            stand.remove();
        }
        this.sittingPlayers.clear();
    }
}

