/*
 * Decompiled with CFR 0.152.
 */
package com.fisfis.siteverywhere;

import com.fisfis.siteverywhere.SitListener;
import com.fisfis.siteverywhere.SitManager;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SitEverywhere
extends JavaPlugin {
    private SitManager sitManager;
    private static String NO_PERMISSION_MSG;
    private static String ALREADY_SITTING_MSG;
    private static String PLAYER_ONLY_MSG;
    private static String PLAYER_OCCUPIED_MSG;

    public void onEnable() {
        this.sitManager = new SitManager(this);
        this.getServer().getPluginManager().registerEvents((Listener)new SitListener(this), (Plugin)this);
        this.saveDefaultConfig();
        this.loadMessages();
        this.getLogger().info("SitEverywhere enabled!");
    }

    public void onDisable() {
        if (this.sitManager != null) {
            this.sitManager.clearAllSittingPlayers();
        }
        this.getLogger().info("SitEverywhere disabled!");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!command.getName().equalsIgnoreCase("sit")) {
            return false;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.getMessage("player-only"));
            return true;
        }
        Player player = (Player)sender;
        if (player.getVehicle() == null && this.sitManager.isSitting(player)) {
            this.sitManager.unsitPlayer(player);
        }
        if (this.sitManager.isSitting(player)) {
            player.sendMessage(this.getMessage("already-sitting"));
            return true;
        }
        if (!player.hasPermission("siteverywhere.sit")) {
            player.sendMessage(this.getMessage("no-permission"));
            return true;
        }
        this.sitManager.sitPlayerOnGround(player);
        return true;
    }

    public SitManager getSitManager() {
        return this.sitManager;
    }

    private void loadMessages() {
        this.saveDefaultConfig();
        this.reloadConfig();
        NO_PERMISSION_MSG = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("messages.no-permission", "&cYou don't have permission to do that."));
        ALREADY_SITTING_MSG = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("messages.already-sitting", "&cYou are already sitting."));
        PLAYER_ONLY_MSG = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("messages.player-only", "&cThis command can only be used by players."));
        PLAYER_OCCUPIED_MSG = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("messages.player-occupied", "&cThat player already has someone on their shoulders!"));
    }

    public String getMessage(String key) {
        switch (key) {
            case "no-permission": {
                return NO_PERMISSION_MSG;
            }
            case "already-sitting": {
                return ALREADY_SITTING_MSG;
            }
            case "player-only": {
                return PLAYER_ONLY_MSG;
            }
            case "player-occupied": {
                return PLAYER_OCCUPIED_MSG;
            }
        }
        return "";
    }
}

