/*
 * Decompiled with CFR 0.152.
 */
package com.fisfis.siteverywhere;

import com.fisfis.siteverywhere.SitEverywhere;
import com.fisfis.siteverywhere.SitManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.type.Slab;
import org.bukkit.block.data.type.Stairs;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.spigotmc.event.entity.EntityDismountEvent;

public class SitListener
implements Listener {
    private final SitEverywhere plugin;
    private final Map<UUID, Long> cooldown = new HashMap<UUID, Long>();

    public SitListener(SitEverywhere plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onBlockRightClick(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getClickedBlock();
        SitManager sitManager = this.plugin.getSitManager();
        if (player.getVehicle() != null || sitManager.isSitting(player)) {
            return;
        }
        if (block == null || !player.hasPermission("siteverywhere.block")) {
            return;
        }
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        if (itemInHand != null && itemInHand.getType() != Material.AIR) {
            return;
        }
        if (this.isSittable(block)) {
            try {
                Slab slab;
                Bisected bisected;
                if (block.getBlockData() instanceof Bisected && (bisected = (Bisected)block.getBlockData()).getHalf() == Bisected.Half.TOP) {
                    return;
                }
                if (block.getBlockData() instanceof Slab && (slab = (Slab)block.getBlockData()).getType() == Slab.Type.TOP) {
                    return;
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            sitManager.sitPlayerOnBlock(player, block);
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerRightClick(PlayerInteractAtEntityEvent event) {
        Player clicker = event.getPlayer();
        if (this.cooldown.containsKey(clicker.getUniqueId()) && System.currentTimeMillis() - this.cooldown.get(clicker.getUniqueId()) < 250L) {
            return;
        }
        this.cooldown.put(clicker.getUniqueId(), System.currentTimeMillis());
        if (!(event.getRightClicked() instanceof Player)) {
            return;
        }
        Player target = (Player)event.getRightClicked();
        SitManager sitManager = this.plugin.getSitManager();
        if (clicker.getVehicle() != null || sitManager.isSitting(clicker)) {
            return;
        }
        if (!clicker.hasPermission("siteverywhere.player")) {
            return;
        }
        sitManager.sitPlayerOnPlayer(clicker, target);
        event.setCancelled(true);
    }

    @EventHandler
    public void onDismount(EntityDismountEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        this.plugin.getSitManager().unsitPlayer(player);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.plugin.getSitManager().unsitPlayer(event.getPlayer());
    }

    private boolean isSittable(Block block) {
        try {
            if (block.getBlockData() instanceof Stairs || block.getBlockData() instanceof Slab) {
                return true;
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        String typeName = block.getType().name();
        return typeName.contains("STAIRS") || typeName.contains("SLAB") || typeName.contains("STEP") || typeName.contains("CARPET");
    }
}

