/*
 * Decompiled with CFR 0.152.
 */
package ninja.genuine.tooltips;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import ninja.genuine.tooltips.WorldTooltips;
import ninja.genuine.tooltips.client.MiscUtils;
import ninja.genuine.tooltips.client.RenderHelper;
import ninja.genuine.tooltips.client.Tooltip;
import ninja.genuine.tooltips.config.Config;

public class WorldTooltipsHandler {
    private static Minecraft mc;
    private Tooltip cache;
    private double distance;
    private int ticksOver;
    private long lastTickCount = 0L;

    @SubscribeEvent
    public void onRenderGameOverlayEvent(RenderGameOverlayEvent.Post event) {
        if (event.type != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        if (mc == null || WorldTooltipsHandler.mc.theWorld == null || WorldTooltipsHandler.mc.thePlayer == null || WorldTooltipsHandler.mc.objectMouseOver == null) {
            return;
        }
        MovingObjectPosition objectMouseOver = WorldTooltipsHandler.mc.objectMouseOver;
        EntityClientPlayerMP thePlayer = WorldTooltipsHandler.mc.thePlayer;
        WorldClient theWorld = WorldTooltipsHandler.mc.theWorld;
        if (objectMouseOver.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK) {
            this.distance = thePlayer.getDistance((double)objectMouseOver.blockX, (double)objectMouseOver.blockY, (double)objectMouseOver.blockZ);
        } else if (objectMouseOver.typeOfHit == MovingObjectPosition.MovingObjectType.ENTITY) {
            this.distance = thePlayer.getDistanceToEntity(objectMouseOver.entityHit);
        }
        EntityItem entity = Config.ENABLE_MAX_DISTANCE_METHOD ? MiscUtils.getMouseOver(mc, event.partialTicks) : MiscUtils.getEntityItem(mc, this.distance, (EntityPlayer)thePlayer, event.partialTicks);
        long currentTickCount = theWorld.getTotalWorldTime();
        if (currentTickCount != this.lastTickCount) {
            this.lastTickCount = currentTickCount;
            if (entity != null) {
                ++this.ticksOver;
            } else {
                int n = this.ticksOver = Config.TICKS_DELAY_RESET ? 0 : Math.max(0, --this.ticksOver);
            }
        }
        if (this.ticksOver >= Config.TICKS_DELAY && entity != null) {
            if (this.cache == null || this.cache.getEntity() != entity) {
                this.cache = new Tooltip((EntityPlayer)thePlayer, entity);
            }
            this.cache.renderTooltip3D(mc, event.partialTicks);
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals("world-tooltips")) {
            Config.syncConfig(WorldTooltips.config);
            RenderHelper.updateFormattingToColorCode();
        }
    }

    public void setupMc() {
        mc = Minecraft.getMinecraft();
    }
}

