/*
 * Decompiled with CFR 0.152.
 */
package ninja.genuine.tooltips.client;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import ninja.genuine.tooltips.client.Tooltip;
import ninja.genuine.tooltips.config.Config;
import org.lwjgl.opengl.GL11;

public class RenderHelper {
    private static final ResourceLocation shader = new ResourceLocation("world-tooltips", "shaderfix.png");
    public static final Map<EnumChatFormatting, Integer> formattingToColorCode = new HashMap<EnumChatFormatting, Integer>();

    public static void updateFormattingToColorCode() {
        formattingToColorCode.clear();
        formattingToColorCode.put(EnumChatFormatting.BLACK, Config.RARITY_OUTLINE_COLOR_ALPHA | 0);
        formattingToColorCode.put(EnumChatFormatting.DARK_BLUE, Config.RARITY_OUTLINE_COLOR_ALPHA | 0xAA);
        formattingToColorCode.put(EnumChatFormatting.DARK_GREEN, Config.RARITY_OUTLINE_COLOR_ALPHA | 0xAA00);
        formattingToColorCode.put(EnumChatFormatting.DARK_AQUA, Config.RARITY_OUTLINE_COLOR_ALPHA | 0xAAAA);
        formattingToColorCode.put(EnumChatFormatting.DARK_RED, Config.RARITY_OUTLINE_COLOR_ALPHA | 0xAA0000);
        formattingToColorCode.put(EnumChatFormatting.DARK_PURPLE, Config.RARITY_OUTLINE_COLOR_ALPHA | 0xAA00AA);
        formattingToColorCode.put(EnumChatFormatting.GOLD, Config.RARITY_OUTLINE_COLOR_ALPHA | 0xFFAA00);
        formattingToColorCode.put(EnumChatFormatting.GRAY, Config.RARITY_OUTLINE_COLOR_ALPHA | 0xAAAAAA);
        formattingToColorCode.put(EnumChatFormatting.DARK_GRAY, Config.RARITY_OUTLINE_COLOR_ALPHA | 0x555555);
        formattingToColorCode.put(EnumChatFormatting.BLUE, Config.RARITY_OUTLINE_COLOR_ALPHA | 0x5555FF);
        formattingToColorCode.put(EnumChatFormatting.GREEN, Config.RARITY_OUTLINE_COLOR_ALPHA | 0x55FF55);
        formattingToColorCode.put(EnumChatFormatting.AQUA, Config.RARITY_OUTLINE_COLOR_ALPHA | 0x55FFFF);
        formattingToColorCode.put(EnumChatFormatting.RED, Config.RARITY_OUTLINE_COLOR_ALPHA | 0xFF5555);
        formattingToColorCode.put(EnumChatFormatting.LIGHT_PURPLE, Config.RARITY_OUTLINE_COLOR_ALPHA | 0xFF55FF);
        formattingToColorCode.put(EnumChatFormatting.YELLOW, Config.RARITY_OUTLINE_COLOR_ALPHA | 0xFFFF55);
        formattingToColorCode.put(EnumChatFormatting.WHITE, Config.RARITY_OUTLINE_COLOR_ALPHA | 0xFFFFFF);
    }

    public static void renderTooltipText(Tooltip tooltip, int drawx, int drawy, int alpha) {
        for (int i = 0; i < tooltip.size(); ++i) {
            String s = tooltip.getLine(i);
            if (i == 0) {
                s = tooltip.getRarityColor() + s;
            }
            Minecraft.getMinecraft().fontRenderer.drawString(s, drawx, drawy, 0xFFFFFF | alpha, true);
            if (i == 0) {
                drawy += 2;
            }
            drawy += 10;
        }
    }

    public static void renderTooltipTile(int x, int y, int width, int height, int backgroundStart, int backgroundEnd, int borderStart, int borderEnd) {
        RenderHelper.drawGradientRect(x - 3, y - 4, width + 6, 1, backgroundStart, backgroundStart);
        RenderHelper.drawGradientRect(x - 3, y + height + 3, width + 6, 1, backgroundEnd, backgroundEnd);
        RenderHelper.drawGradientRect(x - 3, y - 3, width + 6, height + 6, backgroundStart, backgroundEnd);
        RenderHelper.drawGradientRect(x - 4, y - 3, 1, height + 6, backgroundStart, backgroundEnd);
        RenderHelper.drawGradientRect(x + width + 3, y - 3, 1, height + 6, backgroundStart, backgroundEnd);
        RenderHelper.drawGradientRect(x - 3, y - 2, 1, height + 4, borderStart, borderEnd);
        RenderHelper.drawGradientRect(x + width + 2, y - 2, 1, height + 4, borderStart, borderEnd);
        RenderHelper.drawGradientRect(x - 3, y - 3, width + 6, 1, borderStart, borderStart);
        RenderHelper.drawGradientRect(x - 3, y + height + 2, width + 6, 1, borderEnd, borderEnd);
    }

    public static void start() {
        GL11.glPushMatrix();
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
    }

    public static void end() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2929);
        GL11.glPopMatrix();
    }

    public static void drawGradientRect(int x, int y, int w, int h, int color1, int color2) {
        w += x;
        h += y;
        float alpha1 = (float)(color1 >> 24 & 0xFF) / 255.0f;
        float red1 = (float)(color1 >> 16 & 0xFF) / 255.0f;
        float green1 = (float)(color1 >> 8 & 0xFF) / 255.0f;
        float blue1 = (float)(color1 & 0xFF) / 255.0f;
        float alpha2 = (float)(color2 >> 24 & 0xFF) / 255.0f;
        float red2 = (float)(color2 >> 16 & 0xFF) / 255.0f;
        float green2 = (float)(color2 >> 8 & 0xFF) / 255.0f;
        float blue2 = (float)(color2 & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glShadeModel((int)7425);
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        Minecraft.getMinecraft().renderEngine.bindTexture(shader);
        tessellator.setColorRGBA_F(red1, green1, blue1, alpha1);
        tessellator.addVertexWithUV((double)w, (double)y, 0.0, 0.0, 1.0);
        tessellator.addVertexWithUV((double)x, (double)y, 0.0, 0.0, 1.0);
        tessellator.setColorRGBA_F(red2, green2, blue2, alpha2);
        tessellator.addVertexWithUV((double)x, (double)h, 0.0, 0.0, 1.0);
        tessellator.addVertexWithUV((double)w, (double)h, 0.0, 0.0, 1.0);
        tessellator.draw();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    static {
        formattingToColorCode.put(EnumChatFormatting.BLACK, Config.RARITY_OUTLINE_COLOR_ALPHA | 0);
        formattingToColorCode.put(EnumChatFormatting.DARK_BLUE, Config.RARITY_OUTLINE_COLOR_ALPHA | 0xAA);
        formattingToColorCode.put(EnumChatFormatting.DARK_GREEN, Config.RARITY_OUTLINE_COLOR_ALPHA | 0xAA00);
        formattingToColorCode.put(EnumChatFormatting.DARK_AQUA, Config.RARITY_OUTLINE_COLOR_ALPHA | 0xAAAA);
        formattingToColorCode.put(EnumChatFormatting.DARK_RED, Config.RARITY_OUTLINE_COLOR_ALPHA | 0xAA0000);
        formattingToColorCode.put(EnumChatFormatting.DARK_PURPLE, Config.RARITY_OUTLINE_COLOR_ALPHA | 0xAA00AA);
        formattingToColorCode.put(EnumChatFormatting.GOLD, Config.RARITY_OUTLINE_COLOR_ALPHA | 0xFFAA00);
        formattingToColorCode.put(EnumChatFormatting.GRAY, Config.RARITY_OUTLINE_COLOR_ALPHA | 0xAAAAAA);
        formattingToColorCode.put(EnumChatFormatting.DARK_GRAY, Config.RARITY_OUTLINE_COLOR_ALPHA | 0x555555);
        formattingToColorCode.put(EnumChatFormatting.BLUE, Config.RARITY_OUTLINE_COLOR_ALPHA | 0x5555FF);
        formattingToColorCode.put(EnumChatFormatting.GREEN, Config.RARITY_OUTLINE_COLOR_ALPHA | 0x55FF55);
        formattingToColorCode.put(EnumChatFormatting.AQUA, Config.RARITY_OUTLINE_COLOR_ALPHA | 0x55FFFF);
        formattingToColorCode.put(EnumChatFormatting.RED, Config.RARITY_OUTLINE_COLOR_ALPHA | 0xFF5555);
        formattingToColorCode.put(EnumChatFormatting.LIGHT_PURPLE, Config.RARITY_OUTLINE_COLOR_ALPHA | 0xFF55FF);
        formattingToColorCode.put(EnumChatFormatting.YELLOW, Config.RARITY_OUTLINE_COLOR_ALPHA | 0xFFFF55);
        formattingToColorCode.put(EnumChatFormatting.WHITE, Config.RARITY_OUTLINE_COLOR_ALPHA | 0xFFFFFF);
    }
}

