/*
 * Decompiled with CFR 0.152.
 */
package ninja.genuine.tooltips.client;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import java.lang.reflect.Method;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import ninja.genuine.tooltips.WorldTooltips;
import ninja.genuine.tooltips.client.RenderHelper;
import ninja.genuine.tooltips.client.compat.BetterTooltipsCompat;
import ninja.genuine.tooltips.config.Config;
import org.apache.commons.lang3.text.WordUtils;
import org.lwjgl.opengl.GL11;

public class Tooltip {
    private static final Map<String, String> itemIdToModName = new HashMap<String, String>();
    private static Method info;
    private static boolean useNei;
    int outlineUpper;
    int outlineLower;
    int width;
    int height;
    EntityItem entity;
    List<String> text = new ArrayList<String>();

    public static void init() {
        Map modMap = Loader.instance().getIndexedModList();
        for (Map.Entry modEntry : modMap.entrySet()) {
            String lowercaseId = ((String)modEntry.getKey()).toLowerCase(Locale.ENGLISH);
            String modName = ((ModContainer)modEntry.getValue()).getName();
            itemIdToModName.put(lowercaseId, modName);
        }
        try {
            Class<?> nei = Class.forName("codechicken.nei.guihook.GuiContainerManager");
            info = nei.getDeclaredMethod("itemDisplayNameMultiline", ItemStack.class, GuiContainer.class, Boolean.TYPE);
            useNei = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Tooltip(EntityPlayer player, EntityItem entity) {
        this.entity = entity;
        this.generateTooltip(player, entity.getEntityItem());
    }

    public void renderTooltip3D(Minecraft mc, double partialTicks) {
        ScaledResolution sr = new ScaledResolution(mc, mc.displayWidth, mc.displayHeight);
        this.outlineUpper = Config.ENABLE_RARITY_OUTLINE_COLOR ? RenderHelper.formattingToColorCode.get(this.getRarityColor()) : Config.UPPER_OUTLINE_COLOR;
        this.outlineLower = Config.ENABLE_RARITY_OUTLINE_COLOR ? (this.outlineUpper & 0xFEFEFE) >> 1 | this.outlineUpper & 0xFF000000 : Config.LOWER_OUTLINE_COLOR;
        double interpX = RenderManager.renderPosX - (this.entity.posX - (this.entity.prevPosX - this.entity.posX) * partialTicks);
        double interpY = RenderManager.renderPosY - (this.entity.posY - (this.entity.prevPosY - this.entity.posY) * partialTicks);
        double interpZ = RenderManager.renderPosZ - (this.entity.posZ - (this.entity.prevPosZ - this.entity.posZ) * partialTicks);
        double interpDistance = Math.sqrt(interpX * interpX + interpY * interpY + interpZ * interpZ);
        RenderHelper.start();
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glMatrixMode((int)5889);
        GL11.glLoadMatrix((FloatBuffer)ActiveRenderInfo.projection);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadMatrix((FloatBuffer)ActiveRenderInfo.modelview);
        GL11.glTranslated((double)(-interpX), (double)(-(interpY - 0.55)), (double)(-interpZ));
        GL11.glRotatef((float)(-RenderManager.instance.playerViewY + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-RenderManager.instance.playerViewX), (float)1.0f, (float)0.0f, (float)0.0f);
        double scale = interpDistance;
        scale /= (double)(sr.getScaleFactor() * 160);
        if (scale <= 0.01) {
            scale = 0.01;
        }
        GL11.glScaled((double)scale, (double)(-scale), (double)scale);
        int x = -this.getWidth() / 2;
        int y = -this.getHeight();
        if (WorldTooltips.isBetterTooltipsLoaded) {
            BetterTooltipsCompat.DrawTooltip(x, y, this.getWidth(), this.getHeight());
        } else {
            RenderHelper.renderTooltipTile(x, y, this.getWidth(), this.getHeight(), Config.UPPER_BACKGROUND_COLOR, Config.LOWER_BACKGROUND_COLOR, this.outlineUpper, this.outlineLower);
        }
        RenderHelper.renderTooltipText(this, x, y, 255);
        GL11.glScaled((double)(1.0 / scale), (double)(1.0 / -scale), (double)(1.0 / scale));
        GL11.glRotatef((float)RenderManager.instance.playerViewX, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(RenderManager.instance.playerViewY - 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslated((double)interpX, (double)(interpY - (double)this.entity.height - 0.5), (double)interpZ);
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        RenderHelper.end();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public EntityItem getEntity() {
        return this.entity;
    }

    public int size() {
        return this.text.size();
    }

    public String getLine(int line) {
        return this.text.get(line);
    }

    public EnumChatFormatting getRarityColor() {
        return this.entity.getEntityItem().getRarity().rarityColor;
    }

    private void generateTooltip(EntityPlayer player, ItemStack item) {
        if (useNei) {
            try {
                this.text = (List)info.invoke(null, this.entity.getEntityItem(), null, Minecraft.getMinecraft().gameSettings.advancedItemTooltips);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (Objects.isNull(this.text) || this.text.isEmpty()) {
            this.text = item.getTooltip(player, Minecraft.getMinecraft().gameSettings.advancedItemTooltips);
        }
        if (!this.modsAreLoaded() && !Config.HIDE_MOD_NAME) {
            this.text.add(EnumChatFormatting.BLUE.toString() + EnumChatFormatting.ITALIC + this.getModName(item.getItem()) + EnumChatFormatting.RESET);
        }
        if (item.stackSize > 1) {
            this.text.set(0, item.stackSize + " x " + this.text.get(0));
        }
        int maxwidth = 0;
        for (int line = 0; line < this.text.size(); ++line) {
            int swidth = Minecraft.getMinecraft().fontRenderer.getStringWidth(this.getLine(line));
            if (swidth <= maxwidth) continue;
            maxwidth = swidth;
        }
        this.width = maxwidth;
        this.height = 8;
        if (this.size() > 1) {
            this.height += 2 + (this.size() - 1) * 10;
        }
    }

    private boolean modsAreLoaded() {
        return Loader.isModLoaded((String)"waila") | Loader.isModLoaded((String)"nei") | Loader.isModLoaded((String)"hwyla");
    }

    private String getModName(Item item) {
        String fullName = Item.itemRegistry.getNameForObject((Object)item);
        String modId = fullName.substring(0, fullName.indexOf(":"));
        String lowercaseModId = modId.toLowerCase(Locale.ENGLISH);
        String modName = itemIdToModName.get(lowercaseModId);
        if (modName == null) {
            modName = WordUtils.capitalize((String)modId);
            itemIdToModName.put(lowercaseModId, modName);
        }
        return modName;
    }

    static {
        useNei = false;
    }
}

