/*
 * Decompiled with CFR 0.152.
 */
package ninja.genuine.tooltips;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLModDisabledEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import ninja.genuine.tooltips.client.RenderEvent;
import ninja.genuine.tooltips.system.Tooltip;

@Mod(modid="world-tooltips", name="World-Tooltips", version="1.2.3-86 kotmatross edition", canBeDeactivated=true, useMetadata=true, guiFactory="ninja.genuine.tooltips.client.TooltipsGuiFactory")
public class WorldTooltips {
    @Mod.Instance(value="world-tooltips")
    public static WorldTooltips instance;
    public static Configuration config;
    public static final String MODID = "world-tooltips";
    public static final String NAME = "World-Tooltips";
    public static final String VERSION = "1.2.3-86 kotmatross edition";
    public static final String DESC = "Choose a color in hexidecimal (ie: 0xAB12cd or #AB12cd) \nYou can look up your favorite colors online.";
    public static final String GUIID = "worldtooltipsgui";
    public static int colorBackground;
    public static int overrideOutlineColor;
    public static float alpha;
    public static float maxDistance;
    public static boolean hideModName;
    public static boolean overrideOutline;
    private static boolean enabled;
    public static int ticksDelay;
    public static boolean ticksDelayReset;
    public static boolean enableMaxDistanceMethod;
    public static boolean isBetterTooltipsLoaded;
    public boolean client = FMLLaunchHandler.side().isClient();
    public RenderEvent events;

    public WorldTooltips() {
        instance = this;
    }

    @Mod.EventHandler
    public void pre(FMLPreInitializationEvent event) {
        config = new Configuration(event.getSuggestedConfigurationFile(), VERSION);
        enabled = config.get("Appearance", "Enable Mod", true, "Enable rendering the tooltips.").getBoolean();
        this.syncConfig();
        isBetterTooltipsLoaded = Loader.isModLoaded((String)"BetterTooltipBox");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (this.client) {
            this.events = new RenderEvent();
            Tooltip.init();
            if (enabled) {
                this.enable();
            }
            FMLCommonHandler.instance().bus().register((Object)this);
        }
    }

    @Mod.EventHandler
    public void post(FMLPostInitializationEvent event) {
        if (this.client) {
            this.events.post();
        }
    }

    public void enable() {
        if (this.client) {
            MinecraftForge.EVENT_BUS.register((Object)this.events);
            enabled = true;
        }
    }

    @Mod.EventHandler
    public void disable(FMLModDisabledEvent event) {
        if (this.client) {
            MinecraftForge.EVENT_BUS.unregister((Object)this.events);
            enabled = false;
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals(MODID) && event.configID.equals(GUIID)) {
            boolean tmp = enabled;
            if (tmp != (enabled = config.get("Appearance", "Enable Mod", true, "Enable rendering the tooltips.").getBoolean())) {
                if (enabled) {
                    this.enable();
                } else {
                    this.disable(null);
                }
            }
            this.syncConfig();
            this.events.syncColors();
        }
    }

    private void syncConfig() {
        hideModName = config.getBoolean("Hide Mod Name", "Appearance", false, "Hide mod names on tooltips.");
        maxDistance = config.getFloat("Maximum Draw Distance", "Appearance", 10.0f, 2.0f, 64.0f, "Set the maximum distance that tooltips should be displayed from. Requires \"Enable maxDistance Method\" ");
        ticksDelay = config.getInt("Ticks Delay Before Render", "Appearance", 10, 0, Integer.MAX_VALUE, "Delay (in ticks) before rendering the tooltip.");
        ticksDelayReset = config.getBoolean("Ticks Delay Reset", "Appearance", true, "Whether to reset the tick counter if the player isn't looking at the item. If true, then wait for the delay every time.");
        enableMaxDistanceMethod = config.getBoolean("Enable maxDistance (Maximum Draw Distance) Method", "Appearance", false, "If enabled, the render method will switch to the old getMouseOver() system, this will allow the Maximum Draw Distance config option to be used, but this means tooltips will be rendered through walls.");
        overrideOutline = config.getBoolean("Override Outline", "Appearance", false, "If enabled, outline color will be manually set instead of default behavior.");
        alpha = config.getFloat("Transparency", "Appearance", 0.8f, 0.0f, 1.0f, "Set the opacity for the tooltips; 0 being completely invisible and 1 being completely opaque.");
        try {
            colorBackground = Integer.decode(config.get("Appearance", "Background Color", "0x100010", DESC, Property.Type.COLOR).getString());
        }
        catch (NumberFormatException e) {
            colorBackground = 0x100010;
        }
        try {
            overrideOutlineColor = Integer.decode(config.get("Appearance", "Outline Color", "0x5000FF", DESC, Property.Type.COLOR).getString());
        }
        catch (NumberFormatException e) {
            overrideOutlineColor = 0x5000FF;
        }
        config.save();
    }

    static {
        enabled = false;
        ticksDelayReset = true;
        enableMaxDistanceMethod = false;
    }
}

