/*
 * Decompiled with CFR 0.152.
 */
package ninja.genuine.tooltips.client;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import ninja.genuine.tooltips.WorldTooltips;
import ninja.genuine.tooltips.system.Tooltip;

public class RenderEvent {
    private static Minecraft mc;
    private Tooltip cache;
    double distance;
    public int ticksOver;
    private long lastTickCount = 0L;

    public void post() {
        mc = Minecraft.getMinecraft();
    }

    public void syncColors() {
        if (this.cache != null) {
            this.cache.syncSettings();
        }
    }

    @SubscribeEvent
    public void onRenderGameOverlayEvent(RenderGameOverlayEvent.Post event) {
        if (event.type != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        if (mc == null || RenderEvent.mc.theWorld == null || RenderEvent.mc.thePlayer == null || RenderEvent.mc.objectMouseOver == null) {
            return;
        }
        MovingObjectPosition objectMouseOver = RenderEvent.mc.objectMouseOver;
        EntityClientPlayerMP thePlayer = RenderEvent.mc.thePlayer;
        WorldClient theWorld = RenderEvent.mc.theWorld;
        if (objectMouseOver.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK) {
            this.distance = thePlayer.getDistance((double)objectMouseOver.blockX, (double)objectMouseOver.blockY, (double)objectMouseOver.blockZ);
        } else if (objectMouseOver.typeOfHit == MovingObjectPosition.MovingObjectType.ENTITY) {
            this.distance = thePlayer.getDistanceToEntity(objectMouseOver.entityHit);
        }
        EntityItem entity = WorldTooltips.enableMaxDistanceMethod ? RenderEvent.getMouseOver(mc, event.partialTicks) : RenderEvent.getEntityItem(this.distance, (EntityPlayer)thePlayer, event.partialTicks);
        long currentTickCount = theWorld.getTotalWorldTime();
        if (currentTickCount != this.lastTickCount) {
            this.lastTickCount = currentTickCount;
            if (entity != null) {
                ++this.ticksOver;
            } else {
                int n = this.ticksOver = WorldTooltips.ticksDelayReset ? 0 : Math.max(0, --this.ticksOver);
            }
        }
        if (this.ticksOver >= WorldTooltips.ticksDelay && entity != null) {
            if (this.cache == null || this.cache.getEntity() != entity) {
                this.cache = new Tooltip((EntityPlayer)thePlayer, entity);
            }
            this.cache.renderTooltip3D(mc, event.partialTicks);
        }
    }

    public static EntityItem getEntityItem(EntityPlayer player, Vec3 vec31, Vec3 vec3) {
        RenderEvent.mc.mcProfiler.startSection("world-tooltips");
        float f1 = 1.0f;
        double d0 = player.capabilities.isCreativeMode ? 5.0 : 4.5;
        List list = player.worldObj.getEntitiesWithinAABBExcludingEntity((Entity)player, player.boundingBox.addCoord(vec31.xCoord * d0, vec31.yCoord * d0, vec31.zCoord * d0).expand((double)f1, (double)f1, (double)f1));
        Vec3 vec32 = vec3.addVector(vec31.xCoord * d0, vec31.yCoord * d0, vec31.zCoord * d0);
        double d1 = d0;
        if (FMLCommonHandler.instance().getEffectiveSide().isClient() && RenderEvent.mc.objectMouseOver != null) {
            d1 = RenderEvent.mc.objectMouseOver.hitVec.distanceTo(vec3);
        }
        double d2 = d1;
        for (Object o : list) {
            Entity entity = (Entity)o;
            if (!(entity instanceof EntityItem)) continue;
            float f2 = entity.getCollisionBorderSize();
            AxisAlignedBB axisalignedbb = entity.boundingBox.expand((double)f2, (double)f2, (double)f2);
            MovingObjectPosition movingobjectposition = axisalignedbb.calculateIntercept(vec3, vec32);
            if (!(axisalignedbb.isVecInside(vec3) ? 0.0 < d2 || d2 == 0.0 : movingobjectposition != null)) continue;
            return (EntityItem)entity;
        }
        RenderEvent.mc.mcProfiler.endSection();
        return null;
    }

    public static EntityItem getEntityItem(double distance, EntityPlayer player, float partialTicks) {
        Vec3 vec3;
        Vec3 vec31 = player.getLook(partialTicks);
        EntityItem item = RenderEvent.getEntityItem(player, vec31, vec3 = player.getPosition(partialTicks));
        if (item != null && (double)player.getDistanceToEntity((Entity)item) < distance) {
            return item;
        }
        return null;
    }

    public static EntityItem getMouseOver(Minecraft mc, float partialTicks) {
        EntityLivingBase viewer = mc.renderViewEntity;
        mc.mcProfiler.startSection("world-tooltips");
        double distanceLook = WorldTooltips.maxDistance;
        Vec3 eyes = viewer.getPosition(partialTicks);
        Vec3 look = viewer.getLook(partialTicks);
        Vec3 eyesLook = eyes.addVector(look.xCoord * distanceLook, look.yCoord * distanceLook, look.zCoord * distanceLook);
        float distanceMax = 1.0f;
        List entityList = mc.theWorld.getEntitiesWithinAABB(EntityItem.class, viewer.boundingBox.addCoord(look.xCoord * distanceLook, look.yCoord * distanceLook, look.zCoord * distanceLook).expand((double)distanceMax, (double)distanceMax, (double)distanceMax));
        double difference = 0.0;
        EntityItem target = null;
        for (EntityItem entity : entityList) {
            double distance;
            if (Objects.isNull(entity) || Objects.isNull(entity.boundingBox)) continue;
            float boundSize = 0.15f;
            AxisAlignedBB aabb1 = entity.boundingBox;
            AxisAlignedBB aabb2 = AxisAlignedBB.getBoundingBox((double)aabb1.minX, (double)aabb1.minY, (double)aabb1.minZ, (double)aabb1.maxX, (double)aabb1.maxY, (double)aabb1.maxZ);
            AxisAlignedBB expandedAABB = aabb2.offset(0.0, 0.25, 0.0).expand(0.15, 0.1, 0.15).expand((double)boundSize, (double)boundSize, (double)boundSize);
            MovingObjectPosition objectInVector = expandedAABB.calculateIntercept(eyes, eyesLook);
            if (expandedAABB.isVecInside(eyes)) {
                if (!(0.0 <= difference)) continue;
                target = entity;
                difference = 0.0;
                continue;
            }
            if (objectInVector == null || !((distance = eyes.distanceTo(objectInVector.hitVec)) < difference) && difference != 0.0) continue;
            target = entity;
            difference = distance;
        }
        mc.mcProfiler.endSection();
        return target;
    }
}

