/*
 * Decompiled with CFR 0.152.
 */
package dev.norbiros.emojitype.config;

import dev.norbiros.emojitype.EmojiType;
import dev.norbiros.emojitype.config.ConfigUtil;
import dev.norbiros.emojitype.config.EmojiListWidget;
import dev.norbiros.emojitype.emoji.EmojiCode;
import dev.norbiros.emojitype.packs.EmojiPackManager;
import java.util.List;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class EmojiTypeConfig
extends Screen {
    public final HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this);
    protected final Screen parent;
    public boolean shouldSaveConfig = true;
    @Nullable
    private EmojiListWidget body;

    public EmojiTypeConfig(Screen parent) {
        super((Component)Component.translatable((String)"config.emojitype.title"));
        this.parent = parent;
        this.layout.setHeaderHeight(30);
        this.layout.setFooterHeight(30);
    }

    public static Screen createConfigScreen(Screen parent) {
        ConfigUtil.deserialise();
        return new EmojiTypeConfig(parent);
    }

    protected void init() {
        this.layout.addTitleHeader(this.title, this.font);
        EmojiListWidget emojiListWidget = new EmojiListWidget(this.minecraft, this.width, this.height - 30 - 30, 30, 20);
        for (EmojiCode emoji : EmojiType.emojiCodes) {
            emojiListWidget.addEntry(emoji);
        }
        this.body = (EmojiListWidget)this.layout.addToContents((LayoutElement)emojiListWidget);
        this.initFooter();
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
    }

    protected void repositionElements() {
        this.layout.arrangeElements();
        if (this.body != null) {
            this.body.updateSize(this.width, this.layout);
        }
    }

    protected void initFooter() {
        LinearLayout directionalLayoutWidget = ((LinearLayout)this.layout.addToFooter((LayoutElement)LinearLayout.horizontal())).spacing(8);
        directionalLayoutWidget.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"config.emojitype.cancel"), button -> {
            this.shouldSaveConfig = false;
            this.onClose();
        }).width(100).build());
        directionalLayoutWidget.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"config.emojitype.reset_all"), button -> {
            if (this.body == null) {
                return;
            }
            this.body.children().clear();
            for (EmojiCode emoji : EmojiPackManager.getAllEmojis()) {
                this.body.addEntry(emoji);
            }
        }).width(100).build());
        directionalLayoutWidget.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"config.emojitype.save_and_quit"), button -> this.onClose()).width(100).build());
    }

    public void onClose() {
        if (this.body != null && this.shouldSaveConfig) {
            List<String> codes = this.body.getCurrentCodes();
            ConfigUtil.emojiCodeStrings.clear();
            ConfigUtil.emojiCodeStrings.addAll(codes);
            ConfigUtil.serialise();
        }
        if (this.minecraft != null) {
            this.minecraft.setScreen(this.parent);
        }
    }
}

