/*
 * Decompiled with CFR 0.152.
 */
package dev.norbiros.emojitype.packs;

import dev.norbiros.emojitype.emoji.EmojiCode;
import dev.norbiros.emojitype.packs.EmojiPack;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.yaml.snakeyaml.Yaml;

public class EmojiPackManager {
    public static List<EmojiCode> getAllEmojis() {
        ArrayList<EmojiCode> emojis = new ArrayList<EmojiCode>();
        for (EmojiPack pack : EmojiPackManager.getEmojiPacks()) {
            for (Map.Entry<String, String> entry : pack.emojis.entrySet()) {
                emojis.add(new EmojiCode(":" + entry.getKey() + ":", entry.getValue()));
            }
        }
        return emojis;
    }

    public static List<EmojiPack> getEmojiPacks() {
        Yaml yaml = new Yaml();
        return EmojiPackManager.readEmojiPackFiles().values().stream().map(yamlStr -> (EmojiPack)yaml.loadAs(yamlStr, EmojiPack.class)).collect(Collectors.toList());
    }

    public static Map<String, String> readEmojiPackFiles() {
        HashMap<String, String> emojiPacks;
        block16: {
            emojiPacks = new HashMap<String, String>();
            try {
                CodeSource codeSource = EmojiPackManager.class.getProtectionDomain().getCodeSource();
                if (codeSource == null) {
                    throw new IllegalStateException("CodeSource is null");
                }
                URL jarUrl = codeSource.getLocation();
                Path jarPath = Paths.get(jarUrl.toURI());
                try (FileSystem fs = FileSystems.newFileSystem(jarPath, (ClassLoader)null);){
                    Path packDir = fs.getPath("assets", "emojitype", "emoji_packs");
                    if (!Files.exists(packDir, new LinkOption[0])) break block16;
                    try (DirectoryStream<Path> stream = Files.newDirectoryStream(packDir);){
                        for (Path path : stream) {
                            if (!Files.isRegularFile(path, new LinkOption[0])) continue;
                            String content = Files.readString(path, StandardCharsets.UTF_8);
                            emojiPacks.put(path.getFileName().toString(), content);
                        }
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Failed to load emoji packs: " + e.getMessage());
                e.printStackTrace();
            }
        }
        return emojiPacks;
    }
}

