/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticseating.block.custom;

import net.alminoris.aestheticseating.entity.custom.SeatEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;

public abstract class SeatingFurniture
extends Block
implements SimpleWaterloggedBlock {
    private final double seatY;

    public SeatingFurniture(BlockBehaviour.Properties settings, double seatY) {
        super(settings);
        this.seatY = seatY;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        boolean seatExists;
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (!player.isPassenger() && !(seatExists = world.getEntitiesOfClass(SeatEntity.class, new AABB(pos), Entity::isAlive).stream().findFirst().isPresent())) {
            SeatEntity seat = SeatEntity.createOrReuse(world, pos, this.seatY);
            world.addFreshEntity((Entity)seat);
            player.startRiding((Entity)seat, true);
        }
        return InteractionResult.SUCCESS;
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }
}

