/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticseating.block.custom;

import java.util.ArrayList;
import net.alminoris.aestheticseating.block.custom.SeatingFurniture;
import net.alminoris.aestheticseating.util.helper.VoxelShapeHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SeatingLog
extends SeatingFurniture {
    private static final VoxelShape SEAT = Block.box((double)2.0, (double)0.0, (double)5.0, (double)14.0, (double)6.0, (double)11.0);
    private static final VoxelShape SEAT_CENTER = Block.box((double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)6.0, (double)11.0);
    private static final VoxelShape SEAT_LEFT = Block.box((double)2.0, (double)0.0, (double)5.0, (double)16.0, (double)6.0, (double)11.0);
    private static final VoxelShape SEAT_RIGHT = Block.box((double)0.0, (double)0.0, (double)5.0, (double)14.0, (double)6.0, (double)11.0);
    public static final EnumProperty<Variant> VARIANT = EnumProperty.create((String)"variant", Variant.class);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;

    public SeatingLog() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE), -0.45);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(VARIANT, (Comparable)((Object)Variant.NORMAL)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, VARIANT});
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.getRotatedShape(state);
    }

    private VoxelShape getRotatedShape(BlockState state) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        ArrayList<AABB> boxes = new ArrayList<AABB>();
        switch (((Variant)((Object)state.getValue(VARIANT))).ordinal()) {
            case 0: {
                boxes.add(SEAT.bounds());
                break;
            }
            case 1: {
                boxes.add(SEAT_CENTER.bounds());
                break;
            }
            case 2: {
                boxes.add(SEAT_LEFT.bounds());
                break;
            }
            case 3: {
                boxes.add(SEAT_RIGHT.bounds());
            }
        }
        return VoxelShapeHelper.rotateShape(boxes, direction);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return this.updateSeatingLogVariant(state, world, pos);
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        super.onPlace(state, world, pos, oldState, notify);
        this.updateSurroundingLogs(world, pos);
    }

    private void updateSurroundingLogs(Level world, BlockPos pos) {
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockPos neighborPos = pos.relative(dir);
            BlockState neighborState = world.getBlockState(neighborPos);
            if (!(neighborState.getBlock() instanceof SeatingLog)) continue;
            world.setBlock(neighborPos, this.updateSeatingLogVariant(neighborState, (LevelAccessor)world, neighborPos), 3);
        }
    }

    private BlockState updateSeatingLogVariant(BlockState state, LevelAccessor world, BlockPos pos) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        BlockPos leftPos = pos.relative(facing.getCounterClockWise());
        BlockPos rightPos = pos.relative(facing.getClockWise());
        boolean leftConnected = this.isFullSolidOrMatchingLog(world, leftPos, facing);
        boolean rightConnected = this.isFullSolidOrMatchingLog(world, rightPos, facing);
        if (leftConnected && rightConnected) {
            return (BlockState)state.setValue(VARIANT, (Comparable)((Object)Variant.CENTER));
        }
        if (leftConnected) {
            return (BlockState)state.setValue(VARIANT, (Comparable)((Object)Variant.RIGHT));
        }
        if (rightConnected) {
            return (BlockState)state.setValue(VARIANT, (Comparable)((Object)Variant.LEFT));
        }
        return (BlockState)state.setValue(VARIANT, (Comparable)((Object)Variant.NORMAL));
    }

    private boolean isFullSolidOrMatchingLog(LevelAccessor world, BlockPos pos, Direction facing) {
        BlockState state = world.getBlockState(pos);
        if (state.getBlock() instanceof SeatingLog && state.getValue((Property)FACING) == facing) {
            return true;
        }
        return state.isSolid() && state.canOcclude();
    }

    public static enum Variant implements StringRepresentable
    {
        NORMAL("normal"),
        CENTER("center"),
        LEFT("left"),
        RIGHT("right");

        private final String name;

        private Variant(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

