/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticseating.block.custom;

import java.util.ArrayList;
import net.alminoris.aestheticseating.block.custom.SeatingFurniture;
import net.alminoris.aestheticseating.item.ModItems;
import net.alminoris.aestheticseating.util.helper.VoxelShapeHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SimpleChair
extends SeatingFurniture {
    private static final VoxelShape SEAT = Block.box((double)3.2, (double)0.0, (double)3.0, (double)12.8, (double)8.0, (double)13.0);
    public static final EnumProperty<CarpetColor> CARPET_COLOR = EnumProperty.create((String)"carpet_color", CarpetColor.class);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty CARPETED = BooleanProperty.create((String)"carpeted");
    public static final BooleanProperty RECLINED = BooleanProperty.create((String)"reclined");

    public SimpleChair() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS), -0.3);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)RECLINED, (Comparable)Boolean.valueOf(false))).setValue((Property)CARPETED, (Comparable)Boolean.valueOf(false))).setValue(CARPET_COLOR, (Comparable)((Object)CarpetColor.BLACK)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, RECLINED, CARPETED, CARPET_COLOR});
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        boolean currentReclined = (Boolean)state.getValue((Property)RECLINED);
        boolean currentCarpeted = (Boolean)state.getValue((Property)CARPETED);
        if (stack.is(ItemTags.WOOL_CARPETS) && !currentCarpeted) {
            if (!level.isClientSide) {
                Direction facing = (Direction)state.getValue((Property)FACING);
                String colorName = stack.getItem().getDescriptionId().replace("block.minecraft.", "").replace("_carpet", "");
                level.setBlock(pos, (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)facing)).setValue((Property)RECLINED, (Comparable)Boolean.valueOf(currentReclined))).setValue((Property)CARPETED, (Comparable)Boolean.valueOf(true))).setValue(CARPET_COLOR, (Comparable)((Object)CarpetColor.fromString(colorName))), 3);
                stack.shrink(1);
            }
            return ItemInteractionResult.SUCCESS;
        }
        if (stack.is(TagKey.create((ResourceKey)BuiltInRegistries.ITEM.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"aestheticseating", (String)"wrench")))) {
            if (!level.isClientSide) {
                level.setBlock(pos, (BlockState)state.setValue((Property)RECLINED, (Comparable)Boolean.valueOf(!currentReclined)), 3);
                stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            }
            return ItemInteractionResult.SUCCESS;
        }
        if (stack.is((Item)ModItems.CUSHION_REMOVER.get())) {
            if (!level.isClientSide) {
                Direction facing = (Direction)state.getValue((Property)FACING);
                CarpetColor carpetColor = (CarpetColor)((Object)state.getValue(CARPET_COLOR));
                level.setBlock(pos, (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)facing)).setValue((Property)RECLINED, (Comparable)Boolean.valueOf(currentReclined))).setValue((Property)CARPETED, (Comparable)Boolean.valueOf(false))).setValue(CARPET_COLOR, (Comparable)((Object)carpetColor)), 3);
                stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                Item carpetItem = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)(carpetColor.getSerializedName() + "_carpet")));
                ItemStack carpetStack = new ItemStack((ItemLike)carpetItem);
                if (!player.getInventory().add(carpetStack)) {
                    player.drop(carpetStack, false);
                }
            }
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hit);
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext ctx) {
        return this.getRotatedShape(state);
    }

    private VoxelShape getRotatedShape(BlockState state) {
        Direction dir = (Direction)state.getValue((Property)FACING);
        ArrayList<AABB> boxes = new ArrayList<AABB>();
        boxes.add(SEAT.bounds());
        return VoxelShapeHelper.rotateShape(boxes, dir);
    }

    public static enum CarpetColor implements StringRepresentable
    {
        BLACK("black"),
        BROWN("brown"),
        GRAY("gray"),
        LIGHT_GRAY("light_gray"),
        WHITE("white"),
        RED("red"),
        ORANGE("orange"),
        YELLOW("yellow"),
        PURPLE("purple"),
        MAGENTA("magenta"),
        PINK("pink"),
        BLUE("blue"),
        CYAN("cyan"),
        LIGHT_BLUE("light_blue"),
        GREEN("green"),
        LIME("lime");

        private final String name;

        private CarpetColor(String name) {
            this.name = name;
        }

        public static CarpetColor fromString(String name) {
            for (CarpetColor inside : CarpetColor.values()) {
                if (!inside.name.equalsIgnoreCase(name)) continue;
                return inside;
            }
            throw new IllegalArgumentException("No enum constant for name: " + name);
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

