/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticseating.entity.custom;

import net.alminoris.aestheticseating.util.SeatEntityPool;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class SeatEntity
extends Entity {
    private static final int CLEANUP_DELAY = 20;
    public int cleanupTimer = 0;

    public SeatEntity(EntityType<? extends SeatEntity> type, Level level) {
        super(type, level);
        this.setNoGravity(true);
    }

    public static SeatEntity createOrReuse(Level level, BlockPos pos, double seatY) {
        SeatEntity seat = SeatEntityPool.getInstance().obtainSeat(level, pos, seatY);
        seat.setPos((double)pos.getX() + 0.5, (double)pos.getY() + seatY, (double)pos.getZ() + 0.5);
        return seat;
    }

    public void tick() {
        super.tick();
        this.setDeltaMovement(0.0, 0.0, 0.0);
        if (!this.level().isClientSide) {
            if (this.getPassengers().isEmpty()) {
                ++this.cleanupTimer;
                if (this.cleanupTimer >= 20) {
                    this.cleanupTimer = 0;
                    SeatEntityPool.getInstance().release(this);
                }
            } else {
                this.cleanupTimer = 0;
            }
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    public boolean isPushable() {
        return false;
    }

    public boolean canRide(Entity entity) {
        return !(entity instanceof SeatEntity);
    }

    protected boolean canAddPassenger(Entity passenger) {
        return this.getPassengers().isEmpty() && passenger instanceof Player;
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return true;
    }

    public boolean isColliding(BlockPos pos, BlockState state) {
        return false;
    }

    protected void positionRider(Entity passenger, Entity.MoveFunction moveFunction) {
        passenger.setPos(this.getX(), this.getY() + 0.2, this.getZ());
    }
}

