/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticseating.util;

import java.util.ArrayDeque;
import java.util.Queue;
import net.alminoris.aestheticseating.entity.ModEntities;
import net.alminoris.aestheticseating.entity.custom.SeatEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;

public class SeatEntityPool {
    private static final SeatEntityPool INSTANCE = new SeatEntityPool();
    private final Queue<SeatEntity> availableSeats = new ArrayDeque<SeatEntity>();

    public static SeatEntityPool getInstance() {
        return INSTANCE;
    }

    public SeatEntity obtainSeat(Level world, BlockPos pos, double seatY) {
        SeatEntity seat = this.availableSeats.poll();
        if (seat == null || !seat.isAlive()) {
            seat = new SeatEntity((EntityType<? extends SeatEntity>)((EntityType)ModEntities.SEAT.get()), world);
        } else {
            seat.setPos((double)pos.getX() + 0.5, (double)pos.getY() + seatY, (double)pos.getZ() + 0.5);
            seat.cleanupTimer = 0;
        }
        return seat;
    }

    public void release(SeatEntity seatEntity) {
        if (seatEntity.isAlive()) {
            seatEntity.setRemoved(Entity.RemovalReason.DISCARDED);
            this.availableSeats.offer(seatEntity);
        }
    }
}

