/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticseating.block.custom;

import java.util.ArrayList;
import net.alminoris.aestheticseating.block.ModBlocks;
import net.alminoris.aestheticseating.block.custom.SeatingFurniture;
import net.alminoris.aestheticseating.item.ModItems;
import net.alminoris.aestheticseating.util.helper.VoxelShapeHelper;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;

public class Sofa
extends SeatingFurniture {
    private static final class_265 SEAT = Sofa.method_9541((double)0.0, (double)2.0, (double)1.0, (double)16.0, (double)7.0, (double)15.0);
    private static final class_265 SEAT_NORMAL = Sofa.method_9541((double)1.0, (double)2.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0);
    private final String name;
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2746 CUSHION = class_2746.method_11825((String)"cushion");
    public static final class_2754<Variant> VARIANT = class_2754.method_11850((String)"variant", Variant.class);

    public Sofa(String name) {
        super(class_4970.class_2251.method_9630((class_4970)class_2246.field_10146), -0.15);
        this.name = name;
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657(VARIANT, (Comparable)((Object)Variant.NORMAL))).method_11657((class_2769)CUSHION, (Comparable)Boolean.valueOf(false)));
    }

    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)ctx.method_8042());
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, VARIANT, CUSHION});
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.getRotatedShape(state);
    }

    private class_265 getRotatedShape(class_2680 state) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
        Variant variant = (Variant)((Object)state.method_11654(VARIANT));
        ArrayList<class_238> boxes = new ArrayList<class_238>();
        if (variant == Variant.NORMAL) {
            boxes.add(SEAT_NORMAL.method_1107());
        } else {
            boxes.add(SEAT.method_1107());
        }
        return VoxelShapeHelper.rotateShape(boxes, direction);
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        boolean currentCushion = (Boolean)state.method_11654((class_2769)CUSHION);
        Variant currentVariant = (Variant)((Object)state.method_11654(VARIANT));
        class_2350 currentFacing = (class_2350)state.method_11654((class_2769)FACING);
        class_1799 stack = player.method_5998(hand);
        if (stack.method_7909() == ModBlocks.CUSHIONS.get(this.name).method_8389() && !currentCushion) {
            if (!world.field_9236) {
                world.method_8501(pos, (class_2680)((class_2680)((class_2680)state.method_11657((class_2769)FACING, (Comparable)currentFacing)).method_11657((class_2769)CUSHION, (Comparable)Boolean.valueOf(true))).method_11657(VARIANT, (Comparable)((Object)currentVariant)));
                stack.method_7934(1);
            }
            return class_1269.field_5812;
        }
        if (stack.method_7909() == ModItems.CUSHION_REMOVER && currentCushion) {
            if (!world.field_9236) {
                world.method_8501(pos, (class_2680)((class_2680)((class_2680)state.method_11657((class_2769)FACING, (Comparable)currentFacing)).method_11657((class_2769)CUSHION, (Comparable)Boolean.valueOf(false))).method_11657(VARIANT, (Comparable)((Object)currentVariant)));
                if (stack.method_7919() < stack.method_7936() - 1) {
                    stack.method_7974(stack.method_7919() + 1);
                } else {
                    stack.method_7934(1);
                }
                class_1799 carpetStack = new class_1799((class_1935)ModBlocks.CUSHIONS.get(this.name));
                if (!player.method_31548().method_7394(carpetStack)) {
                    player.method_7328(carpetStack, false);
                }
            }
            return class_1269.field_5812;
        }
        return super.method_9534(state, world, pos, player, hand, hit);
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        return this.updateSofaVariant(world, state, pos);
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        super.method_9615(state, world, pos, oldState, notify);
        this.updateSurroundingSofas(world, pos);
    }

    private void updateSurroundingSofas(class_1937 world, class_2338 pos) {
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            class_2680 updatedState;
            class_2338 neighborPos = pos.method_10093(direction);
            class_2680 neighborState = world.method_8320(neighborPos);
            if (!(neighborState.method_26204() instanceof Sofa) || neighborState.equals(updatedState = this.updateSofaVariant((class_1936)world, neighborState, neighborPos))) continue;
            world.method_8501(neighborPos, updatedState);
        }
    }

    private class_2680 updateSofaVariant(class_1936 world, class_2680 state, class_2338 pos) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        class_2338 leftPos = pos.method_10093(facing.method_10160());
        class_2338 rightPos = pos.method_10093(facing.method_10170());
        boolean leftConnected = this.isSofa(world, leftPos, facing, Variant.RIGHTCORNER);
        boolean rightConnected = this.isSofa(world, rightPos, facing, Variant.LEFTCORNER);
        if (this.isSofaL(world, rightPos.method_10093(facing.method_10160()).method_10093(facing.method_10170().method_10170()), facing)) {
            return (class_2680)state.method_11657(VARIANT, (Comparable)((Object)Variant.RIGHTCORNER));
        }
        if (this.isSofaR(world, leftPos.method_10093(facing.method_10170()).method_10093(facing.method_10160().method_10160()), facing)) {
            return (class_2680)state.method_11657(VARIANT, (Comparable)((Object)Variant.LEFTCORNER));
        }
        if (leftConnected && rightConnected) {
            return (class_2680)state.method_11657(VARIANT, (Comparable)((Object)Variant.CENTER));
        }
        if (leftConnected) {
            return (class_2680)state.method_11657(VARIANT, (Comparable)((Object)Variant.RIGHT));
        }
        if (rightConnected) {
            return (class_2680)state.method_11657(VARIANT, (Comparable)((Object)Variant.LEFT));
        }
        return (class_2680)state.method_11657(VARIANT, (Comparable)((Object)Variant.NORMAL));
    }

    private boolean isSofa(class_1936 world, class_2338 pos, class_2350 expectedFacing, Variant variant) {
        class_2680 state = world.method_8320(pos);
        return state.method_26204() instanceof Sofa && (state.method_11654((class_2769)FACING) == expectedFacing || state.method_11654(VARIANT) == variant);
    }

    private boolean isSofaL(class_1936 world, class_2338 pos, class_2350 expectedFacing) {
        class_2680 state = world.method_8320(pos);
        return state.method_26204() instanceof Sofa && state.method_11654((class_2769)FACING) == expectedFacing.method_10170();
    }

    private boolean isSofaR(class_1936 world, class_2338 pos, class_2350 expectedFacing) {
        class_2680 state = world.method_8320(pos);
        return state.method_26204() instanceof Sofa && state.method_11654((class_2769)FACING) == expectedFacing.method_10160();
    }

    public static enum Variant implements class_3542
    {
        NORMAL("normal"),
        CENTER("center"),
        LEFT("left"),
        RIGHT("right"),
        LEFTCORNER("leftcorner"),
        RIGHTCORNER("rightcorner");

        private final String name;

        private Variant(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }
    }
}

