/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticseating.util.helper;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.alminoris.aestheticseating.util.helper.ModJsonTemplates;

public class ModJsonHelper {
    public static void createShapedRecipe(String outputName, String count, String ingredient1Name, String ingredient2Name, String pattern1, String pattern2, String pattern3) {
        String projectPath = System.getProperty("user.dir");
        String filePath = projectPath.replace("build\\datagen", "src\\main\\resources") + "/data/aestheticseating/recipe/";
        File directory = new File(filePath);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        String fileName = outputName + ".json";
        File modelFile = new File(directory, fileName);
        String jsonContent = ModJsonTemplates.SHAPED_RECIPE.replace("COUNT", count).replace("INGREDIENT1_NAME", ingredient1Name).replace("INGREDIENT2_NAME", ingredient2Name).replace("OUTPUT_NAME", outputName).replace("PATTERN1", pattern1).replace("PATTERN2", pattern2).replace("PATTERN3", pattern3);
        try (FileWriter writer = new FileWriter(modelFile);){
            writer.write(jsonContent);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void createSimpleChairModel(String jsonContent, String colorName, String woodName, String modId, boolean isReclined, boolean isCarpeted) {
        String projectPath = System.getProperty("user.dir");
        String filePath = projectPath.replace("build\\datagen", "src\\main\\resources") + "/assets/aestheticseating/models/block/" + colorName;
        File directory = new File(filePath);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        String fileName = "simple_chair_" + woodName + (isReclined ? "_reclined" : "") + (isCarpeted ? "_carpeted" : "") + ".json";
        File modelFile = new File(directory, fileName);
        String logName = woodName.equals("crimson") || woodName.equals("warped") ? "stem" : (woodName.equals("bamboo") ? "block" : "log");
        jsonContent = jsonContent.replace("COLOR_NAME", colorName).replace("BASE_NAME", modId + ":block/stripped_" + woodName + "_" + logName).replace("LOG_NAME", modId + ":block/" + woodName + "_" + logName);
        try (FileWriter writer = new FileWriter(modelFile);){
            writer.write(jsonContent);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void createSimpleBenchModel(String jsonContent, String woodName, String modId, String variant, boolean backrest) {
        String projectPath = System.getProperty("user.dir");
        String filePath = projectPath.replace("build\\datagen", "src\\main\\resources") + "/assets/aestheticseating/models/block/";
        File directory = new File(filePath);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        String fileName = "simple_bench_" + woodName + (String)(variant.equals("normal") ? "" : "_" + variant) + (backrest ? "_backrest" : "") + ".json";
        File modelFile = new File(directory, fileName);
        String logName = woodName.equals("crimson") || woodName.equals("warped") ? "stem" : (woodName.equals("bamboo") ? "block" : "log");
        jsonContent = jsonContent.replace("BASE_NAME", modId + ":block/stripped_" + woodName + "_" + logName).replace("LOG_NAME", modId + ":block/" + woodName + "_" + logName);
        try (FileWriter writer = new FileWriter(modelFile);){
            writer.write(jsonContent);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void createStoneBenchModel(String jsonContent, String stoneName, String modId, String variant) {
        String projectPath = System.getProperty("user.dir");
        String filePath = projectPath.replace("build\\datagen", "src\\main\\resources") + "/assets/aestheticseating/models/block/";
        File directory = new File(filePath);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        String fileName = "stone_bench_" + stoneName + (String)(variant.equals("normal") ? "" : "_" + variant) + ".json";
        File modelFile = new File(directory, fileName);
        jsonContent = jsonContent.replace("BASE_NAME", modId + ":block/" + stoneName);
        try (FileWriter writer = new FileWriter(modelFile);){
            writer.write(jsonContent);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void createSeatingLogModel(String jsonContent, String woodName, String modId, String variant) {
        String projectPath = System.getProperty("user.dir");
        String filePath = projectPath.replace("build\\datagen", "src\\main\\resources") + "/assets/aestheticseating/models/block/";
        File directory = new File(filePath);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        String fileName = "seating_log_" + woodName + (String)(variant.equals("normal") ? "" : "_" + variant) + ".json";
        File modelFile = new File(directory, fileName);
        String logName = woodName.equals("crimson") || woodName.equals("warped") ? "stem" : (woodName.equals("bamboo") ? "block" : "log");
        jsonContent = jsonContent.replace("BASE_NAME", modId + ":block/" + woodName + "_" + logName).replace("LOG_NAME", modId + ":block/" + woodName + "_" + logName + "_top");
        try (FileWriter writer = new FileWriter(modelFile);){
            writer.write(jsonContent);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void createSimpleChairBlockState(String woodName) {
        String projectPath = System.getProperty("user.dir");
        String filePath = projectPath.replace("build\\datagen", "src\\main\\resources") + "/assets/aestheticseating/blockstates";
        File directory = new File(filePath);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        String fileName = "simple_chair_" + woodName + ".json";
        File modelFile = new File(directory, fileName);
        String jsonContent = "{\n  \"variants\":\n  {\n    \"facing=north,reclined=false,carpeted=false,carpet_color=black\": { \"model\": \"aestheticseating:block/black/simple_chair_WOOD_NAME_VALUE\" },\n    \"facing=south,reclined=false,carpeted=false,carpet_color=black\": { \"model\": \"aestheticseating:block/black/simple_chair_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,reclined=false,carpeted=false,carpet_color=black\": { \"model\": \"aestheticseating:block/black/simple_chair_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,reclined=false,carpeted=false,carpet_color=black\": { \"model\": \"aestheticseating:block/black/simple_chair_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,reclined=true,carpeted=false,carpet_color=black\": { \"model\": \"aestheticseating:block/black/simple_chair_WOOD_NAME_VALUE_reclined\" },\n    \"facing=south,reclined=true,carpeted=false,carpet_color=black\": { \"model\": \"aestheticseating:block/black/simple_chair_WOOD_NAME_VALUE_reclined\", \"y\": 180 },\n    \"facing=west,reclined=true,carpeted=false,carpet_color=black\": { \"model\": \"aestheticseating:block/black/simple_chair_WOOD_NAME_VALUE_reclined\", \"y\": 270 },\n    \"facing=east,reclined=true,carpeted=false,carpet_color=black\": { \"model\": \"aestheticseating:block/black/simple_chair_WOOD_NAME_VALUE_reclined\", \"y\": 90 },\n    \"facing=north,reclined=false,carpeted=true,carpet_color=black\": { \"model\": \"aestheticseating:block/black/simple_chair_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,reclined=false,carpeted=true,carpet_color=black\": { \"model\": \"aestheticseating:block/black/simple_chair_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,reclined=false,carpeted=true,carpet_color=black\": { \"model\": \"aestheticseating:block/black/simple_chair_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,reclined=false,carpeted=true,carpet_color=black\": { \"model\": \"aestheticseating:block/black/simple_chair_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n    \"facing=north,reclined=true,carpeted=true,carpet_color=black\": { \"model\": \"aestheticseating:block/black/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\" },\n    \"facing=south,reclined=true,carpeted=true,carpet_color=black\": { \"model\": \"aestheticseating:block/black/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\", \"y\": 180 },\n    \"facing=west,reclined=true,carpeted=true,carpet_color=black\": { \"model\": \"aestheticseating:block/black/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\", \"y\": 270 },\n    \"facing=east,reclined=true,carpeted=true,carpet_color=black\": { \"model\": \"aestheticseating:block/black/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\", \"y\": 90 },\n\n    \"facing=north,reclined=false,carpeted=false,carpet_color=brown\": { \"model\": \"aestheticseating:block/brown/simple_chair_WOOD_NAME_VALUE\" },\n    \"facing=south,reclined=false,carpeted=false,carpet_color=brown\": { \"model\": \"aestheticseating:block/brown/simple_chair_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,reclined=false,carpeted=false,carpet_color=brown\": { \"model\": \"aestheticseating:block/brown/simple_chair_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,reclined=false,carpeted=false,carpet_color=brown\": { \"model\": \"aestheticseating:block/brown/simple_chair_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,reclined=true,carpeted=false,carpet_color=brown\": { \"model\": \"aestheticseating:block/brown/simple_chair_WOOD_NAME_VALUE_reclined\" },\n    \"facing=south,reclined=true,carpeted=false,carpet_color=brown\": { \"model\": \"aestheticseating:block/brown/simple_chair_WOOD_NAME_VALUE_reclined\", \"y\": 180 },\n    \"facing=west,reclined=true,carpeted=false,carpet_color=brown\": { \"model\": \"aestheticseating:block/brown/simple_chair_WOOD_NAME_VALUE_reclined\", \"y\": 270 },\n    \"facing=east,reclined=true,carpeted=false,carpet_color=brown\": { \"model\": \"aestheticseating:block/brown/simple_chair_WOOD_NAME_VALUE_reclined\", \"y\": 90 },\n    \"facing=north,reclined=false,carpeted=true,carpet_color=brown\": { \"model\": \"aestheticseating:block/brown/simple_chair_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,reclined=false,carpeted=true,carpet_color=brown\": { \"model\": \"aestheticseating:block/brown/simple_chair_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,reclined=false,carpeted=true,carpet_color=brown\": { \"model\": \"aestheticseating:block/brown/simple_chair_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,reclined=false,carpeted=true,carpet_color=brown\": { \"model\": \"aestheticseating:block/brown/simple_chair_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n    \"facing=north,reclined=true,carpeted=true,carpet_color=brown\": { \"model\": \"aestheticseating:block/brown/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\" },\n    \"facing=south,reclined=true,carpeted=true,carpet_color=brown\": { \"model\": \"aestheticseating:block/brown/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\", \"y\": 180 },\n    \"facing=west,reclined=true,carpeted=true,carpet_color=brown\": { \"model\": \"aestheticseating:block/brown/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\", \"y\": 270 },\n    \"facing=east,reclined=true,carpeted=true,carpet_color=brown\": { \"model\": \"aestheticseating:block/brown/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\", \"y\": 90 },\n\n    \"facing=north,reclined=false,carpeted=false,carpet_color=gray\": { \"model\": \"aestheticseating:block/gray/simple_chair_WOOD_NAME_VALUE\" },\n    \"facing=south,reclined=false,carpeted=false,carpet_color=gray\": { \"model\": \"aestheticseating:block/gray/simple_chair_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,reclined=false,carpeted=false,carpet_color=gray\": { \"model\": \"aestheticseating:block/gray/simple_chair_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,reclined=false,carpeted=false,carpet_color=gray\": { \"model\": \"aestheticseating:block/gray/simple_chair_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,reclined=true,carpeted=false,carpet_color=gray\": { \"model\": \"aestheticseating:block/gray/simple_chair_WOOD_NAME_VALUE_reclined\" },\n    \"facing=south,reclined=true,carpeted=false,carpet_color=gray\": { \"model\": \"aestheticseating:block/gray/simple_chair_WOOD_NAME_VALUE_reclined\", \"y\": 180 },\n    \"facing=west,reclined=true,carpeted=false,carpet_color=gray\": { \"model\": \"aestheticseating:block/gray/simple_chair_WOOD_NAME_VALUE_reclined\", \"y\": 270 },\n    \"facing=east,reclined=true,carpeted=false,carpet_color=gray\": { \"model\": \"aestheticseating:block/gray/simple_chair_WOOD_NAME_VALUE_reclined\", \"y\": 90 },\n    \"facing=north,reclined=false,carpeted=true,carpet_color=gray\": { \"model\": \"aestheticseating:block/gray/simple_chair_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,reclined=false,carpeted=true,carpet_color=gray\": { \"model\": \"aestheticseating:block/gray/simple_chair_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,reclined=false,carpeted=true,carpet_color=gray\": { \"model\": \"aestheticseating:block/gray/simple_chair_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,reclined=false,carpeted=true,carpet_color=gray\": { \"model\": \"aestheticseating:block/gray/simple_chair_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n    \"facing=north,reclined=true,carpeted=true,carpet_color=gray\": { \"model\": \"aestheticseating:block/gray/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\" },\n    \"facing=south,reclined=true,carpeted=true,carpet_color=gray\": { \"model\": \"aestheticseating:block/gray/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\", \"y\": 180 },\n    \"facing=west,reclined=true,carpeted=true,carpet_color=gray\": { \"model\": \"aestheticseating:block/gray/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\", \"y\": 270 },\n    \"facing=east,reclined=true,carpeted=true,carpet_color=gray\": { \"model\": \"aestheticseating:block/gray/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\", \"y\": 90 },\n\n    \"facing=north,reclined=false,carpeted=false,carpet_color=light_gray\": { \"model\": \"aestheticseating:block/light_gray/simple_chair_WOOD_NAME_VALUE\" },\n    \"facing=south,reclined=false,carpeted=false,carpet_color=light_gray\": { \"model\": \"aestheticseating:block/light_gray/simple_chair_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,reclined=false,carpeted=false,carpet_color=light_gray\": { \"model\": \"aestheticseating:block/light_gray/simple_chair_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,reclined=false,carpeted=false,carpet_color=light_gray\": { \"model\": \"aestheticseating:block/light_gray/simple_chair_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,reclined=true,carpeted=false,carpet_color=light_gray\": { \"model\": \"aestheticseating:block/light_gray/simple_chair_WOOD_NAME_VALUE_reclined\" },\n    \"facing=south,reclined=true,carpeted=false,carpet_color=light_gray\": { \"model\": \"aestheticseating:block/light_gray/simple_chair_WOOD_NAME_VALUE_reclined\", \"y\": 180 },\n    \"facing=west,reclined=true,carpeted=false,carpet_color=light_gray\": { \"model\": \"aestheticseating:block/light_gray/simple_chair_WOOD_NAME_VALUE_reclined\", \"y\": 270 },\n    \"facing=east,reclined=true,carpeted=false,carpet_color=light_gray\": { \"model\": \"aestheticseating:block/light_gray/simple_chair_WOOD_NAME_VALUE_reclined\", \"y\": 90 },\n    \"facing=north,reclined=false,carpeted=true,carpet_color=light_gray\": { \"model\": \"aestheticseating:block/light_gray/simple_chair_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,reclined=false,carpeted=true,carpet_color=light_gray\": { \"model\": \"aestheticseating:block/light_gray/simple_chair_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,reclined=false,carpeted=true,carpet_color=light_gray\": { \"model\": \"aestheticseating:block/light_gray/simple_chair_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,reclined=false,carpeted=true,carpet_color=light_gray\": { \"model\": \"aestheticseating:block/light_gray/simple_chair_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n    \"facing=north,reclined=true,carpeted=true,carpet_color=light_gray\": { \"model\": \"aestheticseating:block/light_gray/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\" },\n    \"facing=south,reclined=true,carpeted=true,carpet_color=light_gray\": { \"model\": \"aestheticseating:block/light_gray/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\", \"y\": 180 },\n    \"facing=west,reclined=true,carpeted=true,carpet_color=light_gray\": { \"model\": \"aestheticseating:block/light_gray/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\", \"y\": 270 },\n    \"facing=east,reclined=true,carpeted=true,carpet_color=light_gray\": { \"model\": \"aestheticseating:block/light_gray/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\", \"y\": 90 },\n\n    \"facing=north,reclined=false,carpeted=false,carpet_color=white\": { \"model\": \"aestheticseating:block/white/simple_chair_WOOD_NAME_VALUE\" },\n    \"facing=south,reclined=false,carpeted=false,carpet_color=white\": { \"model\": \"aestheticseating:block/white/simple_chair_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,reclined=false,carpeted=false,carpet_color=white\": { \"model\": \"aestheticseating:block/white/simple_chair_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,reclined=false,carpeted=false,carpet_color=white\": { \"model\": \"aestheticseating:block/white/simple_chair_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,reclined=true,carpeted=false,carpet_color=white\": { \"model\": \"aestheticseating:block/white/simple_chair_WOOD_NAME_VALUE_reclined\" },\n    \"facing=south,reclined=true,carpeted=false,carpet_color=white\": { \"model\": \"aestheticseating:block/white/simple_chair_WOOD_NAME_VALUE_reclined\", \"y\": 180 },\n    \"facing=west,reclined=true,carpeted=false,carpet_color=white\": { \"model\": \"aestheticseating:block/white/simple_chair_WOOD_NAME_VALUE_reclined\", \"y\": 270 },\n    \"facing=east,reclined=true,carpeted=false,carpet_color=white\": { \"model\": \"aestheticseating:block/white/simple_chair_WOOD_NAME_VALUE_reclined\", \"y\": 90 },\n    \"facing=north,reclined=false,carpeted=true,carpet_color=white\": { \"model\": \"aestheticseating:block/white/simple_chair_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,reclined=false,carpeted=true,carpet_color=white\": { \"model\": \"aestheticseating:block/white/simple_chair_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,reclined=false,carpeted=true,carpet_color=white\": { \"model\": \"aestheticseating:block/white/simple_chair_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,reclined=false,carpeted=true,carpet_color=white\": { \"model\": \"aestheticseating:block/white/simple_chair_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n    \"facing=north,reclined=true,carpeted=true,carpet_color=white\": { \"model\": \"aestheticseating:block/white/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\" },\n    \"facing=south,reclined=true,carpeted=true,carpet_color=white\": { \"model\": \"aestheticseating:block/white/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\", \"y\": 180 },\n    \"facing=west,reclined=true,carpeted=true,carpet_color=white\": { \"model\": \"aestheticseating:block/white/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\", \"y\": 270 },\n    \"facing=east,reclined=true,carpeted=true,carpet_color=white\": { \"model\": \"aestheticseating:block/white/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\", \"y\": 90 },\n\n    \"facing=north,reclined=false,carpeted=false,carpet_color=red\": { \"model\": \"aestheticseating:block/red/simple_chair_WOOD_NAME_VALUE\" },\n    \"facing=south,reclined=false,carpeted=false,carpet_color=red\": { \"model\": \"aestheticseating:block/red/simple_chair_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,reclined=false,carpeted=false,carpet_color=red\": { \"model\": \"aestheticseating:block/red/simple_chair_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,reclined=false,carpeted=false,carpet_color=red\": { \"model\": \"aestheticseating:block/red/simple_chair_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,reclined=true,carpeted=false,carpet_color=red\": { \"model\": \"aestheticseating:block/red/simple_chair_WOOD_NAME_VALUE_reclined\" },\n    \"facing=south,reclined=true,carpeted=false,carpet_color=red\": { \"model\": \"aestheticseating:block/red/simple_chair_WOOD_NAME_VALUE_reclined\", \"y\": 180 },\n    \"facing=west,reclined=true,carpeted=false,carpet_color=red\": { \"model\": \"aestheticseating:block/red/simple_chair_WOOD_NAME_VALUE_reclined\", \"y\": 270 },\n    \"facing=east,reclined=true,carpeted=false,carpet_color=red\": { \"model\": \"aestheticseating:block/red/simple_chair_WOOD_NAME_VALUE_reclined\", \"y\": 90 },\n    \"facing=north,reclined=false,carpeted=true,carpet_color=red\": { \"model\": \"aestheticseating:block/red/simple_chair_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,reclined=false,carpeted=true,carpet_color=red\": { \"model\": \"aestheticseating:block/red/simple_chair_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,reclined=false,carpeted=true,carpet_color=red\": { \"model\": \"aestheticseating:block/red/simple_chair_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,reclined=false,carpeted=true,carpet_color=red\": { \"model\": \"aestheticseating:block/red/simple_chair_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n    \"facing=north,reclined=true,carpeted=true,carpet_color=red\": { \"model\": \"aestheticseating:block/red/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\" },\n    \"facing=south,reclined=true,carpeted=true,carpet_color=red\": { \"model\": \"aestheticseating:block/red/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\", \"y\": 180 },\n    \"facing=west,reclined=true,carpeted=true,carpet_color=red\": { \"model\": \"aestheticseating:block/red/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\", \"y\": 270 },\n    \"facing=east,reclined=true,carpeted=true,carpet_color=red\": { \"model\": \"aestheticseating:block/red/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\", \"y\": 90 },\n\n    \"facing=north,reclined=false,carpeted=false,carpet_color=orange\": { \"model\": \"aestheticseating:block/orange/simple_chair_WOOD_NAME_VALUE\" },\n    \"facing=south,reclined=false,carpeted=false,carpet_color=orange\": { \"model\": \"aestheticseating:block/orange/simple_chair_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,reclined=false,carpeted=false,carpet_color=orange\": { \"model\": \"aestheticseating:block/orange/simple_chair_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,reclined=false,carpeted=false,carpet_color=orange\": { \"model\": \"aestheticseating:block/orange/simple_chair_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,reclined=true,carpeted=false,carpet_color=orange\": { \"model\": \"aestheticseating:block/orange/simple_chair_WOOD_NAME_VALUE_reclined\" },\n    \"facing=south,reclined=true,carpeted=false,carpet_color=orange\": { \"model\": \"aestheticseating:block/orange/simple_chair_WOOD_NAME_VALUE_reclined\", \"y\": 180 },\n    \"facing=west,reclined=true,carpeted=false,carpet_color=orange\": { \"model\": \"aestheticseating:block/orange/simple_chair_WOOD_NAME_VALUE_reclined\", \"y\": 270 },\n    \"facing=east,reclined=true,carpeted=false,carpet_color=orange\": { \"model\": \"aestheticseating:block/orange/simple_chair_WOOD_NAME_VALUE_reclined\", \"y\": 90 },\n    \"facing=north,reclined=false,carpeted=true,carpet_color=orange\": { \"model\": \"aestheticseating:block/orange/simple_chair_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,reclined=false,carpeted=true,carpet_color=orange\": { \"model\": \"aestheticseating:block/orange/simple_chair_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,reclined=false,carpeted=true,carpet_color=orange\": { \"model\": \"aestheticseating:block/orange/simple_chair_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,reclined=false,carpeted=true,carpet_color=orange\": { \"model\": \"aestheticseating:block/orange/simple_chair_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n    \"facing=north,reclined=true,carpeted=true,carpet_color=orange\": { \"model\": \"aestheticseating:block/orange/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\" },\n    \"facing=south,reclined=true,carpeted=true,carpet_color=orange\": { \"model\": \"aestheticseating:block/orange/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\", \"y\": 180 },\n    \"facing=west,reclined=true,carpeted=true,carpet_color=orange\": { \"model\": \"aestheticseating:block/orange/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\", \"y\": 270 },\n    \"facing=east,reclined=true,carpeted=true,carpet_color=orange\": { \"model\": \"aestheticseating:block/orange/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\", \"y\": 90 },\n\n    \"facing=north,reclined=false,carpeted=false,carpet_color=yellow\": { \"model\": \"aestheticseating:block/yellow/simple_chair_WOOD_NAME_VALUE\" },\n    \"facing=south,reclined=false,carpeted=false,carpet_color=yellow\": { \"model\": \"aestheticseating:block/yellow/simple_chair_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,reclined=false,carpeted=false,carpet_color=yellow\": { \"model\": \"aestheticseating:block/yellow/simple_chair_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,reclined=false,carpeted=false,carpet_color=yellow\": { \"model\": \"aestheticseating:block/yellow/simple_chair_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,reclined=true,carpeted=false,carpet_color=yellow\": { \"model\": \"aestheticseating:block/yellow/simple_chair_WOOD_NAME_VALUE_reclined\" },\n    \"facing=south,reclined=true,carpeted=false,carpet_color=yellow\": { \"model\": \"aestheticseating:block/yellow/simple_chair_WOOD_NAME_VALUE_reclined\", \"y\": 180 },\n    \"facing=west,reclined=true,carpeted=false,carpet_color=yellow\": { \"model\": \"aestheticseating:block/yellow/simple_chair_WOOD_NAME_VALUE_reclined\", \"y\": 270 },\n    \"facing=east,reclined=true,carpeted=false,carpet_color=yellow\": { \"model\": \"aestheticseating:block/yellow/simple_chair_WOOD_NAME_VALUE_reclined\", \"y\": 90 },\n    \"facing=north,reclined=false,carpeted=true,carpet_color=yellow\": { \"model\": \"aestheticseating:block/yellow/simple_chair_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,reclined=false,carpeted=true,carpet_color=yellow\": { \"model\": \"aestheticseating:block/yellow/simple_chair_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,reclined=false,carpeted=true,carpet_color=yellow\": { \"model\": \"aestheticseating:block/yellow/simple_chair_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,reclined=false,carpeted=true,carpet_color=yellow\": { \"model\": \"aestheticseating:block/yellow/simple_chair_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n    \"facing=north,reclined=true,carpeted=true,carpet_color=yellow\": { \"model\": \"aestheticseating:block/yellow/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\" },\n    \"facing=south,reclined=true,carpeted=true,carpet_color=yellow\": { \"model\": \"aestheticseating:block/yellow/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\", \"y\": 180 },\n    \"facing=west,reclined=true,carpeted=true,carpet_color=yellow\": { \"model\": \"aestheticseating:block/yellow/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\", \"y\": 270 },\n    \"facing=east,reclined=true,carpeted=true,carpet_color=yellow\": { \"model\": \"aestheticseating:block/yellow/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\", \"y\": 90 },\n\n    \"facing=north,reclined=false,carpeted=false,carpet_color=purple\": { \"model\": \"aestheticseating:block/purple/simple_chair_WOOD_NAME_VALUE\" },\n    \"facing=south,reclined=false,carpeted=false,carpet_color=purple\": { \"model\": \"aestheticseating:block/purple/simple_chair_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,reclined=false,carpeted=false,carpet_color=purple\": { \"model\": \"aestheticseating:block/purple/simple_chair_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,reclined=false,carpeted=false,carpet_color=purple\": { \"model\": \"aestheticseating:block/purple/simple_chair_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,reclined=true,carpeted=false,carpet_color=purple\": { \"model\": \"aestheticseating:block/purple/simple_chair_WOOD_NAME_VALUE_reclined\" },\n    \"facing=south,reclined=true,carpeted=false,carpet_color=purple\": { \"model\": \"aestheticseating:block/purple/simple_chair_WOOD_NAME_VALUE_reclined\", \"y\": 180 },\n    \"facing=west,reclined=true,carpeted=false,carpet_color=purple\": { \"model\": \"aestheticseating:block/purple/simple_chair_WOOD_NAME_VALUE_reclined\", \"y\": 270 },\n    \"facing=east,reclined=true,carpeted=false,carpet_color=purple\": { \"model\": \"aestheticseating:block/purple/simple_chair_WOOD_NAME_VALUE_reclined\", \"y\": 90 },\n    \"facing=north,reclined=false,carpeted=true,carpet_color=purple\": { \"model\": \"aestheticseating:block/purple/simple_chair_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,reclined=false,carpeted=true,carpet_color=purple\": { \"model\": \"aestheticseating:block/purple/simple_chair_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,reclined=false,carpeted=true,carpet_color=purple\": { \"model\": \"aestheticseating:block/purple/simple_chair_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,reclined=false,carpeted=true,carpet_color=purple\": { \"model\": \"aestheticseating:block/purple/simple_chair_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n    \"facing=north,reclined=true,carpeted=true,carpet_color=purple\": { \"model\": \"aestheticseating:block/purple/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\" },\n    \"facing=south,reclined=true,carpeted=true,carpet_color=purple\": { \"model\": \"aestheticseating:block/purple/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\", \"y\": 180 },\n    \"facing=west,reclined=true,carpeted=true,carpet_color=purple\": { \"model\": \"aestheticseating:block/purple/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\", \"y\": 270 },\n    \"facing=east,reclined=true,carpeted=true,carpet_color=purple\": { \"model\": \"aestheticseating:block/purple/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\", \"y\": 90 },\n\n    \"facing=north,reclined=false,carpeted=false,carpet_color=magenta\": { \"model\": \"aestheticseating:block/magenta/simple_chair_WOOD_NAME_VALUE\" },\n    \"facing=south,reclined=false,carpeted=false,carpet_color=magenta\": { \"model\": \"aestheticseating:block/magenta/simple_chair_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,reclined=false,carpeted=false,carpet_color=magenta\": { \"model\": \"aestheticseating:block/magenta/simple_chair_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,reclined=false,carpeted=false,carpet_color=magenta\": { \"model\": \"aestheticseating:block/magenta/simple_chair_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,reclined=true,carpeted=false,carpet_color=magenta\": { \"model\": \"aestheticseating:block/magenta/simple_chair_WOOD_NAME_VALUE_reclined\" },\n    \"facing=south,reclined=true,carpeted=false,carpet_color=magenta\": { \"model\": \"aestheticseating:block/magenta/simple_chair_WOOD_NAME_VALUE_reclined\", \"y\": 180 },\n    \"facing=west,reclined=true,carpeted=false,carpet_color=magenta\": { \"model\": \"aestheticseating:block/magenta/simple_chair_WOOD_NAME_VALUE_reclined\", \"y\": 270 },\n    \"facing=east,reclined=true,carpeted=false,carpet_color=magenta\": { \"model\": \"aestheticseating:block/magenta/simple_chair_WOOD_NAME_VALUE_reclined\", \"y\": 90 },\n    \"facing=north,reclined=false,carpeted=true,carpet_color=magenta\": { \"model\": \"aestheticseating:block/magenta/simple_chair_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,reclined=false,carpeted=true,carpet_color=magenta\": { \"model\": \"aestheticseating:block/magenta/simple_chair_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,reclined=false,carpeted=true,carpet_color=magenta\": { \"model\": \"aestheticseating:block/magenta/simple_chair_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,reclined=false,carpeted=true,carpet_color=magenta\": { \"model\": \"aestheticseating:block/magenta/simple_chair_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n    \"facing=north,reclined=true,carpeted=true,carpet_color=magenta\": { \"model\": \"aestheticseating:block/magenta/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\" },\n    \"facing=south,reclined=true,carpeted=true,carpet_color=magenta\": { \"model\": \"aestheticseating:block/magenta/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\", \"y\": 180 },\n    \"facing=west,reclined=true,carpeted=true,carpet_color=magenta\": { \"model\": \"aestheticseating:block/magenta/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\", \"y\": 270 },\n    \"facing=east,reclined=true,carpeted=true,carpet_color=magenta\": { \"model\": \"aestheticseating:block/magenta/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\", \"y\": 90 },\n\n    \"facing=north,reclined=false,carpeted=false,carpet_color=pink\": { \"model\": \"aestheticseating:block/pink/simple_chair_WOOD_NAME_VALUE\" },\n    \"facing=south,reclined=false,carpeted=false,carpet_color=pink\": { \"model\": \"aestheticseating:block/pink/simple_chair_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,reclined=false,carpeted=false,carpet_color=pink\": { \"model\": \"aestheticseating:block/pink/simple_chair_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,reclined=false,carpeted=false,carpet_color=pink\": { \"model\": \"aestheticseating:block/pink/simple_chair_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,reclined=true,carpeted=false,carpet_color=pink\": { \"model\": \"aestheticseating:block/pink/simple_chair_WOOD_NAME_VALUE_reclined\" },\n    \"facing=south,reclined=true,carpeted=false,carpet_color=pink\": { \"model\": \"aestheticseating:block/pink/simple_chair_WOOD_NAME_VALUE_reclined\", \"y\": 180 },\n    \"facing=west,reclined=true,carpeted=false,carpet_color=pink\": { \"model\": \"aestheticseating:block/pink/simple_chair_WOOD_NAME_VALUE_reclined\", \"y\": 270 },\n    \"facing=east,reclined=true,carpeted=false,carpet_color=pink\": { \"model\": \"aestheticseating:block/pink/simple_chair_WOOD_NAME_VALUE_reclined\", \"y\": 90 },\n    \"facing=north,reclined=false,carpeted=true,carpet_color=pink\": { \"model\": \"aestheticseating:block/pink/simple_chair_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,reclined=false,carpeted=true,carpet_color=pink\": { \"model\": \"aestheticseating:block/pink/simple_chair_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,reclined=false,carpeted=true,carpet_color=pink\": { \"model\": \"aestheticseating:block/pink/simple_chair_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,reclined=false,carpeted=true,carpet_color=pink\": { \"model\": \"aestheticseating:block/pink/simple_chair_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n    \"facing=north,reclined=true,carpeted=true,carpet_color=pink\": { \"model\": \"aestheticseating:block/pink/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\" },\n    \"facing=south,reclined=true,carpeted=true,carpet_color=pink\": { \"model\": \"aestheticseating:block/pink/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\", \"y\": 180 },\n    \"facing=west,reclined=true,carpeted=true,carpet_color=pink\": { \"model\": \"aestheticseating:block/pink/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\", \"y\": 270 },\n    \"facing=east,reclined=true,carpeted=true,carpet_color=pink\": { \"model\": \"aestheticseating:block/pink/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\", \"y\": 90 },\n\n    \"facing=north,reclined=false,carpeted=false,carpet_color=blue\": { \"model\": \"aestheticseating:block/blue/simple_chair_WOOD_NAME_VALUE\" },\n    \"facing=south,reclined=false,carpeted=false,carpet_color=blue\": { \"model\": \"aestheticseating:block/blue/simple_chair_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,reclined=false,carpeted=false,carpet_color=blue\": { \"model\": \"aestheticseating:block/blue/simple_chair_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,reclined=false,carpeted=false,carpet_color=blue\": { \"model\": \"aestheticseating:block/blue/simple_chair_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,reclined=true,carpeted=false,carpet_color=blue\": { \"model\": \"aestheticseating:block/blue/simple_chair_WOOD_NAME_VALUE_reclined\" },\n    \"facing=south,reclined=true,carpeted=false,carpet_color=blue\": { \"model\": \"aestheticseating:block/blue/simple_chair_WOOD_NAME_VALUE_reclined\", \"y\": 180 },\n    \"facing=west,reclined=true,carpeted=false,carpet_color=blue\": { \"model\": \"aestheticseating:block/blue/simple_chair_WOOD_NAME_VALUE_reclined\", \"y\": 270 },\n    \"facing=east,reclined=true,carpeted=false,carpet_color=blue\": { \"model\": \"aestheticseating:block/blue/simple_chair_WOOD_NAME_VALUE_reclined\", \"y\": 90 },\n    \"facing=north,reclined=false,carpeted=true,carpet_color=blue\": { \"model\": \"aestheticseating:block/blue/simple_chair_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,reclined=false,carpeted=true,carpet_color=blue\": { \"model\": \"aestheticseating:block/blue/simple_chair_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,reclined=false,carpeted=true,carpet_color=blue\": { \"model\": \"aestheticseating:block/blue/simple_chair_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,reclined=false,carpeted=true,carpet_color=blue\": { \"model\": \"aestheticseating:block/blue/simple_chair_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n    \"facing=north,reclined=true,carpeted=true,carpet_color=blue\": { \"model\": \"aestheticseating:block/blue/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\" },\n    \"facing=south,reclined=true,carpeted=true,carpet_color=blue\": { \"model\": \"aestheticseating:block/blue/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\", \"y\": 180 },\n    \"facing=west,reclined=true,carpeted=true,carpet_color=blue\": { \"model\": \"aestheticseating:block/blue/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\", \"y\": 270 },\n    \"facing=east,reclined=true,carpeted=true,carpet_color=blue\": { \"model\": \"aestheticseating:block/blue/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\", \"y\": 90 },\n\n    \"facing=north,reclined=false,carpeted=false,carpet_color=cyan\": { \"model\": \"aestheticseating:block/cyan/simple_chair_WOOD_NAME_VALUE\" },\n    \"facing=south,reclined=false,carpeted=false,carpet_color=cyan\": { \"model\": \"aestheticseating:block/cyan/simple_chair_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,reclined=false,carpeted=false,carpet_color=cyan\": { \"model\": \"aestheticseating:block/cyan/simple_chair_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,reclined=false,carpeted=false,carpet_color=cyan\": { \"model\": \"aestheticseating:block/cyan/simple_chair_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,reclined=true,carpeted=false,carpet_color=cyan\": { \"model\": \"aestheticseating:block/cyan/simple_chair_WOOD_NAME_VALUE_reclined\" },\n    \"facing=south,reclined=true,carpeted=false,carpet_color=cyan\": { \"model\": \"aestheticseating:block/cyan/simple_chair_WOOD_NAME_VALUE_reclined\", \"y\": 180 },\n    \"facing=west,reclined=true,carpeted=false,carpet_color=cyan\": { \"model\": \"aestheticseating:block/cyan/simple_chair_WOOD_NAME_VALUE_reclined\", \"y\": 270 },\n    \"facing=east,reclined=true,carpeted=false,carpet_color=cyan\": { \"model\": \"aestheticseating:block/cyan/simple_chair_WOOD_NAME_VALUE_reclined\", \"y\": 90 },\n    \"facing=north,reclined=false,carpeted=true,carpet_color=cyan\": { \"model\": \"aestheticseating:block/cyan/simple_chair_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,reclined=false,carpeted=true,carpet_color=cyan\": { \"model\": \"aestheticseating:block/cyan/simple_chair_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,reclined=false,carpeted=true,carpet_color=cyan\": { \"model\": \"aestheticseating:block/cyan/simple_chair_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,reclined=false,carpeted=true,carpet_color=cyan\": { \"model\": \"aestheticseating:block/cyan/simple_chair_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n    \"facing=north,reclined=true,carpeted=true,carpet_color=cyan\": { \"model\": \"aestheticseating:block/cyan/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\" },\n    \"facing=south,reclined=true,carpeted=true,carpet_color=cyan\": { \"model\": \"aestheticseating:block/cyan/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\", \"y\": 180 },\n    \"facing=west,reclined=true,carpeted=true,carpet_color=cyan\": { \"model\": \"aestheticseating:block/cyan/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\", \"y\": 270 },\n    \"facing=east,reclined=true,carpeted=true,carpet_color=cyan\": { \"model\": \"aestheticseating:block/cyan/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\", \"y\": 90 },\n\n    \"facing=north,reclined=false,carpeted=false,carpet_color=light_blue\": { \"model\": \"aestheticseating:block/light_blue/simple_chair_WOOD_NAME_VALUE\" },\n    \"facing=south,reclined=false,carpeted=false,carpet_color=light_blue\": { \"model\": \"aestheticseating:block/light_blue/simple_chair_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,reclined=false,carpeted=false,carpet_color=light_blue\": { \"model\": \"aestheticseating:block/light_blue/simple_chair_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,reclined=false,carpeted=false,carpet_color=light_blue\": { \"model\": \"aestheticseating:block/light_blue/simple_chair_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,reclined=true,carpeted=false,carpet_color=light_blue\": { \"model\": \"aestheticseating:block/light_blue/simple_chair_WOOD_NAME_VALUE_reclined\" },\n    \"facing=south,reclined=true,carpeted=false,carpet_color=light_blue\": { \"model\": \"aestheticseating:block/light_blue/simple_chair_WOOD_NAME_VALUE_reclined\", \"y\": 180 },\n    \"facing=west,reclined=true,carpeted=false,carpet_color=light_blue\": { \"model\": \"aestheticseating:block/light_blue/simple_chair_WOOD_NAME_VALUE_reclined\", \"y\": 270 },\n    \"facing=east,reclined=true,carpeted=false,carpet_color=light_blue\": { \"model\": \"aestheticseating:block/light_blue/simple_chair_WOOD_NAME_VALUE_reclined\", \"y\": 90 },\n    \"facing=north,reclined=false,carpeted=true,carpet_color=light_blue\": { \"model\": \"aestheticseating:block/light_blue/simple_chair_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,reclined=false,carpeted=true,carpet_color=light_blue\": { \"model\": \"aestheticseating:block/light_blue/simple_chair_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,reclined=false,carpeted=true,carpet_color=light_blue\": { \"model\": \"aestheticseating:block/light_blue/simple_chair_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,reclined=false,carpeted=true,carpet_color=light_blue\": { \"model\": \"aestheticseating:block/light_blue/simple_chair_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n    \"facing=north,reclined=true,carpeted=true,carpet_color=light_blue\": { \"model\": \"aestheticseating:block/light_blue/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\" },\n    \"facing=south,reclined=true,carpeted=true,carpet_color=light_blue\": { \"model\": \"aestheticseating:block/light_blue/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\", \"y\": 180 },\n    \"facing=west,reclined=true,carpeted=true,carpet_color=light_blue\": { \"model\": \"aestheticseating:block/light_blue/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\", \"y\": 270 },\n    \"facing=east,reclined=true,carpeted=true,carpet_color=light_blue\": { \"model\": \"aestheticseating:block/light_blue/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\", \"y\": 90 },\n\n    \"facing=north,reclined=false,carpeted=false,carpet_color=green\": { \"model\": \"aestheticseating:block/green/simple_chair_WOOD_NAME_VALUE\" },\n    \"facing=south,reclined=false,carpeted=false,carpet_color=green\": { \"model\": \"aestheticseating:block/green/simple_chair_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,reclined=false,carpeted=false,carpet_color=green\": { \"model\": \"aestheticseating:block/green/simple_chair_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,reclined=false,carpeted=false,carpet_color=green\": { \"model\": \"aestheticseating:block/green/simple_chair_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,reclined=true,carpeted=false,carpet_color=green\": { \"model\": \"aestheticseating:block/green/simple_chair_WOOD_NAME_VALUE_reclined\" },\n    \"facing=south,reclined=true,carpeted=false,carpet_color=green\": { \"model\": \"aestheticseating:block/green/simple_chair_WOOD_NAME_VALUE_reclined\", \"y\": 180 },\n    \"facing=west,reclined=true,carpeted=false,carpet_color=green\": { \"model\": \"aestheticseating:block/green/simple_chair_WOOD_NAME_VALUE_reclined\", \"y\": 270 },\n    \"facing=east,reclined=true,carpeted=false,carpet_color=green\": { \"model\": \"aestheticseating:block/green/simple_chair_WOOD_NAME_VALUE_reclined\", \"y\": 90 },\n    \"facing=north,reclined=false,carpeted=true,carpet_color=green\": { \"model\": \"aestheticseating:block/green/simple_chair_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,reclined=false,carpeted=true,carpet_color=green\": { \"model\": \"aestheticseating:block/green/simple_chair_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,reclined=false,carpeted=true,carpet_color=green\": { \"model\": \"aestheticseating:block/green/simple_chair_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,reclined=false,carpeted=true,carpet_color=green\": { \"model\": \"aestheticseating:block/green/simple_chair_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n    \"facing=north,reclined=true,carpeted=true,carpet_color=green\": { \"model\": \"aestheticseating:block/green/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\" },\n    \"facing=south,reclined=true,carpeted=true,carpet_color=green\": { \"model\": \"aestheticseating:block/green/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\", \"y\": 180 },\n    \"facing=west,reclined=true,carpeted=true,carpet_color=green\": { \"model\": \"aestheticseating:block/green/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\", \"y\": 270 },\n    \"facing=east,reclined=true,carpeted=true,carpet_color=green\": { \"model\": \"aestheticseating:block/green/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\", \"y\": 90 },\n\n    \"facing=north,reclined=false,carpeted=false,carpet_color=lime\": { \"model\": \"aestheticseating:block/lime/simple_chair_WOOD_NAME_VALUE\" },\n    \"facing=south,reclined=false,carpeted=false,carpet_color=lime\": { \"model\": \"aestheticseating:block/lime/simple_chair_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,reclined=false,carpeted=false,carpet_color=lime\": { \"model\": \"aestheticseating:block/lime/simple_chair_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,reclined=false,carpeted=false,carpet_color=lime\": { \"model\": \"aestheticseating:block/lime/simple_chair_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,reclined=true,carpeted=false,carpet_color=lime\": { \"model\": \"aestheticseating:block/lime/simple_chair_WOOD_NAME_VALUE_reclined\" },\n    \"facing=south,reclined=true,carpeted=false,carpet_color=lime\": { \"model\": \"aestheticseating:block/lime/simple_chair_WOOD_NAME_VALUE_reclined\", \"y\": 180 },\n    \"facing=west,reclined=true,carpeted=false,carpet_color=lime\": { \"model\": \"aestheticseating:block/lime/simple_chair_WOOD_NAME_VALUE_reclined\", \"y\": 270 },\n    \"facing=east,reclined=true,carpeted=false,carpet_color=lime\": { \"model\": \"aestheticseating:block/lime/simple_chair_WOOD_NAME_VALUE_reclined\", \"y\": 90 },\n    \"facing=north,reclined=false,carpeted=true,carpet_color=lime\": { \"model\": \"aestheticseating:block/lime/simple_chair_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,reclined=false,carpeted=true,carpet_color=lime\": { \"model\": \"aestheticseating:block/lime/simple_chair_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,reclined=false,carpeted=true,carpet_color=lime\": { \"model\": \"aestheticseating:block/lime/simple_chair_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,reclined=false,carpeted=true,carpet_color=lime\": { \"model\": \"aestheticseating:block/lime/simple_chair_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n    \"facing=north,reclined=true,carpeted=true,carpet_color=lime\": { \"model\": \"aestheticseating:block/lime/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\" },\n    \"facing=south,reclined=true,carpeted=true,carpet_color=lime\": { \"model\": \"aestheticseating:block/lime/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\", \"y\": 180 },\n    \"facing=west,reclined=true,carpeted=true,carpet_color=lime\": { \"model\": \"aestheticseating:block/lime/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\", \"y\": 270 },\n    \"facing=east,reclined=true,carpeted=true,carpet_color=lime\": { \"model\": \"aestheticseating:block/lime/simple_chair_WOOD_NAME_VALUE_reclined_carpeted\", \"y\": 90 }\n  }\n}\n".replace("WOOD_NAME_VALUE", woodName);
        try (FileWriter writer = new FileWriter(modelFile);){
            writer.write(jsonContent);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void createSimpleBenchBlockState(String woodName) {
        String projectPath = System.getProperty("user.dir");
        String filePath = projectPath.replace("build\\datagen", "src\\main\\resources") + "/assets/aestheticseating/blockstates";
        File directory = new File(filePath);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        String fileName = "simple_bench_" + woodName + ".json";
        File modelFile = new File(directory, fileName);
        String jsonContent = "{\n  \"variants\":\n  {\n    \"facing=north,variant=normal,backrest=false\": { \"model\": \"aestheticseating:block/simple_bench_WOOD_NAME_VALUE\" },\n    \"facing=south,variant=normal,backrest=false\": { \"model\": \"aestheticseating:block/simple_bench_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,variant=normal,backrest=false\": { \"model\": \"aestheticseating:block/simple_bench_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,variant=normal,backrest=false\": { \"model\": \"aestheticseating:block/simple_bench_WOOD_NAME_VALUE\", \"y\": 90 },\n\n    \"facing=north,variant=center,backrest=false\": { \"model\": \"aestheticseating:block/simple_bench_WOOD_NAME_VALUE_center\" },\n    \"facing=south,variant=center,backrest=false\": { \"model\": \"aestheticseating:block/simple_bench_WOOD_NAME_VALUE_center\", \"y\": 180 },\n    \"facing=west,variant=center,backrest=false\": { \"model\": \"aestheticseating:block/simple_bench_WOOD_NAME_VALUE_center\", \"y\": 270 },\n    \"facing=east,variant=center,backrest=false\": { \"model\": \"aestheticseating:block/simple_bench_WOOD_NAME_VALUE_center\", \"y\": 90 },\n\n    \"facing=north,variant=left,backrest=false\": { \"model\": \"aestheticseating:block/simple_bench_WOOD_NAME_VALUE_left\" },\n    \"facing=south,variant=left,backrest=false\": { \"model\": \"aestheticseating:block/simple_bench_WOOD_NAME_VALUE_left\", \"y\": 180 },\n    \"facing=west,variant=left,backrest=false\": { \"model\": \"aestheticseating:block/simple_bench_WOOD_NAME_VALUE_left\", \"y\": 270 },\n    \"facing=east,variant=left,backrest=false\": { \"model\": \"aestheticseating:block/simple_bench_WOOD_NAME_VALUE_left\", \"y\": 90 },\n\n    \"facing=north,variant=right,backrest=false\": { \"model\": \"aestheticseating:block/simple_bench_WOOD_NAME_VALUE_right\" },\n    \"facing=south,variant=right,backrest=false\": { \"model\": \"aestheticseating:block/simple_bench_WOOD_NAME_VALUE_right\", \"y\": 180 },\n    \"facing=west,variant=right,backrest=false\": { \"model\": \"aestheticseating:block/simple_bench_WOOD_NAME_VALUE_right\", \"y\": 270 },\n    \"facing=east,variant=right,backrest=false\": { \"model\": \"aestheticseating:block/simple_bench_WOOD_NAME_VALUE_right\", \"y\": 90 },\n\n    \"facing=north,variant=normal,backrest=true\": { \"model\": \"aestheticseating:block/simple_bench_WOOD_NAME_VALUE_backrest\" },\n    \"facing=south,variant=normal,backrest=true\": { \"model\": \"aestheticseating:block/simple_bench_WOOD_NAME_VALUE_backrest\", \"y\": 180 },\n    \"facing=west,variant=normal,backrest=true\": { \"model\": \"aestheticseating:block/simple_bench_WOOD_NAME_VALUE_backrest\", \"y\": 270 },\n    \"facing=east,variant=normal,backrest=true\": { \"model\": \"aestheticseating:block/simple_bench_WOOD_NAME_VALUE_backrest\", \"y\": 90 },\n\n    \"facing=north,variant=center,backrest=true\": { \"model\": \"aestheticseating:block/simple_bench_WOOD_NAME_VALUE_center_backrest\" },\n    \"facing=south,variant=center,backrest=true\": { \"model\": \"aestheticseating:block/simple_bench_WOOD_NAME_VALUE_center_backrest\", \"y\": 180 },\n    \"facing=west,variant=center,backrest=true\": { \"model\": \"aestheticseating:block/simple_bench_WOOD_NAME_VALUE_center_backrest\", \"y\": 270 },\n    \"facing=east,variant=center,backrest=true\": { \"model\": \"aestheticseating:block/simple_bench_WOOD_NAME_VALUE_center_backrest\", \"y\": 90 },\n\n    \"facing=north,variant=left,backrest=true\": { \"model\": \"aestheticseating:block/simple_bench_WOOD_NAME_VALUE_left_backrest\" },\n    \"facing=south,variant=left,backrest=true\": { \"model\": \"aestheticseating:block/simple_bench_WOOD_NAME_VALUE_left_backrest\", \"y\": 180 },\n    \"facing=west,variant=left,backrest=true\": { \"model\": \"aestheticseating:block/simple_bench_WOOD_NAME_VALUE_left_backrest\", \"y\": 270 },\n    \"facing=east,variant=left,backrest=true\": { \"model\": \"aestheticseating:block/simple_bench_WOOD_NAME_VALUE_left_backrest\", \"y\": 90 },\n\n    \"facing=north,variant=right,backrest=true\": { \"model\": \"aestheticseating:block/simple_bench_WOOD_NAME_VALUE_right_backrest\" },\n    \"facing=south,variant=right,backrest=true\": { \"model\": \"aestheticseating:block/simple_bench_WOOD_NAME_VALUE_right_backrest\", \"y\": 180 },\n    \"facing=west,variant=right,backrest=true\": { \"model\": \"aestheticseating:block/simple_bench_WOOD_NAME_VALUE_right_backrest\", \"y\": 270 },\n    \"facing=east,variant=right,backrest=true\": { \"model\": \"aestheticseating:block/simple_bench_WOOD_NAME_VALUE_right_backrest\", \"y\": 90 }\n  }\n}\n".replace("WOOD_NAME_VALUE", woodName);
        try (FileWriter writer = new FileWriter(modelFile);){
            writer.write(jsonContent);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void createStoneBenchBlockState(String stoneName) {
        String projectPath = System.getProperty("user.dir");
        String filePath = projectPath.replace("build\\datagen", "src\\main\\resources") + "/assets/aestheticseating/blockstates";
        File directory = new File(filePath);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        String fileName = "stone_bench_" + stoneName + ".json";
        File modelFile = new File(directory, fileName);
        String jsonContent = "{\n  \"variants\":\n  {\n    \"facing=north,variant=normal\": { \"model\": \"aestheticseating:block/stone_bench_STONE_NAME_VALUE\" },\n    \"facing=south,variant=normal\": { \"model\": \"aestheticseating:block/stone_bench_STONE_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,variant=normal\": { \"model\": \"aestheticseating:block/stone_bench_STONE_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,variant=normal\": { \"model\": \"aestheticseating:block/stone_bench_STONE_NAME_VALUE\", \"y\": 90 },\n\n    \"facing=north,variant=center\": { \"model\": \"aestheticseating:block/stone_bench_STONE_NAME_VALUE_center\" },\n    \"facing=south,variant=center\": { \"model\": \"aestheticseating:block/stone_bench_STONE_NAME_VALUE_center\", \"y\": 180 },\n    \"facing=west,variant=center\": { \"model\": \"aestheticseating:block/stone_bench_STONE_NAME_VALUE_center\", \"y\": 270 },\n    \"facing=east,variant=center\": { \"model\": \"aestheticseating:block/stone_bench_STONE_NAME_VALUE_center\", \"y\": 90 },\n\n    \"facing=north,variant=left\": { \"model\": \"aestheticseating:block/stone_bench_STONE_NAME_VALUE_left\" },\n    \"facing=south,variant=left\": { \"model\": \"aestheticseating:block/stone_bench_STONE_NAME_VALUE_left\", \"y\": 180 },\n    \"facing=west,variant=left\": { \"model\": \"aestheticseating:block/stone_bench_STONE_NAME_VALUE_left\", \"y\": 270 },\n    \"facing=east,variant=left\": { \"model\": \"aestheticseating:block/stone_bench_STONE_NAME_VALUE_left\", \"y\": 90 },\n\n    \"facing=north,variant=right\": { \"model\": \"aestheticseating:block/stone_bench_STONE_NAME_VALUE_right\" },\n    \"facing=south,variant=right\": { \"model\": \"aestheticseating:block/stone_bench_STONE_NAME_VALUE_right\", \"y\": 180 },\n    \"facing=west,variant=right\": { \"model\": \"aestheticseating:block/stone_bench_STONE_NAME_VALUE_right\", \"y\": 270 },\n    \"facing=east,variant=right\": { \"model\": \"aestheticseating:block/stone_bench_STONE_NAME_VALUE_right\", \"y\": 90 }\n  }\n}\n".replace("STONE_NAME_VALUE", stoneName);
        try (FileWriter writer = new FileWriter(modelFile);){
            writer.write(jsonContent);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void createSeatingLogBlockState(String stoneName) {
        String projectPath = System.getProperty("user.dir");
        String filePath = projectPath.replace("build\\datagen", "src\\main\\resources") + "/assets/aestheticseating/blockstates";
        File directory = new File(filePath);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        String fileName = "seating_log_" + stoneName + ".json";
        File modelFile = new File(directory, fileName);
        String jsonContent = "{\n  \"variants\":\n  {\n    \"facing=north,variant=normal\": { \"model\": \"aestheticseating:block/seating_log_WOOD_NAME_VALUE\" },\n    \"facing=south,variant=normal\": { \"model\": \"aestheticseating:block/seating_log_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,variant=normal\": { \"model\": \"aestheticseating:block/seating_log_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,variant=normal\": { \"model\": \"aestheticseating:block/seating_log_WOOD_NAME_VALUE\", \"y\": 90 },\n\n    \"facing=north,variant=center\": { \"model\": \"aestheticseating:block/seating_log_WOOD_NAME_VALUE_center\" },\n    \"facing=south,variant=center\": { \"model\": \"aestheticseating:block/seating_log_WOOD_NAME_VALUE_center\", \"y\": 180 },\n    \"facing=west,variant=center\": { \"model\": \"aestheticseating:block/seating_log_WOOD_NAME_VALUE_center\", \"y\": 270 },\n    \"facing=east,variant=center\": { \"model\": \"aestheticseating:block/seating_log_WOOD_NAME_VALUE_center\", \"y\": 90 },\n\n    \"facing=north,variant=left\": { \"model\": \"aestheticseating:block/seating_log_WOOD_NAME_VALUE_left\" },\n    \"facing=south,variant=left\": { \"model\": \"aestheticseating:block/seating_log_WOOD_NAME_VALUE_left\", \"y\": 180 },\n    \"facing=west,variant=left\": { \"model\": \"aestheticseating:block/seating_log_WOOD_NAME_VALUE_left\", \"y\": 270 },\n    \"facing=east,variant=left\": { \"model\": \"aestheticseating:block/seating_log_WOOD_NAME_VALUE_left\", \"y\": 90 },\n\n    \"facing=north,variant=right\": { \"model\": \"aestheticseating:block/seating_log_WOOD_NAME_VALUE_right\" },\n    \"facing=south,variant=right\": { \"model\": \"aestheticseating:block/seating_log_WOOD_NAME_VALUE_right\", \"y\": 180 },\n    \"facing=west,variant=right\": { \"model\": \"aestheticseating:block/seating_log_WOOD_NAME_VALUE_right\", \"y\": 270 },\n    \"facing=east,variant=right\": { \"model\": \"aestheticseating:block/seating_log_WOOD_NAME_VALUE_right\", \"y\": 90 }\n  }\n}\n".replace("WOOD_NAME_VALUE", stoneName);
        try (FileWriter writer = new FileWriter(modelFile);){
            writer.write(jsonContent);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void createSetteeModel(String jsonContent, String colorName, String modId, boolean isTransformed, int variant) {
        String projectPath = System.getProperty("user.dir");
        String filePath = projectPath.replace("build\\datagen", "src\\main\\resources") + "/assets/aestheticseating/models/block/";
        File directory = new File(filePath);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        String fileName = "settee_" + colorName + (isTransformed ? "_transformed" : "") + "_" + variant + ".json";
        File modelFile = new File(directory, fileName);
        jsonContent = jsonContent.replace("COLOR_NAME", modId + ":block/" + colorName + "_wool");
        try (FileWriter writer = new FileWriter(modelFile);){
            writer.write(jsonContent);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void createSofaModel(String jsonContent, String colorName, String modId, String variant, Boolean isCushion) {
        String projectPath = System.getProperty("user.dir");
        String filePath = projectPath.replace("build\\datagen", "src\\main\\resources") + "/assets/aestheticseating/models/block/";
        File directory = new File(filePath);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        String fileName = "sofa_" + colorName + (String)(variant.equals("normal") ? "" : "_" + variant) + (isCushion != false ? "_cushion" : "") + ".json";
        File modelFile = new File(directory, fileName);
        jsonContent = jsonContent.replace("COLOR_NAME", modId + ":block/" + colorName + "_wool");
        try (FileWriter writer = new FileWriter(modelFile);){
            writer.write(jsonContent);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void createSetteeBlockState(String colorName) {
        String projectPath = System.getProperty("user.dir");
        String filePath = projectPath.replace("build\\datagen", "src\\main\\resources") + "/assets/aestheticseating/blockstates";
        File directory = new File(filePath);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        String fileName = "settee_" + colorName + ".json";
        File modelFile = new File(directory, fileName);
        String jsonContent = "{\n  \"variants\":\n  {\n    \"facing=north,transformed=false,variant=0\": { \"model\": \"aestheticseating:block/settee_COLOR_NAME_VALUE_0\" },\n    \"facing=south,transformed=false,variant=0\": { \"model\": \"aestheticseating:block/settee_COLOR_NAME_VALUE_0\", \"y\": 180 },\n    \"facing=west,transformed=false,variant=0\": { \"model\": \"aestheticseating:block/settee_COLOR_NAME_VALUE_0\", \"y\": 270 },\n    \"facing=east,transformed=false,variant=0\": { \"model\": \"aestheticseating:block/settee_COLOR_NAME_VALUE_0\", \"y\": 90 },\n    \"facing=north,transformed=true,variant=0\": { \"model\": \"aestheticseating:block/settee_COLOR_NAME_VALUE_transformed_0\" },\n    \"facing=south,transformed=true,variant=0\": { \"model\": \"aestheticseating:block/settee_COLOR_NAME_VALUE_transformed_0\", \"y\": 180 },\n    \"facing=west,transformed=true,variant=0\": { \"model\": \"aestheticseating:block/settee_COLOR_NAME_VALUE_transformed_0\", \"y\": 270 },\n    \"facing=east,transformed=true,variant=0\": { \"model\": \"aestheticseating:block/settee_COLOR_NAME_VALUE_transformed_0\", \"y\": 90 },\n    \"facing=north,transformed=false,variant=1\": { \"model\": \"aestheticseating:block/settee_COLOR_NAME_VALUE_1\" },\n    \"facing=south,transformed=false,variant=1\": { \"model\": \"aestheticseating:block/settee_COLOR_NAME_VALUE_1\", \"y\": 180 },\n    \"facing=west,transformed=false,variant=1\": { \"model\": \"aestheticseating:block/settee_COLOR_NAME_VALUE_1\", \"y\": 270 },\n    \"facing=east,transformed=false,variant=1\": { \"model\": \"aestheticseating:block/settee_COLOR_NAME_VALUE_1\", \"y\": 90 },\n    \"facing=north,transformed=true,variant=1\": { \"model\": \"aestheticseating:block/settee_COLOR_NAME_VALUE_transformed_1\" },\n    \"facing=south,transformed=true,variant=1\": { \"model\": \"aestheticseating:block/settee_COLOR_NAME_VALUE_transformed_1\", \"y\": 180 },\n    \"facing=west,transformed=true,variant=1\": { \"model\": \"aestheticseating:block/settee_COLOR_NAME_VALUE_transformed_1\", \"y\": 270 },\n    \"facing=east,transformed=true,variant=1\": { \"model\": \"aestheticseating:block/settee_COLOR_NAME_VALUE_transformed_1\", \"y\": 90 },\n    \"facing=north,transformed=false,variant=2\": { \"model\": \"aestheticseating:block/settee_COLOR_NAME_VALUE_2\" },\n    \"facing=south,transformed=false,variant=2\": { \"model\": \"aestheticseating:block/settee_COLOR_NAME_VALUE_2\", \"y\": 180 },\n    \"facing=west,transformed=false,variant=2\": { \"model\": \"aestheticseating:block/settee_COLOR_NAME_VALUE_2\", \"y\": 270 },\n    \"facing=east,transformed=false,variant=2\": { \"model\": \"aestheticseating:block/settee_COLOR_NAME_VALUE_2\", \"y\": 90 },\n    \"facing=north,transformed=true,variant=2\": { \"model\": \"aestheticseating:block/settee_COLOR_NAME_VALUE_transformed_2\" },\n    \"facing=south,transformed=true,variant=2\": { \"model\": \"aestheticseating:block/settee_COLOR_NAME_VALUE_transformed_2\", \"y\": 180 },\n    \"facing=west,transformed=true,variant=2\": { \"model\": \"aestheticseating:block/settee_COLOR_NAME_VALUE_transformed_2\", \"y\": 270 },\n    \"facing=east,transformed=true,variant=2\": { \"model\": \"aestheticseating:block/settee_COLOR_NAME_VALUE_transformed_2\", \"y\": 90 }\n  }\n}\n".replace("COLOR_NAME_VALUE", colorName);
        try (FileWriter writer = new FileWriter(modelFile);){
            writer.write(jsonContent);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void createSofaBlockState(String colorName) {
        String projectPath = System.getProperty("user.dir");
        String filePath = projectPath.replace("build\\datagen", "src\\main\\resources") + "/assets/aestheticseating/blockstates";
        File directory = new File(filePath);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        String fileName = "sofa_" + colorName + ".json";
        File modelFile = new File(directory, fileName);
        String jsonContent = "{\n  \"variants\":\n  {\n    \"facing=north,variant=normal,cushion=false\": { \"model\": \"aestheticseating:block/sofa_COLOR_NAME_VALUE\" },\n    \"facing=south,variant=normal,cushion=false\": { \"model\": \"aestheticseating:block/sofa_COLOR_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,variant=normal,cushion=false\": { \"model\": \"aestheticseating:block/sofa_COLOR_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,variant=normal,cushion=false\": { \"model\": \"aestheticseating:block/sofa_COLOR_NAME_VALUE\", \"y\": 90 },\n\n    \"facing=north,variant=center,cushion=false\": { \"model\": \"aestheticseating:block/sofa_COLOR_NAME_VALUE_center\" },\n    \"facing=south,variant=center,cushion=false\": { \"model\": \"aestheticseating:block/sofa_COLOR_NAME_VALUE_center\", \"y\": 180 },\n    \"facing=west,variant=center,cushion=false\": { \"model\": \"aestheticseating:block/sofa_COLOR_NAME_VALUE_center\", \"y\": 270 },\n    \"facing=east,variant=center,cushion=false\": { \"model\": \"aestheticseating:block/sofa_COLOR_NAME_VALUE_center\", \"y\": 90 },\n\n    \"facing=north,variant=left,cushion=false\": { \"model\": \"aestheticseating:block/sofa_COLOR_NAME_VALUE_left\" },\n    \"facing=south,variant=left,cushion=false\": { \"model\": \"aestheticseating:block/sofa_COLOR_NAME_VALUE_left\", \"y\": 180 },\n    \"facing=west,variant=left,cushion=false\": { \"model\": \"aestheticseating:block/sofa_COLOR_NAME_VALUE_left\", \"y\": 270 },\n    \"facing=east,variant=left,cushion=false\": { \"model\": \"aestheticseating:block/sofa_COLOR_NAME_VALUE_left\", \"y\": 90 },\n\n    \"facing=north,variant=right,cushion=false\": { \"model\": \"aestheticseating:block/sofa_COLOR_NAME_VALUE_right\" },\n    \"facing=south,variant=right,cushion=false\": { \"model\": \"aestheticseating:block/sofa_COLOR_NAME_VALUE_right\", \"y\": 180 },\n    \"facing=west,variant=right,cushion=false\": { \"model\": \"aestheticseating:block/sofa_COLOR_NAME_VALUE_right\", \"y\": 270 },\n    \"facing=east,variant=right,cushion=false\": { \"model\": \"aestheticseating:block/sofa_COLOR_NAME_VALUE_right\", \"y\": 90 },\n\n    \"facing=north,variant=leftcorner,cushion=false\": { \"model\": \"aestheticseating:block/sofa_COLOR_NAME_VALUE_leftcorner\" },\n    \"facing=south,variant=leftcorner,cushion=false\": { \"model\": \"aestheticseating:block/sofa_COLOR_NAME_VALUE_leftcorner\", \"y\": 180 },\n    \"facing=west,variant=leftcorner,cushion=false\": { \"model\": \"aestheticseating:block/sofa_COLOR_NAME_VALUE_leftcorner\", \"y\": 270 },\n    \"facing=east,variant=leftcorner,cushion=false\": { \"model\": \"aestheticseating:block/sofa_COLOR_NAME_VALUE_leftcorner\", \"y\": 90 },\n\n    \"facing=north,variant=rightcorner,cushion=false\": { \"model\": \"aestheticseating:block/sofa_COLOR_NAME_VALUE_rightcorner\" },\n    \"facing=south,variant=rightcorner,cushion=false\": { \"model\": \"aestheticseating:block/sofa_COLOR_NAME_VALUE_rightcorner\", \"y\": 180 },\n    \"facing=west,variant=rightcorner,cushion=false\": { \"model\": \"aestheticseating:block/sofa_COLOR_NAME_VALUE_rightcorner\", \"y\": 270 },\n    \"facing=east,variant=rightcorner,cushion=false\": { \"model\": \"aestheticseating:block/sofa_COLOR_NAME_VALUE_rightcorner\", \"y\": 90 },\n\n    \"facing=north,variant=normal,cushion=true\": { \"model\": \"aestheticseating:block/sofa_COLOR_NAME_VALUE_cushion\" },\n    \"facing=south,variant=normal,cushion=true\": { \"model\": \"aestheticseating:block/sofa_COLOR_NAME_VALUE_cushion\", \"y\": 180 },\n    \"facing=west,variant=normal,cushion=true\": { \"model\": \"aestheticseating:block/sofa_COLOR_NAME_VALUE_cushion\", \"y\": 270 },\n    \"facing=east,variant=normal,cushion=true\": { \"model\": \"aestheticseating:block/sofa_COLOR_NAME_VALUE_cushion\", \"y\": 90 },\n\n    \"facing=north,variant=center,cushion=true\": { \"model\": \"aestheticseating:block/sofa_COLOR_NAME_VALUE_center_cushion\" },\n    \"facing=south,variant=center,cushion=true\": { \"model\": \"aestheticseating:block/sofa_COLOR_NAME_VALUE_center_cushion\", \"y\": 180 },\n    \"facing=west,variant=center,cushion=true\": { \"model\": \"aestheticseating:block/sofa_COLOR_NAME_VALUE_center_cushion\", \"y\": 270 },\n    \"facing=east,variant=center,cushion=true\": { \"model\": \"aestheticseating:block/sofa_COLOR_NAME_VALUE_center_cushion\", \"y\": 90 },\n\n    \"facing=north,variant=left,cushion=true\": { \"model\": \"aestheticseating:block/sofa_COLOR_NAME_VALUE_left_cushion\" },\n    \"facing=south,variant=left,cushion=true\": { \"model\": \"aestheticseating:block/sofa_COLOR_NAME_VALUE_left_cushion\", \"y\": 180 },\n    \"facing=west,variant=left,cushion=true\": { \"model\": \"aestheticseating:block/sofa_COLOR_NAME_VALUE_left_cushion\", \"y\": 270 },\n    \"facing=east,variant=left,cushion=true\": { \"model\": \"aestheticseating:block/sofa_COLOR_NAME_VALUE_left_cushion\", \"y\": 90 },\n\n    \"facing=north,variant=right,cushion=true\": { \"model\": \"aestheticseating:block/sofa_COLOR_NAME_VALUE_right_cushion\" },\n    \"facing=south,variant=right,cushion=true\": { \"model\": \"aestheticseating:block/sofa_COLOR_NAME_VALUE_right_cushion\", \"y\": 180 },\n    \"facing=west,variant=right,cushion=true\": { \"model\": \"aestheticseating:block/sofa_COLOR_NAME_VALUE_right_cushion\", \"y\": 270 },\n    \"facing=east,variant=right,cushion=true\": { \"model\": \"aestheticseating:block/sofa_COLOR_NAME_VALUE_right_cushion\", \"y\": 90 },\n\n    \"facing=north,variant=leftcorner,cushion=true\": { \"model\": \"aestheticseating:block/sofa_COLOR_NAME_VALUE_leftcorner_cushion\" },\n    \"facing=south,variant=leftcorner,cushion=true\": { \"model\": \"aestheticseating:block/sofa_COLOR_NAME_VALUE_leftcorner_cushion\", \"y\": 180 },\n    \"facing=west,variant=leftcorner,cushion=true\": { \"model\": \"aestheticseating:block/sofa_COLOR_NAME_VALUE_leftcorner_cushion\", \"y\": 270 },\n    \"facing=east,variant=leftcorner,cushion=true\": { \"model\": \"aestheticseating:block/sofa_COLOR_NAME_VALUE_leftcorner_cushion\", \"y\": 90 },\n\n    \"facing=north,variant=rightcorner,cushion=true\": { \"model\": \"aestheticseating:block/sofa_COLOR_NAME_VALUE_rightcorner_cushion\" },\n    \"facing=south,variant=rightcorner,cushion=true\": { \"model\": \"aestheticseating:block/sofa_COLOR_NAME_VALUE_rightcorner_cushion\", \"y\": 180 },\n    \"facing=west,variant=rightcorner,cushion=true\": { \"model\": \"aestheticseating:block/sofa_COLOR_NAME_VALUE_rightcorner_cushion\", \"y\": 270 },\n    \"facing=east,variant=rightcorner,cushion=true\": { \"model\": \"aestheticseating:block/sofa_COLOR_NAME_VALUE_rightcorner_cushion\", \"y\": 90 }\n  }\n}\n".replace("COLOR_NAME_VALUE", colorName);
        try (FileWriter writer = new FileWriter(modelFile);){
            writer.write(jsonContent);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void createCushionModel(String colorName, String modId) {
        String projectPath = System.getProperty("user.dir");
        String filePath = projectPath.replace("build\\datagen", "src\\main\\resources") + "/assets/aestheticseating/models/block/";
        File directory = new File(filePath);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        String fileName = "cushion_" + colorName + ".json";
        File modelFile = new File(directory, fileName);
        String jsonContent = "{\n\t\"credit\": \"Made with Blockbench\",\n\t\"textures\": {\n\t\t\"0\": \"COLOR_NAME\",\n\t\t\"particle\": \"COLOR_NAME\"\n\t},\n\t\"elements\": [\n\t\t{\n\t\t\t\"from\": [3, 0, 3],\n\t\t\t\"to\": [13, 4, 13],\n\t\t\t\"rotation\": {\"angle\": 0, \"axis\": \"y\", \"origin\": [8, 1, 8]},\n\t\t\t\"faces\": {\n\t\t\t\t\"north\": {\"uv\": [0, 0, 10, 4], \"texture\": \"#0\"},\n\t\t\t\t\"east\": {\"uv\": [0, 0, 10, 4], \"texture\": \"#0\"},\n\t\t\t\t\"south\": {\"uv\": [0, 0, 10, 4], \"texture\": \"#0\"},\n\t\t\t\t\"west\": {\"uv\": [0, 0, 10, 4], \"texture\": \"#0\"},\n\t\t\t\t\"up\": {\"uv\": [10, 10, 0, 0], \"texture\": \"#0\"},\n\t\t\t\t\"down\": {\"uv\": [10, 0, 0, 10], \"texture\": \"#0\"}\n\t\t\t}\n\t\t}\n\t],\n\t\"display\": {\n\t\t\"thirdperson_righthand\": {\n\t\t\t\"rotation\": [-56.75, 0, 0],\n\t\t\t\"translation\": [0, 4.25, -2.25],\n\t\t\t\"scale\": [0.7, 0.7, 0.7]\n\t\t},\n\t\t\"thirdperson_lefthand\": {\n\t\t\t\"rotation\": [-56.75, 0, 0],\n\t\t\t\"translation\": [0, 4.25, -2.25],\n\t\t\t\"scale\": [0.7, 0.7, 0.7]\n\t\t},\n\t\t\"firstperson_righthand\": {\n\t\t\t\"rotation\": [56.75, 0, 0],\n\t\t\t\"translation\": [0, 7, 7],\n\t\t\t\"scale\": [0.7, 0.7, 0.7]\n\t\t},\n\t\t\"firstperson_lefthand\": {\n\t\t\t\"rotation\": [56.75, 0, 0],\n\t\t\t\"translation\": [0, 7, 7],\n\t\t\t\"scale\": [0.7, 0.7, 0.7]\n\t\t},\n\t\t\"ground\": {\n\t\t\t\"translation\": [0, 4, 0]\n\t\t},\n\t\t\"gui\": {\n\t\t\t\"rotation\": [20, 45, 0],\n\t\t\t\"translation\": [0, 6, 0]\n\t\t},\n\t\t\"fixed\": {\n\t\t\t\"rotation\": [90, 0, 0],\n\t\t\t\"translation\": [0, 0, 6]\n\t\t}\n\t}\n}\n".replace("COLOR_NAME", modId + ":block/" + colorName + "_wool");
        try (FileWriter writer = new FileWriter(modelFile);){
            writer.write(jsonContent);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void createSimpleStoolModel(String jsonContent, String colorName, String woodName, String modId, String form, boolean isCarpeted) {
        String projectPath = System.getProperty("user.dir");
        String filePath = projectPath.replace("build\\datagen", "src\\main\\resources") + "/assets/aestheticseating/models/block/" + colorName;
        File directory = new File(filePath);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        String fileName = "simple_stool_" + form + "_" + woodName + (isCarpeted ? "_carpeted" : "") + ".json";
        File modelFile = new File(directory, fileName);
        String logName = woodName.equals("crimson") || woodName.equals("warped") ? "stem" : (woodName.equals("bamboo") ? "block" : "log");
        jsonContent = jsonContent.replace("COLOR_NAME", colorName).replace("BASE_NAME", modId + ":block/stripped_" + woodName + "_" + logName).replace("LOG_NAME", modId + ":block/" + woodName + "_" + logName);
        try (FileWriter writer = new FileWriter(modelFile);){
            writer.write(jsonContent);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void createSimpleStoolBlockState(String woodName) {
        String projectPath = System.getProperty("user.dir");
        String filePath = projectPath.replace("build\\datagen", "src\\main\\resources") + "/assets/aestheticseating/blockstates";
        File directory = new File(filePath);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        String fileName = "simple_stool_" + woodName + ".json";
        File modelFile = new File(directory, fileName);
        String jsonContent = "{\n  \"variants\":\n  {\n    \"facing=north,form=normal,carpeted=false,carpet_color=black\": { \"model\": \"aestheticseating:block/black/simple_stool_normal_WOOD_NAME_VALUE\" },\n    \"facing=south,form=normal,carpeted=false,carpet_color=black\": { \"model\": \"aestheticseating:block/black/simple_stool_normal_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,form=normal,carpeted=false,carpet_color=black\": { \"model\": \"aestheticseating:block/black/simple_stool_normal_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,form=normal,carpeted=false,carpet_color=black\": { \"model\": \"aestheticseating:block/black/simple_stool_normal_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,form=normal,carpeted=true,carpet_color=black\": { \"model\": \"aestheticseating:block/black/simple_stool_normal_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,form=normal,carpeted=true,carpet_color=black\": { \"model\": \"aestheticseating:block/black/simple_stool_normal_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,form=normal,carpeted=true,carpet_color=black\": { \"model\": \"aestheticseating:block/black/simple_stool_normal_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,form=normal,carpeted=true,carpet_color=black\": { \"model\": \"aestheticseating:block/black/simple_stool_normal_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n    \"facing=north,form=latticeback,carpeted=false,carpet_color=black\": { \"model\": \"aestheticseating:block/black/simple_stool_latticeback_WOOD_NAME_VALUE\" },\n    \"facing=south,form=latticeback,carpeted=false,carpet_color=black\": { \"model\": \"aestheticseating:block/black/simple_stool_latticeback_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,form=latticeback,carpeted=false,carpet_color=black\": { \"model\": \"aestheticseating:block/black/simple_stool_latticeback_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,form=latticeback,carpeted=false,carpet_color=black\": { \"model\": \"aestheticseating:block/black/simple_stool_latticeback_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,form=latticeback,carpeted=true,carpet_color=black\": { \"model\": \"aestheticseating:block/black/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,form=latticeback,carpeted=true,carpet_color=black\": { \"model\": \"aestheticseating:block/black/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,form=latticeback,carpeted=true,carpet_color=black\": { \"model\": \"aestheticseating:block/black/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,form=latticeback,carpeted=true,carpet_color=black\": { \"model\": \"aestheticseating:block/black/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n    \"facing=north,form=desk,carpeted=false,carpet_color=black\": { \"model\": \"aestheticseating:block/black/simple_stool_desk_WOOD_NAME_VALUE\" },\n    \"facing=south,form=desk,carpeted=false,carpet_color=black\": { \"model\": \"aestheticseating:block/black/simple_stool_desk_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,form=desk,carpeted=false,carpet_color=black\": { \"model\": \"aestheticseating:block/black/simple_stool_desk_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,form=desk,carpeted=false,carpet_color=black\": { \"model\": \"aestheticseating:block/black/simple_stool_desk_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,form=desk,carpeted=true,carpet_color=black\": { \"model\": \"aestheticseating:block/black/simple_stool_desk_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,form=desk,carpeted=true,carpet_color=black\": { \"model\": \"aestheticseating:block/black/simple_stool_desk_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,form=desk,carpeted=true,carpet_color=black\": { \"model\": \"aestheticseating:block/black/simple_stool_desk_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,form=desk,carpeted=true,carpet_color=black\": { \"model\": \"aestheticseating:block/black/simple_stool_desk_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n\n    \"facing=north,form=normal,carpeted=false,carpet_color=brown\": { \"model\": \"aestheticseating:block/brown/simple_stool_normal_WOOD_NAME_VALUE\" },\n    \"facing=south,form=normal,carpeted=false,carpet_color=brown\": { \"model\": \"aestheticseating:block/brown/simple_stool_normal_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,form=normal,carpeted=false,carpet_color=brown\": { \"model\": \"aestheticseating:block/brown/simple_stool_normal_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,form=normal,carpeted=false,carpet_color=brown\": { \"model\": \"aestheticseating:block/brown/simple_stool_normal_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,form=normal,carpeted=true,carpet_color=brown\": { \"model\": \"aestheticseating:block/brown/simple_stool_normal_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,form=normal,carpeted=true,carpet_color=brown\": { \"model\": \"aestheticseating:block/brown/simple_stool_normal_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,form=normal,carpeted=true,carpet_color=brown\": { \"model\": \"aestheticseating:block/brown/simple_stool_normal_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,form=normal,carpeted=true,carpet_color=brown\": { \"model\": \"aestheticseating:block/brown/simple_stool_normal_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n    \"facing=north,form=latticeback,carpeted=false,carpet_color=brown\": { \"model\": \"aestheticseating:block/brown/simple_stool_latticeback_WOOD_NAME_VALUE\" },\n    \"facing=south,form=latticeback,carpeted=false,carpet_color=brown\": { \"model\": \"aestheticseating:block/brown/simple_stool_latticeback_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,form=latticeback,carpeted=false,carpet_color=brown\": { \"model\": \"aestheticseating:block/brown/simple_stool_latticeback_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,form=latticeback,carpeted=false,carpet_color=brown\": { \"model\": \"aestheticseating:block/brown/simple_stool_latticeback_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,form=latticeback,carpeted=true,carpet_color=brown\": { \"model\": \"aestheticseating:block/brown/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,form=latticeback,carpeted=true,carpet_color=brown\": { \"model\": \"aestheticseating:block/brown/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,form=latticeback,carpeted=true,carpet_color=brown\": { \"model\": \"aestheticseating:block/brown/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,form=latticeback,carpeted=true,carpet_color=brown\": { \"model\": \"aestheticseating:block/brown/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n    \"facing=north,form=desk,carpeted=false,carpet_color=brown\": { \"model\": \"aestheticseating:block/brown/simple_stool_desk_WOOD_NAME_VALUE\" },\n    \"facing=south,form=desk,carpeted=false,carpet_color=brown\": { \"model\": \"aestheticseating:block/brown/simple_stool_desk_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,form=desk,carpeted=false,carpet_color=brown\": { \"model\": \"aestheticseating:block/brown/simple_stool_desk_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,form=desk,carpeted=false,carpet_color=brown\": { \"model\": \"aestheticseating:block/brown/simple_stool_desk_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,form=desk,carpeted=true,carpet_color=brown\": { \"model\": \"aestheticseating:block/brown/simple_stool_desk_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,form=desk,carpeted=true,carpet_color=brown\": { \"model\": \"aestheticseating:block/brown/simple_stool_desk_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,form=desk,carpeted=true,carpet_color=brown\": { \"model\": \"aestheticseating:block/brown/simple_stool_desk_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,form=desk,carpeted=true,carpet_color=brown\": { \"model\": \"aestheticseating:block/brown/simple_stool_desk_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n\n    \"facing=north,form=normal,carpeted=false,carpet_color=gray\": { \"model\": \"aestheticseating:block/gray/simple_stool_normal_WOOD_NAME_VALUE\" },\n    \"facing=south,form=normal,carpeted=false,carpet_color=gray\": { \"model\": \"aestheticseating:block/gray/simple_stool_normal_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,form=normal,carpeted=false,carpet_color=gray\": { \"model\": \"aestheticseating:block/gray/simple_stool_normal_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,form=normal,carpeted=false,carpet_color=gray\": { \"model\": \"aestheticseating:block/gray/simple_stool_normal_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,form=normal,carpeted=true,carpet_color=gray\": { \"model\": \"aestheticseating:block/gray/simple_stool_normal_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,form=normal,carpeted=true,carpet_color=gray\": { \"model\": \"aestheticseating:block/gray/simple_stool_normal_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,form=normal,carpeted=true,carpet_color=gray\": { \"model\": \"aestheticseating:block/gray/simple_stool_normal_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,form=normal,carpeted=true,carpet_color=gray\": { \"model\": \"aestheticseating:block/gray/simple_stool_normal_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n    \"facing=north,form=latticeback,carpeted=false,carpet_color=gray\": { \"model\": \"aestheticseating:block/gray/simple_stool_latticeback_WOOD_NAME_VALUE\" },\n    \"facing=south,form=latticeback,carpeted=false,carpet_color=gray\": { \"model\": \"aestheticseating:block/gray/simple_stool_latticeback_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,form=latticeback,carpeted=false,carpet_color=gray\": { \"model\": \"aestheticseating:block/gray/simple_stool_latticeback_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,form=latticeback,carpeted=false,carpet_color=gray\": { \"model\": \"aestheticseating:block/gray/simple_stool_latticeback_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,form=latticeback,carpeted=true,carpet_color=gray\": { \"model\": \"aestheticseating:block/gray/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,form=latticeback,carpeted=true,carpet_color=gray\": { \"model\": \"aestheticseating:block/gray/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,form=latticeback,carpeted=true,carpet_color=gray\": { \"model\": \"aestheticseating:block/gray/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,form=latticeback,carpeted=true,carpet_color=gray\": { \"model\": \"aestheticseating:block/gray/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n    \"facing=north,form=desk,carpeted=false,carpet_color=gray\": { \"model\": \"aestheticseating:block/gray/simple_stool_desk_WOOD_NAME_VALUE\" },\n    \"facing=south,form=desk,carpeted=false,carpet_color=gray\": { \"model\": \"aestheticseating:block/gray/simple_stool_desk_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,form=desk,carpeted=false,carpet_color=gray\": { \"model\": \"aestheticseating:block/gray/simple_stool_desk_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,form=desk,carpeted=false,carpet_color=gray\": { \"model\": \"aestheticseating:block/gray/simple_stool_desk_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,form=desk,carpeted=true,carpet_color=gray\": { \"model\": \"aestheticseating:block/gray/simple_stool_desk_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,form=desk,carpeted=true,carpet_color=gray\": { \"model\": \"aestheticseating:block/gray/simple_stool_desk_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,form=desk,carpeted=true,carpet_color=gray\": { \"model\": \"aestheticseating:block/gray/simple_stool_desk_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,form=desk,carpeted=true,carpet_color=gray\": { \"model\": \"aestheticseating:block/gray/simple_stool_desk_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n\n    \"facing=north,form=normal,carpeted=false,carpet_color=light_gray\": { \"model\": \"aestheticseating:block/light_gray/simple_stool_normal_WOOD_NAME_VALUE\" },\n    \"facing=south,form=normal,carpeted=false,carpet_color=light_gray\": { \"model\": \"aestheticseating:block/light_gray/simple_stool_normal_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,form=normal,carpeted=false,carpet_color=light_gray\": { \"model\": \"aestheticseating:block/light_gray/simple_stool_normal_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,form=normal,carpeted=false,carpet_color=light_gray\": { \"model\": \"aestheticseating:block/light_gray/simple_stool_normal_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,form=normal,carpeted=true,carpet_color=light_gray\": { \"model\": \"aestheticseating:block/light_gray/simple_stool_normal_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,form=normal,carpeted=true,carpet_color=light_gray\": { \"model\": \"aestheticseating:block/light_gray/simple_stool_normal_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,form=normal,carpeted=true,carpet_color=light_gray\": { \"model\": \"aestheticseating:block/light_gray/simple_stool_normal_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,form=normal,carpeted=true,carpet_color=light_gray\": { \"model\": \"aestheticseating:block/light_gray/simple_stool_normal_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n    \"facing=north,form=latticeback,carpeted=false,carpet_color=light_gray\": { \"model\": \"aestheticseating:block/light_gray/simple_stool_latticeback_WOOD_NAME_VALUE\" },\n    \"facing=south,form=latticeback,carpeted=false,carpet_color=light_gray\": { \"model\": \"aestheticseating:block/light_gray/simple_stool_latticeback_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,form=latticeback,carpeted=false,carpet_color=light_gray\": { \"model\": \"aestheticseating:block/light_gray/simple_stool_latticeback_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,form=latticeback,carpeted=false,carpet_color=light_gray\": { \"model\": \"aestheticseating:block/light_gray/simple_stool_latticeback_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,form=latticeback,carpeted=true,carpet_color=light_gray\": { \"model\": \"aestheticseating:block/light_gray/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,form=latticeback,carpeted=true,carpet_color=light_gray\": { \"model\": \"aestheticseating:block/light_gray/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,form=latticeback,carpeted=true,carpet_color=light_gray\": { \"model\": \"aestheticseating:block/light_gray/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,form=latticeback,carpeted=true,carpet_color=light_gray\": { \"model\": \"aestheticseating:block/light_gray/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n    \"facing=north,form=desk,carpeted=false,carpet_color=light_gray\": { \"model\": \"aestheticseating:block/light_gray/simple_stool_desk_WOOD_NAME_VALUE\" },\n    \"facing=south,form=desk,carpeted=false,carpet_color=light_gray\": { \"model\": \"aestheticseating:block/light_gray/simple_stool_desk_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,form=desk,carpeted=false,carpet_color=light_gray\": { \"model\": \"aestheticseating:block/light_gray/simple_stool_desk_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,form=desk,carpeted=false,carpet_color=light_gray\": { \"model\": \"aestheticseating:block/light_gray/simple_stool_desk_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,form=desk,carpeted=true,carpet_color=light_gray\": { \"model\": \"aestheticseating:block/light_gray/simple_stool_desk_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,form=desk,carpeted=true,carpet_color=light_gray\": { \"model\": \"aestheticseating:block/light_gray/simple_stool_desk_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,form=desk,carpeted=true,carpet_color=light_gray\": { \"model\": \"aestheticseating:block/light_gray/simple_stool_desk_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,form=desk,carpeted=true,carpet_color=light_gray\": { \"model\": \"aestheticseating:block/light_gray/simple_stool_desk_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n\n    \"facing=north,form=normal,carpeted=false,carpet_color=white\": { \"model\": \"aestheticseating:block/white/simple_stool_normal_WOOD_NAME_VALUE\" },\n    \"facing=south,form=normal,carpeted=false,carpet_color=white\": { \"model\": \"aestheticseating:block/white/simple_stool_normal_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,form=normal,carpeted=false,carpet_color=white\": { \"model\": \"aestheticseating:block/white/simple_stool_normal_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,form=normal,carpeted=false,carpet_color=white\": { \"model\": \"aestheticseating:block/white/simple_stool_normal_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,form=normal,carpeted=true,carpet_color=white\": { \"model\": \"aestheticseating:block/white/simple_stool_normal_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,form=normal,carpeted=true,carpet_color=white\": { \"model\": \"aestheticseating:block/white/simple_stool_normal_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,form=normal,carpeted=true,carpet_color=white\": { \"model\": \"aestheticseating:block/white/simple_stool_normal_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,form=normal,carpeted=true,carpet_color=white\": { \"model\": \"aestheticseating:block/white/simple_stool_normal_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n    \"facing=north,form=latticeback,carpeted=false,carpet_color=white\": { \"model\": \"aestheticseating:block/white/simple_stool_latticeback_WOOD_NAME_VALUE\" },\n    \"facing=south,form=latticeback,carpeted=false,carpet_color=white\": { \"model\": \"aestheticseating:block/white/simple_stool_latticeback_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,form=latticeback,carpeted=false,carpet_color=white\": { \"model\": \"aestheticseating:block/white/simple_stool_latticeback_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,form=latticeback,carpeted=false,carpet_color=white\": { \"model\": \"aestheticseating:block/white/simple_stool_latticeback_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,form=latticeback,carpeted=true,carpet_color=white\": { \"model\": \"aestheticseating:block/white/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,form=latticeback,carpeted=true,carpet_color=white\": { \"model\": \"aestheticseating:block/white/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,form=latticeback,carpeted=true,carpet_color=white\": { \"model\": \"aestheticseating:block/white/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,form=latticeback,carpeted=true,carpet_color=white\": { \"model\": \"aestheticseating:block/white/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n    \"facing=north,form=desk,carpeted=false,carpet_color=white\": { \"model\": \"aestheticseating:block/white/simple_stool_desk_WOOD_NAME_VALUE\" },\n    \"facing=south,form=desk,carpeted=false,carpet_color=white\": { \"model\": \"aestheticseating:block/white/simple_stool_desk_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,form=desk,carpeted=false,carpet_color=white\": { \"model\": \"aestheticseating:block/white/simple_stool_desk_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,form=desk,carpeted=false,carpet_color=white\": { \"model\": \"aestheticseating:block/white/simple_stool_desk_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,form=desk,carpeted=true,carpet_color=white\": { \"model\": \"aestheticseating:block/white/simple_stool_desk_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,form=desk,carpeted=true,carpet_color=white\": { \"model\": \"aestheticseating:block/white/simple_stool_desk_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,form=desk,carpeted=true,carpet_color=white\": { \"model\": \"aestheticseating:block/white/simple_stool_desk_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,form=desk,carpeted=true,carpet_color=white\": { \"model\": \"aestheticseating:block/white/simple_stool_desk_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n\n    \"facing=north,form=normal,carpeted=false,carpet_color=red\": { \"model\": \"aestheticseating:block/red/simple_stool_normal_WOOD_NAME_VALUE\" },\n    \"facing=south,form=normal,carpeted=false,carpet_color=red\": { \"model\": \"aestheticseating:block/red/simple_stool_normal_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,form=normal,carpeted=false,carpet_color=red\": { \"model\": \"aestheticseating:block/red/simple_stool_normal_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,form=normal,carpeted=false,carpet_color=red\": { \"model\": \"aestheticseating:block/red/simple_stool_normal_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,form=normal,carpeted=true,carpet_color=red\": { \"model\": \"aestheticseating:block/red/simple_stool_normal_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,form=normal,carpeted=true,carpet_color=red\": { \"model\": \"aestheticseating:block/red/simple_stool_normal_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,form=normal,carpeted=true,carpet_color=red\": { \"model\": \"aestheticseating:block/red/simple_stool_normal_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,form=normal,carpeted=true,carpet_color=red\": { \"model\": \"aestheticseating:block/red/simple_stool_normal_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n    \"facing=north,form=latticeback,carpeted=false,carpet_color=red\": { \"model\": \"aestheticseating:block/red/simple_stool_latticeback_WOOD_NAME_VALUE\" },\n    \"facing=south,form=latticeback,carpeted=false,carpet_color=red\": { \"model\": \"aestheticseating:block/red/simple_stool_latticeback_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,form=latticeback,carpeted=false,carpet_color=red\": { \"model\": \"aestheticseating:block/red/simple_stool_latticeback_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,form=latticeback,carpeted=false,carpet_color=red\": { \"model\": \"aestheticseating:block/red/simple_stool_latticeback_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,form=latticeback,carpeted=true,carpet_color=red\": { \"model\": \"aestheticseating:block/red/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,form=latticeback,carpeted=true,carpet_color=red\": { \"model\": \"aestheticseating:block/red/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,form=latticeback,carpeted=true,carpet_color=red\": { \"model\": \"aestheticseating:block/red/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,form=latticeback,carpeted=true,carpet_color=red\": { \"model\": \"aestheticseating:block/red/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n    \"facing=north,form=desk,carpeted=false,carpet_color=red\": { \"model\": \"aestheticseating:block/red/simple_stool_desk_WOOD_NAME_VALUE\" },\n    \"facing=south,form=desk,carpeted=false,carpet_color=red\": { \"model\": \"aestheticseating:block/red/simple_stool_desk_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,form=desk,carpeted=false,carpet_color=red\": { \"model\": \"aestheticseating:block/red/simple_stool_desk_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,form=desk,carpeted=false,carpet_color=red\": { \"model\": \"aestheticseating:block/red/simple_stool_desk_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,form=desk,carpeted=true,carpet_color=red\": { \"model\": \"aestheticseating:block/red/simple_stool_desk_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,form=desk,carpeted=true,carpet_color=red\": { \"model\": \"aestheticseating:block/red/simple_stool_desk_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,form=desk,carpeted=true,carpet_color=red\": { \"model\": \"aestheticseating:block/red/simple_stool_desk_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,form=desk,carpeted=true,carpet_color=red\": { \"model\": \"aestheticseating:block/red/simple_stool_desk_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n\n    \"facing=north,form=normal,carpeted=false,carpet_color=orange\": { \"model\": \"aestheticseating:block/orange/simple_stool_normal_WOOD_NAME_VALUE\" },\n    \"facing=south,form=normal,carpeted=false,carpet_color=orange\": { \"model\": \"aestheticseating:block/orange/simple_stool_normal_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,form=normal,carpeted=false,carpet_color=orange\": { \"model\": \"aestheticseating:block/orange/simple_stool_normal_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,form=normal,carpeted=false,carpet_color=orange\": { \"model\": \"aestheticseating:block/orange/simple_stool_normal_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,form=normal,carpeted=true,carpet_color=orange\": { \"model\": \"aestheticseating:block/orange/simple_stool_normal_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,form=normal,carpeted=true,carpet_color=orange\": { \"model\": \"aestheticseating:block/orange/simple_stool_normal_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,form=normal,carpeted=true,carpet_color=orange\": { \"model\": \"aestheticseating:block/orange/simple_stool_normal_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,form=normal,carpeted=true,carpet_color=orange\": { \"model\": \"aestheticseating:block/orange/simple_stool_normal_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n    \"facing=north,form=latticeback,carpeted=false,carpet_color=orange\": { \"model\": \"aestheticseating:block/orange/simple_stool_latticeback_WOOD_NAME_VALUE\" },\n    \"facing=south,form=latticeback,carpeted=false,carpet_color=orange\": { \"model\": \"aestheticseating:block/orange/simple_stool_latticeback_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,form=latticeback,carpeted=false,carpet_color=orange\": { \"model\": \"aestheticseating:block/orange/simple_stool_latticeback_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,form=latticeback,carpeted=false,carpet_color=orange\": { \"model\": \"aestheticseating:block/orange/simple_stool_latticeback_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,form=latticeback,carpeted=true,carpet_color=orange\": { \"model\": \"aestheticseating:block/orange/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,form=latticeback,carpeted=true,carpet_color=orange\": { \"model\": \"aestheticseating:block/orange/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,form=latticeback,carpeted=true,carpet_color=orange\": { \"model\": \"aestheticseating:block/orange/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,form=latticeback,carpeted=true,carpet_color=orange\": { \"model\": \"aestheticseating:block/orange/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n    \"facing=north,form=desk,carpeted=false,carpet_color=orange\": { \"model\": \"aestheticseating:block/orange/simple_stool_desk_WOOD_NAME_VALUE\" },\n    \"facing=south,form=desk,carpeted=false,carpet_color=orange\": { \"model\": \"aestheticseating:block/orange/simple_stool_desk_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,form=desk,carpeted=false,carpet_color=orange\": { \"model\": \"aestheticseating:block/orange/simple_stool_desk_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,form=desk,carpeted=false,carpet_color=orange\": { \"model\": \"aestheticseating:block/orange/simple_stool_desk_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,form=desk,carpeted=true,carpet_color=orange\": { \"model\": \"aestheticseating:block/orange/simple_stool_desk_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,form=desk,carpeted=true,carpet_color=orange\": { \"model\": \"aestheticseating:block/orange/simple_stool_desk_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,form=desk,carpeted=true,carpet_color=orange\": { \"model\": \"aestheticseating:block/orange/simple_stool_desk_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,form=desk,carpeted=true,carpet_color=orange\": { \"model\": \"aestheticseating:block/orange/simple_stool_desk_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n\n    \"facing=north,form=normal,carpeted=false,carpet_color=yellow\": { \"model\": \"aestheticseating:block/yellow/simple_stool_normal_WOOD_NAME_VALUE\" },\n    \"facing=south,form=normal,carpeted=false,carpet_color=yellow\": { \"model\": \"aestheticseating:block/yellow/simple_stool_normal_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,form=normal,carpeted=false,carpet_color=yellow\": { \"model\": \"aestheticseating:block/yellow/simple_stool_normal_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,form=normal,carpeted=false,carpet_color=yellow\": { \"model\": \"aestheticseating:block/yellow/simple_stool_normal_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,form=normal,carpeted=true,carpet_color=yellow\": { \"model\": \"aestheticseating:block/yellow/simple_stool_normal_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,form=normal,carpeted=true,carpet_color=yellow\": { \"model\": \"aestheticseating:block/yellow/simple_stool_normal_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,form=normal,carpeted=true,carpet_color=yellow\": { \"model\": \"aestheticseating:block/yellow/simple_stool_normal_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,form=normal,carpeted=true,carpet_color=yellow\": { \"model\": \"aestheticseating:block/yellow/simple_stool_normal_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n    \"facing=north,form=latticeback,carpeted=false,carpet_color=yellow\": { \"model\": \"aestheticseating:block/yellow/simple_stool_latticeback_WOOD_NAME_VALUE\" },\n    \"facing=south,form=latticeback,carpeted=false,carpet_color=yellow\": { \"model\": \"aestheticseating:block/yellow/simple_stool_latticeback_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,form=latticeback,carpeted=false,carpet_color=yellow\": { \"model\": \"aestheticseating:block/yellow/simple_stool_latticeback_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,form=latticeback,carpeted=false,carpet_color=yellow\": { \"model\": \"aestheticseating:block/yellow/simple_stool_latticeback_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,form=latticeback,carpeted=true,carpet_color=yellow\": { \"model\": \"aestheticseating:block/yellow/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,form=latticeback,carpeted=true,carpet_color=yellow\": { \"model\": \"aestheticseating:block/yellow/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,form=latticeback,carpeted=true,carpet_color=yellow\": { \"model\": \"aestheticseating:block/yellow/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,form=latticeback,carpeted=true,carpet_color=yellow\": { \"model\": \"aestheticseating:block/yellow/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n    \"facing=north,form=desk,carpeted=false,carpet_color=yellow\": { \"model\": \"aestheticseating:block/yellow/simple_stool_desk_WOOD_NAME_VALUE\" },\n    \"facing=south,form=desk,carpeted=false,carpet_color=yellow\": { \"model\": \"aestheticseating:block/yellow/simple_stool_desk_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,form=desk,carpeted=false,carpet_color=yellow\": { \"model\": \"aestheticseating:block/yellow/simple_stool_desk_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,form=desk,carpeted=false,carpet_color=yellow\": { \"model\": \"aestheticseating:block/yellow/simple_stool_desk_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,form=desk,carpeted=true,carpet_color=yellow\": { \"model\": \"aestheticseating:block/yellow/simple_stool_desk_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,form=desk,carpeted=true,carpet_color=yellow\": { \"model\": \"aestheticseating:block/yellow/simple_stool_desk_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,form=desk,carpeted=true,carpet_color=yellow\": { \"model\": \"aestheticseating:block/yellow/simple_stool_desk_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,form=desk,carpeted=true,carpet_color=yellow\": { \"model\": \"aestheticseating:block/yellow/simple_stool_desk_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n\n    \"facing=north,form=normal,carpeted=false,carpet_color=purple\": { \"model\": \"aestheticseating:block/purple/simple_stool_normal_WOOD_NAME_VALUE\" },\n    \"facing=south,form=normal,carpeted=false,carpet_color=purple\": { \"model\": \"aestheticseating:block/purple/simple_stool_normal_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,form=normal,carpeted=false,carpet_color=purple\": { \"model\": \"aestheticseating:block/purple/simple_stool_normal_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,form=normal,carpeted=false,carpet_color=purple\": { \"model\": \"aestheticseating:block/purple/simple_stool_normal_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,form=normal,carpeted=true,carpet_color=purple\": { \"model\": \"aestheticseating:block/purple/simple_stool_normal_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,form=normal,carpeted=true,carpet_color=purple\": { \"model\": \"aestheticseating:block/purple/simple_stool_normal_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,form=normal,carpeted=true,carpet_color=purple\": { \"model\": \"aestheticseating:block/purple/simple_stool_normal_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,form=normal,carpeted=true,carpet_color=purple\": { \"model\": \"aestheticseating:block/purple/simple_stool_normal_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n    \"facing=north,form=latticeback,carpeted=false,carpet_color=purple\": { \"model\": \"aestheticseating:block/purple/simple_stool_latticeback_WOOD_NAME_VALUE\" },\n    \"facing=south,form=latticeback,carpeted=false,carpet_color=purple\": { \"model\": \"aestheticseating:block/purple/simple_stool_latticeback_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,form=latticeback,carpeted=false,carpet_color=purple\": { \"model\": \"aestheticseating:block/purple/simple_stool_latticeback_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,form=latticeback,carpeted=false,carpet_color=purple\": { \"model\": \"aestheticseating:block/purple/simple_stool_latticeback_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,form=latticeback,carpeted=true,carpet_color=purple\": { \"model\": \"aestheticseating:block/purple/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,form=latticeback,carpeted=true,carpet_color=purple\": { \"model\": \"aestheticseating:block/purple/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,form=latticeback,carpeted=true,carpet_color=purple\": { \"model\": \"aestheticseating:block/purple/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,form=latticeback,carpeted=true,carpet_color=purple\": { \"model\": \"aestheticseating:block/purple/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n    \"facing=north,form=desk,carpeted=false,carpet_color=purple\": { \"model\": \"aestheticseating:block/purple/simple_stool_desk_WOOD_NAME_VALUE\" },\n    \"facing=south,form=desk,carpeted=false,carpet_color=purple\": { \"model\": \"aestheticseating:block/purple/simple_stool_desk_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,form=desk,carpeted=false,carpet_color=purple\": { \"model\": \"aestheticseating:block/purple/simple_stool_desk_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,form=desk,carpeted=false,carpet_color=purple\": { \"model\": \"aestheticseating:block/purple/simple_stool_desk_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,form=desk,carpeted=true,carpet_color=purple\": { \"model\": \"aestheticseating:block/purple/simple_stool_desk_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,form=desk,carpeted=true,carpet_color=purple\": { \"model\": \"aestheticseating:block/purple/simple_stool_desk_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,form=desk,carpeted=true,carpet_color=purple\": { \"model\": \"aestheticseating:block/purple/simple_stool_desk_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,form=desk,carpeted=true,carpet_color=purple\": { \"model\": \"aestheticseating:block/purple/simple_stool_desk_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n\n    \"facing=north,form=normal,carpeted=false,carpet_color=magenta\": { \"model\": \"aestheticseating:block/magenta/simple_stool_normal_WOOD_NAME_VALUE\" },\n    \"facing=south,form=normal,carpeted=false,carpet_color=magenta\": { \"model\": \"aestheticseating:block/magenta/simple_stool_normal_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,form=normal,carpeted=false,carpet_color=magenta\": { \"model\": \"aestheticseating:block/magenta/simple_stool_normal_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,form=normal,carpeted=false,carpet_color=magenta\": { \"model\": \"aestheticseating:block/magenta/simple_stool_normal_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,form=normal,carpeted=true,carpet_color=magenta\": { \"model\": \"aestheticseating:block/magenta/simple_stool_normal_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,form=normal,carpeted=true,carpet_color=magenta\": { \"model\": \"aestheticseating:block/magenta/simple_stool_normal_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,form=normal,carpeted=true,carpet_color=magenta\": { \"model\": \"aestheticseating:block/magenta/simple_stool_normal_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,form=normal,carpeted=true,carpet_color=magenta\": { \"model\": \"aestheticseating:block/magenta/simple_stool_normal_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n    \"facing=north,form=latticeback,carpeted=false,carpet_color=magenta\": { \"model\": \"aestheticseating:block/magenta/simple_stool_latticeback_WOOD_NAME_VALUE\" },\n    \"facing=south,form=latticeback,carpeted=false,carpet_color=magenta\": { \"model\": \"aestheticseating:block/magenta/simple_stool_latticeback_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,form=latticeback,carpeted=false,carpet_color=magenta\": { \"model\": \"aestheticseating:block/magenta/simple_stool_latticeback_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,form=latticeback,carpeted=false,carpet_color=magenta\": { \"model\": \"aestheticseating:block/magenta/simple_stool_latticeback_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,form=latticeback,carpeted=true,carpet_color=magenta\": { \"model\": \"aestheticseating:block/magenta/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,form=latticeback,carpeted=true,carpet_color=magenta\": { \"model\": \"aestheticseating:block/magenta/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,form=latticeback,carpeted=true,carpet_color=magenta\": { \"model\": \"aestheticseating:block/magenta/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,form=latticeback,carpeted=true,carpet_color=magenta\": { \"model\": \"aestheticseating:block/magenta/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n    \"facing=north,form=desk,carpeted=false,carpet_color=magenta\": { \"model\": \"aestheticseating:block/magenta/simple_stool_desk_WOOD_NAME_VALUE\" },\n    \"facing=south,form=desk,carpeted=false,carpet_color=magenta\": { \"model\": \"aestheticseating:block/magenta/simple_stool_desk_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,form=desk,carpeted=false,carpet_color=magenta\": { \"model\": \"aestheticseating:block/magenta/simple_stool_desk_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,form=desk,carpeted=false,carpet_color=magenta\": { \"model\": \"aestheticseating:block/magenta/simple_stool_desk_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,form=desk,carpeted=true,carpet_color=magenta\": { \"model\": \"aestheticseating:block/magenta/simple_stool_desk_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,form=desk,carpeted=true,carpet_color=magenta\": { \"model\": \"aestheticseating:block/magenta/simple_stool_desk_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,form=desk,carpeted=true,carpet_color=magenta\": { \"model\": \"aestheticseating:block/magenta/simple_stool_desk_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,form=desk,carpeted=true,carpet_color=magenta\": { \"model\": \"aestheticseating:block/magenta/simple_stool_desk_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n\n    \"facing=north,form=normal,carpeted=false,carpet_color=pink\": { \"model\": \"aestheticseating:block/pink/simple_stool_normal_WOOD_NAME_VALUE\" },\n    \"facing=south,form=normal,carpeted=false,carpet_color=pink\": { \"model\": \"aestheticseating:block/pink/simple_stool_normal_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,form=normal,carpeted=false,carpet_color=pink\": { \"model\": \"aestheticseating:block/pink/simple_stool_normal_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,form=normal,carpeted=false,carpet_color=pink\": { \"model\": \"aestheticseating:block/pink/simple_stool_normal_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,form=normal,carpeted=true,carpet_color=pink\": { \"model\": \"aestheticseating:block/pink/simple_stool_normal_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,form=normal,carpeted=true,carpet_color=pink\": { \"model\": \"aestheticseating:block/pink/simple_stool_normal_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,form=normal,carpeted=true,carpet_color=pink\": { \"model\": \"aestheticseating:block/pink/simple_stool_normal_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,form=normal,carpeted=true,carpet_color=pink\": { \"model\": \"aestheticseating:block/pink/simple_stool_normal_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n    \"facing=north,form=latticeback,carpeted=false,carpet_color=pink\": { \"model\": \"aestheticseating:block/pink/simple_stool_latticeback_WOOD_NAME_VALUE\" },\n    \"facing=south,form=latticeback,carpeted=false,carpet_color=pink\": { \"model\": \"aestheticseating:block/pink/simple_stool_latticeback_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,form=latticeback,carpeted=false,carpet_color=pink\": { \"model\": \"aestheticseating:block/pink/simple_stool_latticeback_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,form=latticeback,carpeted=false,carpet_color=pink\": { \"model\": \"aestheticseating:block/pink/simple_stool_latticeback_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,form=latticeback,carpeted=true,carpet_color=pink\": { \"model\": \"aestheticseating:block/pink/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,form=latticeback,carpeted=true,carpet_color=pink\": { \"model\": \"aestheticseating:block/pink/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,form=latticeback,carpeted=true,carpet_color=pink\": { \"model\": \"aestheticseating:block/pink/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,form=latticeback,carpeted=true,carpet_color=pink\": { \"model\": \"aestheticseating:block/pink/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n    \"facing=north,form=desk,carpeted=false,carpet_color=pink\": { \"model\": \"aestheticseating:block/pink/simple_stool_desk_WOOD_NAME_VALUE\" },\n    \"facing=south,form=desk,carpeted=false,carpet_color=pink\": { \"model\": \"aestheticseating:block/pink/simple_stool_desk_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,form=desk,carpeted=false,carpet_color=pink\": { \"model\": \"aestheticseating:block/pink/simple_stool_desk_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,form=desk,carpeted=false,carpet_color=pink\": { \"model\": \"aestheticseating:block/pink/simple_stool_desk_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,form=desk,carpeted=true,carpet_color=pink\": { \"model\": \"aestheticseating:block/pink/simple_stool_desk_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,form=desk,carpeted=true,carpet_color=pink\": { \"model\": \"aestheticseating:block/pink/simple_stool_desk_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,form=desk,carpeted=true,carpet_color=pink\": { \"model\": \"aestheticseating:block/pink/simple_stool_desk_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,form=desk,carpeted=true,carpet_color=pink\": { \"model\": \"aestheticseating:block/pink/simple_stool_desk_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n\n    \"facing=north,form=normal,carpeted=false,carpet_color=blue\": { \"model\": \"aestheticseating:block/blue/simple_stool_normal_WOOD_NAME_VALUE\" },\n    \"facing=south,form=normal,carpeted=false,carpet_color=blue\": { \"model\": \"aestheticseating:block/blue/simple_stool_normal_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,form=normal,carpeted=false,carpet_color=blue\": { \"model\": \"aestheticseating:block/blue/simple_stool_normal_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,form=normal,carpeted=false,carpet_color=blue\": { \"model\": \"aestheticseating:block/blue/simple_stool_normal_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,form=normal,carpeted=true,carpet_color=blue\": { \"model\": \"aestheticseating:block/blue/simple_stool_normal_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,form=normal,carpeted=true,carpet_color=blue\": { \"model\": \"aestheticseating:block/blue/simple_stool_normal_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,form=normal,carpeted=true,carpet_color=blue\": { \"model\": \"aestheticseating:block/blue/simple_stool_normal_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,form=normal,carpeted=true,carpet_color=blue\": { \"model\": \"aestheticseating:block/blue/simple_stool_normal_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n    \"facing=north,form=latticeback,carpeted=false,carpet_color=blue\": { \"model\": \"aestheticseating:block/blue/simple_stool_latticeback_WOOD_NAME_VALUE\" },\n    \"facing=south,form=latticeback,carpeted=false,carpet_color=blue\": { \"model\": \"aestheticseating:block/blue/simple_stool_latticeback_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,form=latticeback,carpeted=false,carpet_color=blue\": { \"model\": \"aestheticseating:block/blue/simple_stool_latticeback_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,form=latticeback,carpeted=false,carpet_color=blue\": { \"model\": \"aestheticseating:block/blue/simple_stool_latticeback_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,form=latticeback,carpeted=true,carpet_color=blue\": { \"model\": \"aestheticseating:block/blue/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,form=latticeback,carpeted=true,carpet_color=blue\": { \"model\": \"aestheticseating:block/blue/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,form=latticeback,carpeted=true,carpet_color=blue\": { \"model\": \"aestheticseating:block/blue/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,form=latticeback,carpeted=true,carpet_color=blue\": { \"model\": \"aestheticseating:block/blue/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n    \"facing=north,form=desk,carpeted=false,carpet_color=blue\": { \"model\": \"aestheticseating:block/blue/simple_stool_desk_WOOD_NAME_VALUE\" },\n    \"facing=south,form=desk,carpeted=false,carpet_color=blue\": { \"model\": \"aestheticseating:block/blue/simple_stool_desk_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,form=desk,carpeted=false,carpet_color=blue\": { \"model\": \"aestheticseating:block/blue/simple_stool_desk_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,form=desk,carpeted=false,carpet_color=blue\": { \"model\": \"aestheticseating:block/blue/simple_stool_desk_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,form=desk,carpeted=true,carpet_color=blue\": { \"model\": \"aestheticseating:block/blue/simple_stool_desk_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,form=desk,carpeted=true,carpet_color=blue\": { \"model\": \"aestheticseating:block/blue/simple_stool_desk_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,form=desk,carpeted=true,carpet_color=blue\": { \"model\": \"aestheticseating:block/blue/simple_stool_desk_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,form=desk,carpeted=true,carpet_color=blue\": { \"model\": \"aestheticseating:block/blue/simple_stool_desk_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n\n    \"facing=north,form=normal,carpeted=false,carpet_color=cyan\": { \"model\": \"aestheticseating:block/cyan/simple_stool_normal_WOOD_NAME_VALUE\" },\n    \"facing=south,form=normal,carpeted=false,carpet_color=cyan\": { \"model\": \"aestheticseating:block/cyan/simple_stool_normal_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,form=normal,carpeted=false,carpet_color=cyan\": { \"model\": \"aestheticseating:block/cyan/simple_stool_normal_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,form=normal,carpeted=false,carpet_color=cyan\": { \"model\": \"aestheticseating:block/cyan/simple_stool_normal_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,form=normal,carpeted=true,carpet_color=cyan\": { \"model\": \"aestheticseating:block/cyan/simple_stool_normal_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,form=normal,carpeted=true,carpet_color=cyan\": { \"model\": \"aestheticseating:block/cyan/simple_stool_normal_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,form=normal,carpeted=true,carpet_color=cyan\": { \"model\": \"aestheticseating:block/cyan/simple_stool_normal_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,form=normal,carpeted=true,carpet_color=cyan\": { \"model\": \"aestheticseating:block/cyan/simple_stool_normal_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n    \"facing=north,form=latticeback,carpeted=false,carpet_color=cyan\": { \"model\": \"aestheticseating:block/cyan/simple_stool_latticeback_WOOD_NAME_VALUE\" },\n    \"facing=south,form=latticeback,carpeted=false,carpet_color=cyan\": { \"model\": \"aestheticseating:block/cyan/simple_stool_latticeback_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,form=latticeback,carpeted=false,carpet_color=cyan\": { \"model\": \"aestheticseating:block/cyan/simple_stool_latticeback_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,form=latticeback,carpeted=false,carpet_color=cyan\": { \"model\": \"aestheticseating:block/cyan/simple_stool_latticeback_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,form=latticeback,carpeted=true,carpet_color=cyan\": { \"model\": \"aestheticseating:block/cyan/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,form=latticeback,carpeted=true,carpet_color=cyan\": { \"model\": \"aestheticseating:block/cyan/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,form=latticeback,carpeted=true,carpet_color=cyan\": { \"model\": \"aestheticseating:block/cyan/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,form=latticeback,carpeted=true,carpet_color=cyan\": { \"model\": \"aestheticseating:block/cyan/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n    \"facing=north,form=desk,carpeted=false,carpet_color=cyan\": { \"model\": \"aestheticseating:block/cyan/simple_stool_desk_WOOD_NAME_VALUE\" },\n    \"facing=south,form=desk,carpeted=false,carpet_color=cyan\": { \"model\": \"aestheticseating:block/cyan/simple_stool_desk_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,form=desk,carpeted=false,carpet_color=cyan\": { \"model\": \"aestheticseating:block/cyan/simple_stool_desk_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,form=desk,carpeted=false,carpet_color=cyan\": { \"model\": \"aestheticseating:block/cyan/simple_stool_desk_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,form=desk,carpeted=true,carpet_color=cyan\": { \"model\": \"aestheticseating:block/cyan/simple_stool_desk_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,form=desk,carpeted=true,carpet_color=cyan\": { \"model\": \"aestheticseating:block/cyan/simple_stool_desk_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,form=desk,carpeted=true,carpet_color=cyan\": { \"model\": \"aestheticseating:block/cyan/simple_stool_desk_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,form=desk,carpeted=true,carpet_color=cyan\": { \"model\": \"aestheticseating:block/cyan/simple_stool_desk_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n\n    \"facing=north,form=normal,carpeted=false,carpet_color=light_blue\": { \"model\": \"aestheticseating:block/light_blue/simple_stool_normal_WOOD_NAME_VALUE\" },\n    \"facing=south,form=normal,carpeted=false,carpet_color=light_blue\": { \"model\": \"aestheticseating:block/light_blue/simple_stool_normal_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,form=normal,carpeted=false,carpet_color=light_blue\": { \"model\": \"aestheticseating:block/light_blue/simple_stool_normal_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,form=normal,carpeted=false,carpet_color=light_blue\": { \"model\": \"aestheticseating:block/light_blue/simple_stool_normal_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,form=normal,carpeted=true,carpet_color=light_blue\": { \"model\": \"aestheticseating:block/light_blue/simple_stool_normal_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,form=normal,carpeted=true,carpet_color=light_blue\": { \"model\": \"aestheticseating:block/light_blue/simple_stool_normal_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,form=normal,carpeted=true,carpet_color=light_blue\": { \"model\": \"aestheticseating:block/light_blue/simple_stool_normal_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,form=normal,carpeted=true,carpet_color=light_blue\": { \"model\": \"aestheticseating:block/light_blue/simple_stool_normal_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n    \"facing=north,form=latticeback,carpeted=false,carpet_color=light_blue\": { \"model\": \"aestheticseating:block/light_blue/simple_stool_latticeback_WOOD_NAME_VALUE\" },\n    \"facing=south,form=latticeback,carpeted=false,carpet_color=light_blue\": { \"model\": \"aestheticseating:block/light_blue/simple_stool_latticeback_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,form=latticeback,carpeted=false,carpet_color=light_blue\": { \"model\": \"aestheticseating:block/light_blue/simple_stool_latticeback_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,form=latticeback,carpeted=false,carpet_color=light_blue\": { \"model\": \"aestheticseating:block/light_blue/simple_stool_latticeback_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,form=latticeback,carpeted=true,carpet_color=light_blue\": { \"model\": \"aestheticseating:block/light_blue/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,form=latticeback,carpeted=true,carpet_color=light_blue\": { \"model\": \"aestheticseating:block/light_blue/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,form=latticeback,carpeted=true,carpet_color=light_blue\": { \"model\": \"aestheticseating:block/light_blue/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,form=latticeback,carpeted=true,carpet_color=light_blue\": { \"model\": \"aestheticseating:block/light_blue/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n    \"facing=north,form=desk,carpeted=false,carpet_color=light_blue\": { \"model\": \"aestheticseating:block/light_blue/simple_stool_desk_WOOD_NAME_VALUE\" },\n    \"facing=south,form=desk,carpeted=false,carpet_color=light_blue\": { \"model\": \"aestheticseating:block/light_blue/simple_stool_desk_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,form=desk,carpeted=false,carpet_color=light_blue\": { \"model\": \"aestheticseating:block/light_blue/simple_stool_desk_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,form=desk,carpeted=false,carpet_color=light_blue\": { \"model\": \"aestheticseating:block/light_blue/simple_stool_desk_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,form=desk,carpeted=true,carpet_color=light_blue\": { \"model\": \"aestheticseating:block/light_blue/simple_stool_desk_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,form=desk,carpeted=true,carpet_color=light_blue\": { \"model\": \"aestheticseating:block/light_blue/simple_stool_desk_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,form=desk,carpeted=true,carpet_color=light_blue\": { \"model\": \"aestheticseating:block/light_blue/simple_stool_desk_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,form=desk,carpeted=true,carpet_color=light_blue\": { \"model\": \"aestheticseating:block/light_blue/simple_stool_desk_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n\n    \"facing=north,form=normal,carpeted=false,carpet_color=green\": { \"model\": \"aestheticseating:block/green/simple_stool_normal_WOOD_NAME_VALUE\" },\n    \"facing=south,form=normal,carpeted=false,carpet_color=green\": { \"model\": \"aestheticseating:block/green/simple_stool_normal_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,form=normal,carpeted=false,carpet_color=green\": { \"model\": \"aestheticseating:block/green/simple_stool_normal_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,form=normal,carpeted=false,carpet_color=green\": { \"model\": \"aestheticseating:block/green/simple_stool_normal_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,form=normal,carpeted=true,carpet_color=green\": { \"model\": \"aestheticseating:block/green/simple_stool_normal_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,form=normal,carpeted=true,carpet_color=green\": { \"model\": \"aestheticseating:block/green/simple_stool_normal_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,form=normal,carpeted=true,carpet_color=green\": { \"model\": \"aestheticseating:block/green/simple_stool_normal_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,form=normal,carpeted=true,carpet_color=green\": { \"model\": \"aestheticseating:block/green/simple_stool_normal_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n    \"facing=north,form=latticeback,carpeted=false,carpet_color=green\": { \"model\": \"aestheticseating:block/green/simple_stool_latticeback_WOOD_NAME_VALUE\" },\n    \"facing=south,form=latticeback,carpeted=false,carpet_color=green\": { \"model\": \"aestheticseating:block/green/simple_stool_latticeback_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,form=latticeback,carpeted=false,carpet_color=green\": { \"model\": \"aestheticseating:block/green/simple_stool_latticeback_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,form=latticeback,carpeted=false,carpet_color=green\": { \"model\": \"aestheticseating:block/green/simple_stool_latticeback_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,form=latticeback,carpeted=true,carpet_color=green\": { \"model\": \"aestheticseating:block/green/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,form=latticeback,carpeted=true,carpet_color=green\": { \"model\": \"aestheticseating:block/green/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,form=latticeback,carpeted=true,carpet_color=green\": { \"model\": \"aestheticseating:block/green/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,form=latticeback,carpeted=true,carpet_color=green\": { \"model\": \"aestheticseating:block/green/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n    \"facing=north,form=desk,carpeted=false,carpet_color=green\": { \"model\": \"aestheticseating:block/green/simple_stool_desk_WOOD_NAME_VALUE\" },\n    \"facing=south,form=desk,carpeted=false,carpet_color=green\": { \"model\": \"aestheticseating:block/green/simple_stool_desk_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,form=desk,carpeted=false,carpet_color=green\": { \"model\": \"aestheticseating:block/green/simple_stool_desk_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,form=desk,carpeted=false,carpet_color=green\": { \"model\": \"aestheticseating:block/green/simple_stool_desk_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,form=desk,carpeted=true,carpet_color=green\": { \"model\": \"aestheticseating:block/green/simple_stool_desk_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,form=desk,carpeted=true,carpet_color=green\": { \"model\": \"aestheticseating:block/green/simple_stool_desk_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,form=desk,carpeted=true,carpet_color=green\": { \"model\": \"aestheticseating:block/green/simple_stool_desk_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,form=desk,carpeted=true,carpet_color=green\": { \"model\": \"aestheticseating:block/green/simple_stool_desk_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n\n    \"facing=north,form=normal,carpeted=false,carpet_color=lime\": { \"model\": \"aestheticseating:block/lime/simple_stool_normal_WOOD_NAME_VALUE\" },\n    \"facing=south,form=normal,carpeted=false,carpet_color=lime\": { \"model\": \"aestheticseating:block/lime/simple_stool_normal_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,form=normal,carpeted=false,carpet_color=lime\": { \"model\": \"aestheticseating:block/lime/simple_stool_normal_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,form=normal,carpeted=false,carpet_color=lime\": { \"model\": \"aestheticseating:block/lime/simple_stool_normal_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,form=normal,carpeted=true,carpet_color=lime\": { \"model\": \"aestheticseating:block/lime/simple_stool_normal_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,form=normal,carpeted=true,carpet_color=lime\": { \"model\": \"aestheticseating:block/lime/simple_stool_normal_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,form=normal,carpeted=true,carpet_color=lime\": { \"model\": \"aestheticseating:block/lime/simple_stool_normal_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,form=normal,carpeted=true,carpet_color=lime\": { \"model\": \"aestheticseating:block/lime/simple_stool_normal_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n    \"facing=north,form=latticeback,carpeted=false,carpet_color=lime\": { \"model\": \"aestheticseating:block/lime/simple_stool_latticeback_WOOD_NAME_VALUE\" },\n    \"facing=south,form=latticeback,carpeted=false,carpet_color=lime\": { \"model\": \"aestheticseating:block/lime/simple_stool_latticeback_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,form=latticeback,carpeted=false,carpet_color=lime\": { \"model\": \"aestheticseating:block/lime/simple_stool_latticeback_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,form=latticeback,carpeted=false,carpet_color=lime\": { \"model\": \"aestheticseating:block/lime/simple_stool_latticeback_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,form=latticeback,carpeted=true,carpet_color=lime\": { \"model\": \"aestheticseating:block/lime/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,form=latticeback,carpeted=true,carpet_color=lime\": { \"model\": \"aestheticseating:block/lime/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,form=latticeback,carpeted=true,carpet_color=lime\": { \"model\": \"aestheticseating:block/lime/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,form=latticeback,carpeted=true,carpet_color=lime\": { \"model\": \"aestheticseating:block/lime/simple_stool_latticeback_WOOD_NAME_VALUE_carpeted\", \"y\": 90 },\n    \"facing=north,form=desk,carpeted=false,carpet_color=lime\": { \"model\": \"aestheticseating:block/lime/simple_stool_desk_WOOD_NAME_VALUE\" },\n    \"facing=south,form=desk,carpeted=false,carpet_color=lime\": { \"model\": \"aestheticseating:block/lime/simple_stool_desk_WOOD_NAME_VALUE\", \"y\": 180 },\n    \"facing=west,form=desk,carpeted=false,carpet_color=lime\": { \"model\": \"aestheticseating:block/lime/simple_stool_desk_WOOD_NAME_VALUE\", \"y\": 270 },\n    \"facing=east,form=desk,carpeted=false,carpet_color=lime\": { \"model\": \"aestheticseating:block/lime/simple_stool_desk_WOOD_NAME_VALUE\", \"y\": 90 },\n    \"facing=north,form=desk,carpeted=true,carpet_color=lime\": { \"model\": \"aestheticseating:block/lime/simple_stool_desk_WOOD_NAME_VALUE_carpeted\" },\n    \"facing=south,form=desk,carpeted=true,carpet_color=lime\": { \"model\": \"aestheticseating:block/lime/simple_stool_desk_WOOD_NAME_VALUE_carpeted\", \"y\": 180 },\n    \"facing=west,form=desk,carpeted=true,carpet_color=lime\": { \"model\": \"aestheticseating:block/lime/simple_stool_desk_WOOD_NAME_VALUE_carpeted\", \"y\": 270 },\n    \"facing=east,form=desk,carpeted=true,carpet_color=lime\": { \"model\": \"aestheticseating:block/lime/simple_stool_desk_WOOD_NAME_VALUE_carpeted\", \"y\": 90 }\n  }\n}\n".replace("WOOD_NAME_VALUE", woodName);
        try (FileWriter writer = new FileWriter(modelFile);){
            writer.write(jsonContent);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

