/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticseating.block.custom;

import java.util.ArrayList;
import net.alminoris.aestheticseating.block.custom.SeatingFurniture;
import net.alminoris.aestheticseating.util.helper.VoxelShapeHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;

public class SimpleBench
extends SeatingFurniture {
    private static final VoxelShape SEAT = Block.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)9.0, (double)13.0);
    public static final EnumProperty<Variant> VARIANT = EnumProperty.m_61587_((String)"variant", Variant.class);
    public static final BooleanProperty BACKREST = BooleanProperty.m_61465_((String)"backrest");
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private final String name;

    public SimpleBench(String name) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_), -0.3);
        this.name = name;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(VARIANT, (Comparable)((Object)Variant.NORMAL))).m_61124_((Property)BACKREST, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, VARIANT, BACKREST});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.getRotatedShape(state);
    }

    private VoxelShape getRotatedShape(BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        ArrayList<AABB> shapes = new ArrayList<AABB>();
        shapes.add(SEAT.m_83215_());
        return VoxelShapeHelper.rotateShape(shapes, direction);
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        Variant currentVariant = (Variant)((Object)state.m_61143_(VARIANT));
        boolean currentBackrest = (Boolean)state.m_61143_((Property)BACKREST);
        if (stack.m_204117_(Tags.Items.TOOLS_AXES)) {
            if (!world.f_46443_ && currentBackrest) {
                currentBackrest = false;
                this.damageOrConsume(stack, player);
                Direction currentFacing = (Direction)state.m_61143_((Property)FACING);
                world.m_7731_(pos, (BlockState)((BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)currentFacing)).m_61124_(VARIANT, (Comparable)((Object)currentVariant))).m_61124_((Property)BACKREST, (Comparable)Boolean.valueOf(currentBackrest)), 3);
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        if (!currentBackrest && stack.m_204117_(TagKey.m_203882_((ResourceKey)ForgeRegistries.ITEMS.getRegistryKey(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"aestheticseating", (String)"wrench"))) && Block.m_49814_((Item)player.m_21206_().m_41720_()) != Blocks.f_50016_) {
            Block block;
            String check;
            if (!world.f_46443_ && !(check = this.checkForWrenching(ForgeRegistries.BLOCKS.getKey((Object)(block = Block.m_49814_((Item)player.m_21206_().m_41720_()))).m_135815_())).isEmpty() && this.name.equals(check)) {
                currentBackrest = true;
                player.m_21206_().m_41774_(1);
                this.damageOrConsume(stack, player);
                Direction currentFacing = (Direction)state.m_61143_((Property)FACING);
                world.m_7731_(pos, (BlockState)((BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)currentFacing)).m_61124_(VARIANT, (Comparable)((Object)currentVariant))).m_61124_((Property)BACKREST, (Comparable)Boolean.valueOf(currentBackrest)), 3);
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    private void damageOrConsume(ItemStack stack, Player player) {
        if (stack.m_41763_()) {
            if (stack.m_41773_() < stack.m_41776_() - 1) {
                stack.m_41721_(stack.m_41773_() + 1);
            } else {
                stack.m_41774_(1);
            }
        }
    }

    private String checkForWrenching(String name) {
        String[] arr = (name = name.replace("_nss", "")).split("_");
        if (arr.length > 0 && arr[0].equals("stripped")) {
            if (arr.length > 3) {
                return arr[1] + "_" + arr[2];
            }
            return arr[1];
        }
        return "";
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return this.updateBenchVariant(state, world, pos);
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, world, pos, oldState, isMoving);
        this.updateSurroundingBenches(world, pos);
    }

    private void updateSurroundingBenches(Level world, BlockPos pos) {
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockPos neighborPos = pos.m_121945_(dir);
            BlockState neighborState = world.m_8055_(neighborPos);
            if (!(neighborState.m_60734_() instanceof SimpleBench)) continue;
            world.m_7731_(neighborPos, this.updateBenchVariant(neighborState, (LevelAccessor)world, neighborPos), 3);
        }
    }

    private BlockState updateBenchVariant(BlockState state, LevelAccessor world, BlockPos pos) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockPos leftPos = pos.m_121945_(facing.m_122428_());
        BlockPos rightPos = pos.m_121945_(facing.m_122427_());
        boolean leftConnected = this.isBench(world, leftPos, facing);
        boolean rightConnected = this.isBench(world, rightPos, facing);
        if (leftConnected && rightConnected) {
            return (BlockState)state.m_61124_(VARIANT, (Comparable)((Object)Variant.CENTER));
        }
        if (leftConnected) {
            return (BlockState)state.m_61124_(VARIANT, (Comparable)((Object)Variant.RIGHT));
        }
        if (rightConnected) {
            return (BlockState)state.m_61124_(VARIANT, (Comparable)((Object)Variant.LEFT));
        }
        return (BlockState)state.m_61124_(VARIANT, (Comparable)((Object)Variant.NORMAL));
    }

    private boolean isBench(LevelAccessor world, BlockPos pos, Direction facing) {
        BlockState state = world.m_8055_(pos);
        return state.m_60734_() instanceof SimpleBench && state.m_61143_((Property)FACING) == facing;
    }

    public static enum Variant implements StringRepresentable
    {
        NORMAL("normal"),
        CENTER("center"),
        LEFT("left"),
        RIGHT("right");

        private final String name;

        private Variant(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

