/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticseating.block.custom;

import java.util.ArrayList;
import net.alminoris.aestheticseating.block.ModBlocks;
import net.alminoris.aestheticseating.block.custom.SeatingFurniture;
import net.alminoris.aestheticseating.item.ModItems;
import net.alminoris.aestheticseating.util.helper.VoxelShapeHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;

public class Settee
extends SeatingFurniture {
    private static final VoxelShape SEAT = Block.box((double)-4.0, (double)0.0, (double)0.0, (double)20.0, (double)4.0, (double)14.0);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final IntegerProperty VARIANT = IntegerProperty.create((String)"variant", (int)0, (int)2);
    public static final BooleanProperty TRANSFORMED = BooleanProperty.create((String)"transformed");
    private final String name;

    public Settee(String name) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BLACK_WOOL), -0.55);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)TRANSFORMED, (Comparable)Boolean.valueOf(false))).setValue((Property)VARIANT, (Comparable)Integer.valueOf(0)));
        this.name = name;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, TRANSFORMED, VARIANT});
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        boolean currentTransformed = (Boolean)state.getValue((Property)TRANSFORMED);
        int currentVariant = (Integer)state.getValue((Property)VARIANT);
        Direction currentFacing = (Direction)state.getValue((Property)FACING);
        if (stack.is(TagKey.create((ResourceKey)ForgeRegistries.ITEMS.getRegistryKey(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"aestheticseating", (String)"wrench")))) {
            if (!level.isClientSide) {
                level.setBlock(pos, (BlockState)((BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)currentFacing)).setValue((Property)TRANSFORMED, (Comparable)Boolean.valueOf(!currentTransformed))).setValue((Property)VARIANT, (Comparable)Integer.valueOf(currentVariant)), 3);
                if (stack.isDamageableItem()) {
                    stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                }
            }
            return ItemInteractionResult.SUCCESS;
        }
        if (stack.getItem() == ((Block)ModBlocks.CUSHIONS.get(this.name).get()).asItem() && currentVariant < 2) {
            if (!level.isClientSide) {
                level.setBlock(pos, (BlockState)((BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)currentFacing)).setValue((Property)TRANSFORMED, (Comparable)Boolean.valueOf(currentTransformed))).setValue((Property)VARIANT, (Comparable)Integer.valueOf(currentVariant + 1)), 3);
                stack.shrink(1);
            }
            return ItemInteractionResult.SUCCESS;
        }
        if (stack.getItem() == ModItems.CUSHION_REMOVER.get() && currentVariant > 0) {
            if (!level.isClientSide) {
                level.setBlock(pos, (BlockState)((BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)currentFacing)).setValue((Property)TRANSFORMED, (Comparable)Boolean.valueOf(currentTransformed))).setValue((Property)VARIANT, (Comparable)Integer.valueOf(currentVariant - 1)), 3);
                if (stack.isDamageableItem()) {
                    stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                }
                ItemStack carpetStack = new ItemStack((ItemLike)((Block)ModBlocks.CUSHIONS.get(this.name).get()).asItem());
                if (!player.getInventory().add(carpetStack)) {
                    player.drop(carpetStack, false);
                }
            }
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hit);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.getRotatedShape(state);
    }

    private VoxelShape getRotatedShape(BlockState state) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        ArrayList<AABB> boxes = new ArrayList<AABB>();
        boxes.add(SEAT.bounds());
        return VoxelShapeHelper.rotateShape(boxes, direction);
    }
}

