/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticseating.datagen;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.alminoris.aestheticseating.datagen.ModBlockLootTableProvider;
import net.alminoris.aestheticseating.datagen.ModBlockStateProvider;
import net.alminoris.aestheticseating.datagen.ModItemModelProvider;
import net.alminoris.aestheticseating.datagen.ModLanguageProviderDeDe;
import net.alminoris.aestheticseating.datagen.ModLanguageProviderEnUs;
import net.alminoris.aestheticseating.datagen.ModLanguageProviderEsEs;
import net.alminoris.aestheticseating.datagen.ModLanguageProviderFrFr;
import net.alminoris.aestheticseating.datagen.ModLanguageProviderRuRu;
import net.alminoris.aestheticseating.datagen.ModLanguageProviderUkUa;
import net.alminoris.aestheticseating.datagen.ModRecipeProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="aestheticseating", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(ModBlockLootTableProvider::new, LootContextParamSets.BLOCK)), lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new ModRecipeProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeClient(), (DataProvider)new ModBlockStateProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ModItemModelProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ModLanguageProviderEnUs(packOutput));
        generator.addProvider(event.includeClient(), (DataProvider)new ModLanguageProviderDeDe(packOutput));
        generator.addProvider(event.includeClient(), (DataProvider)new ModLanguageProviderEsEs(packOutput));
        generator.addProvider(event.includeClient(), (DataProvider)new ModLanguageProviderFrFr(packOutput));
        generator.addProvider(event.includeClient(), (DataProvider)new ModLanguageProviderRuRu(packOutput));
        generator.addProvider(event.includeClient(), (DataProvider)new ModLanguageProviderUkUa(packOutput));
    }
}

