/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticseating.datagen;

import java.util.Arrays;
import java.util.stream.Collectors;
import net.alminoris.aestheticseating.util.helper.BlockSetsHelper;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.registries.ForgeRegistries;

public class ModLanguageProviderEnUs
extends LanguageProvider {
    public ModLanguageProviderEnUs(PackOutput output) {
        super(output, "aestheticseating", "en_us");
    }

    public void addTranslations() {
        for (Block block : ForgeRegistries.BLOCKS) {
            String path;
            ResourceLocation id = ForgeRegistries.BLOCKS.getKey((Object)block);
            String pathNew = path = id.getPath();
            pathNew = ModLanguageProviderEnUs.movePrefix(ModLanguageProviderEnUs.movePrefix(ModLanguageProviderEnUs.movePrefix(path, BlockSetsHelper.COLORS), BlockSetsHelper.getStones()), BlockSetsHelper.getWoods());
            String[] parts = pathNew.split("_");
            String displayName = Arrays.stream(parts).map(s -> s.substring(0, 1).toUpperCase() + s.substring(1)).collect(Collectors.joining(" "));
            displayName = displayName.replace(" Nss", "");
            this.add("block.aestheticseating." + path, displayName);
        }
        this.add("item.aestheticseating.cushion_remover", "Cushion Remover");
        this.add("item.aestheticseating.wrench", "Wrench");
        this.add("itemgroup.aseattab", "Aesthetic Seating");
    }

    public static String movePrefix(String input, String[] arr) {
        String[] sorted = Arrays.copyOf(arr, arr.length);
        Arrays.sort(sorted, (a, b) -> Integer.compare(b.length(), a.length()));
        for (String el : sorted) {
            String suffix = "_" + el;
            if (!input.endsWith(suffix)) continue;
            String base = input.substring(0, input.length() - suffix.length());
            return base.isEmpty() ? el : el + "_" + base;
        }
        return input;
    }
}

