/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticseating.datagen;

import java.util.concurrent.CompletableFuture;
import net.alminoris.aestheticseating.block.ModBlocks;
import net.alminoris.aestheticseating.item.ModItems;
import net.alminoris.aestheticseating.util.helper.BlockSetsHelper;
import net.alminoris.aestheticseating.util.helper.ModJsonHelper;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;
import net.minecraftforge.registries.ForgeRegistries;

public class ModRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    public ModRecipeProvider(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> pRegistries) {
        super(pOutput, pRegistries);
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModItems.CUSHION_REMOVER.get()), (int)1).pattern(" ##").pattern(" /#").pattern("/  ").define(Character.valueOf('#'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('/'), (ItemLike)Items.STICK).unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.IRON_INGOT), ModRecipeProvider.has((ItemLike)Items.IRON_INGOT)).unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.STICK), ModRecipeProvider.has((ItemLike)Items.STICK)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModItems.WRENCH.get()), (int)1).pattern(" # ").pattern(" ##").pattern("/  ").define(Character.valueOf('#'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('/'), (ItemLike)Items.STICK).unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.IRON_INGOT), ModRecipeProvider.has((ItemLike)Items.IRON_INGOT)).unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.STICK), ModRecipeProvider.has((ItemLike)Items.STICK)).save(recipeOutput);
        for (String name : BlockSetsHelper.WOODS) {
            String blockName = name.equals("crimson") || name.equals("warped") ? "stem" : (name.equals("bamboo") ? "block" : "log");
            ModRecipeProvider.registerSimpleChair(recipeOutput, (Block)ModBlocks.SIMPLE_CHAIRS.get(name).get(), (Block)ForgeRegistries.BLOCKS.getValue(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)(name + "_slab"))), (Block)ForgeRegistries.BLOCKS.getValue(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)(name + "_" + blockName))));
            ModRecipeProvider.registerSimpleStool(recipeOutput, (Block)ModBlocks.SIMPLE_STOOLS.get(name).get(), (Block)ForgeRegistries.BLOCKS.getValue(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)(name + "_slab"))), (Block)ForgeRegistries.BLOCKS.getValue(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)(name + "_" + blockName))));
            ModRecipeProvider.registerSimpleBench(recipeOutput, (Block)ModBlocks.SIMPLE_BENCHES.get(name).get(), (Block)ForgeRegistries.BLOCKS.getValue(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)(name + "_slab"))), (Block)ForgeRegistries.BLOCKS.getValue(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)(name + "_" + blockName))));
            ModRecipeProvider.registerSeatingLog(recipeOutput, (Block)ModBlocks.SEATING_LOGS.get(name).get(), (Block)ForgeRegistries.BLOCKS.getValue(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)(name + "_" + blockName))));
        }
        for (String name : BlockSetsHelper.COLORS) {
            ModRecipeProvider.registerSettee(recipeOutput, (Block)ModBlocks.SETTEES.get(name).get(), (Block)ForgeRegistries.BLOCKS.getValue(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)(name + "_wool"))));
            ModRecipeProvider.registerSofa(recipeOutput, (Block)ModBlocks.SOFAS.get(name).get(), (Block)ForgeRegistries.BLOCKS.getValue(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)(name + "_wool"))));
        }
        for (String name : BlockSetsHelper.COLORS) {
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.CUSHIONS.get(name).get())).requires((ItemLike)ForgeRegistries.BLOCKS.getValue(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)(name + "_wool")))).unlockedBy(ModRecipeProvider.getHasName((ItemLike)((ItemLike)ForgeRegistries.BLOCKS.getValue(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)(name + "_wool"))))), ModRecipeProvider.has((ItemLike)((ItemLike)ForgeRegistries.BLOCKS.getValue(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)(name + "_wool")))))).save(recipeOutput);
        }
        for (String name : BlockSetsHelper.STONES) {
            ModRecipeProvider.registerVanillaStoneBench(name);
        }
        for (String name : BlockSetsHelper.EXTRA_STONES_WF) {
            ModRecipeProvider.registerStoneBench(name, "wildfields");
        }
        for (String name : BlockSetsHelper.AN_WOOD_NAMES) {
            ModRecipeProvider.registerSimpleChair(name, "arborealnature");
            ModRecipeProvider.registerSimpleStool(name, "arborealnature");
            ModRecipeProvider.registerSimpleBench(name, "arborealnature");
            ModRecipeProvider.registerSeatingLog(name, "arborealnature");
        }
        for (String name : BlockSetsHelper.WF_WOOD_NAMES) {
            ModRecipeProvider.registerSimpleChair(name, "wildfields");
            ModRecipeProvider.registerSimpleStool(name, "wildfields");
            ModRecipeProvider.registerSimpleBench(name, "wildfields");
            ModRecipeProvider.registerSeatingLog(name, "wildfields");
        }
        for (String name : BlockSetsHelper.ST_WOOD_NAMES) {
            ModRecipeProvider.registerSimpleChair(name, "silverwoodtrees");
            ModRecipeProvider.registerSimpleStool(name, "silverwoodtrees");
            ModRecipeProvider.registerSimpleBench(name, "silverwoodtrees");
            ModRecipeProvider.registerSeatingLog(name, "silverwoodtrees");
        }
        for (String name : BlockSetsHelper.WT_WOOD_NAMES) {
            ModRecipeProvider.registerSimpleChair(name, "whisperleaftrees");
            ModRecipeProvider.registerSimpleStool(name, "whisperleaftrees");
            ModRecipeProvider.registerSimpleBench(name, "whisperleaftrees");
            ModRecipeProvider.registerSeatingLog(name, "whisperleaftrees");
        }
        for (String name : BlockSetsHelper.MT_WOOD_NAMES) {
            ModRecipeProvider.registerSimpleChair(name, "missingtrees");
            ModRecipeProvider.registerSimpleStool(name, "missingtrees");
            ModRecipeProvider.registerSimpleBench(name, "missingtrees");
            ModRecipeProvider.registerSeatingLog(name, "missingtrees");
        }
        for (String name : BlockSetsHelper.NSS_WOOD_NAMES) {
            ModRecipeProvider.registerSimpleChair(name, "natures_spirit");
            ModRecipeProvider.registerSimpleStool(name, "natures_spirit");
            ModRecipeProvider.registerSimpleBench(name, "natures_spirit");
            ModRecipeProvider.registerSeatingLog(name, "natures_spirit");
        }
    }

    private static void registerSimpleChair(RecipeOutput recipeOutput, Block block, Block slab, Block log) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)block, (int)1).pattern("#  ").pattern("###").pattern("/ /").define(Character.valueOf('#'), (ItemLike)slab).define(Character.valueOf('/'), (ItemLike)log).unlockedBy(ModRecipeProvider.getHasName((ItemLike)slab), ModRecipeProvider.has((ItemLike)slab)).unlockedBy(ModRecipeProvider.getHasName((ItemLike)log), ModRecipeProvider.has((ItemLike)log)).save(recipeOutput);
    }

    private static void registerSimpleBench(RecipeOutput recipeOutput, Block block, Block slab, Block log) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)block, (int)1).pattern("##").pattern("//").define(Character.valueOf('#'), (ItemLike)slab).define(Character.valueOf('/'), (ItemLike)log).unlockedBy(ModRecipeProvider.getHasName((ItemLike)slab), ModRecipeProvider.has((ItemLike)slab)).unlockedBy(ModRecipeProvider.getHasName((ItemLike)log), ModRecipeProvider.has((ItemLike)log)).save(recipeOutput);
    }

    private static void registerSeatingLog(RecipeOutput recipeOutput, Block block, Block log) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)block, (int)1).pattern("##").define(Character.valueOf('#'), (ItemLike)log).unlockedBy(ModRecipeProvider.getHasName((ItemLike)log), ModRecipeProvider.has((ItemLike)log)).save(recipeOutput);
    }

    private static void registerVanillaStoneBench(String name) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(ResourceLocation.tryParse((String)(name.equals("basalt_side") ? "basalt" : (name.equals("quartz_block_bottom") ? "quartz_block" : name))));
        ModJsonHelper.createShapedRecipe("stone_bench_" + name, "1", "minecraft:smooth_stone", ForgeRegistries.BLOCKS.getKey((Object)block).getPath(), "\"##\",", "\"//\"", "");
    }

    private static void registerStoneBench(String name, String modId) {
        ModJsonHelper.createShapedRecipe("stone_bench_" + name, "1", "minecraft:smooth_stone", modId + ":" + name, "\"##\",", "\"//\"", "");
    }

    private static void registerSimpleBench(String name, String modId) {
        ModJsonHelper.createShapedRecipe("simple_bench_" + name, "1", modId + ":" + name + "_slab", modId + ":" + name + "_log", "\"##\",", "\"//\"", "");
    }

    private static void registerSeatingLog(String name, String modId) {
        ModJsonHelper.createShapedRecipe("seating_log_" + name, "1", modId + ":" + name + "_log", modId + ":" + name + "_log", "\"#/\"", "", "");
    }

    private static void registerSimpleChair(String name, String modId) {
        ModJsonHelper.createShapedRecipe("simple_chair_" + name, "1", modId + ":" + name + "_slab", modId + ":" + name + "_log", "\"#  \",", "\"###\",", "\"/ /\"");
    }

    private static void registerSimpleStool(String name, String modId) {
        ModJsonHelper.createShapedRecipe("simple_chair_" + name, "1", modId + ":" + name + "_slab", modId + ":" + name + "_log", "\"###\",", "\"/ /\"", "");
    }

    private static void registerSimpleStool(RecipeOutput recipeOutput, Block block, Block slab, Block log) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)block, (int)1).pattern("###").pattern("/ /").define(Character.valueOf('#'), (ItemLike)slab).define(Character.valueOf('/'), (ItemLike)log).unlockedBy(ModRecipeProvider.getHasName((ItemLike)slab), ModRecipeProvider.has((ItemLike)slab)).unlockedBy(ModRecipeProvider.getHasName((ItemLike)log), ModRecipeProvider.has((ItemLike)log)).save(recipeOutput);
    }

    private static void registerSettee(RecipeOutput recipeOutput, Block block, Block wool) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)block, (int)1).pattern("# #").pattern("###").define(Character.valueOf('#'), (ItemLike)wool).unlockedBy(ModRecipeProvider.getHasName((ItemLike)wool), ModRecipeProvider.has((ItemLike)wool)).save(recipeOutput);
    }

    private static void registerSofa(RecipeOutput recipeOutput, Block block, Block wool) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)block, (int)1).pattern("##").pattern("//").define(Character.valueOf('#'), (ItemLike)wool).define(Character.valueOf('/'), (ItemLike)Blocks.GRAY_CONCRETE).unlockedBy(ModRecipeProvider.getHasName((ItemLike)wool), ModRecipeProvider.has((ItemLike)wool)).unlockedBy(ModRecipeProvider.getHasName((ItemLike)Blocks.GRAY_CONCRETE), ModRecipeProvider.has((ItemLike)Blocks.GRAY_CONCRETE)).save(recipeOutput);
    }
}

