/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticseating.block;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.function.Supplier;
import net.alminoris.aestheticseating.block.custom.Cushion;
import net.alminoris.aestheticseating.block.custom.SeatingLog;
import net.alminoris.aestheticseating.block.custom.Settee;
import net.alminoris.aestheticseating.block.custom.SimpleBench;
import net.alminoris.aestheticseating.block.custom.SimpleChair;
import net.alminoris.aestheticseating.block.custom.SimpleStool;
import net.alminoris.aestheticseating.block.custom.Sofa;
import net.alminoris.aestheticseating.block.custom.StoneBench;
import net.alminoris.aestheticseating.item.ModItems;
import net.alminoris.aestheticseating.util.helper.BlockSetsHelper;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"aestheticseating");
    public static final Dictionary<String, DeferredBlock<Block>> SEATING_LOGS = new Hashtable<String, DeferredBlock<Block>>(){
        {
            for (String name : BlockSetsHelper.getWoods()) {
                this.put(name, ModBlocks.registerBlock("seating_log_" + name, () -> new SeatingLog()));
            }
        }
    };
    public static final Dictionary<String, DeferredBlock<Block>> SIMPLE_CHAIRS = new Hashtable<String, DeferredBlock<Block>>(){
        {
            for (String name : BlockSetsHelper.getWoods()) {
                this.put(name, ModBlocks.registerBlock("simple_chair_" + name, () -> new SimpleChair()));
            }
        }
    };
    public static final Dictionary<String, DeferredBlock<Block>> SIMPLE_BENCHES = new Hashtable<String, DeferredBlock<Block>>(){
        {
            for (String name : BlockSetsHelper.getWoods()) {
                this.put(name, ModBlocks.registerBlock("simple_bench_" + name, () -> new SimpleBench(name)));
            }
        }
    };
    public static final Dictionary<String, DeferredBlock<Block>> STONE_BENCHES = new Hashtable<String, DeferredBlock<Block>>(){
        {
            for (String name : BlockSetsHelper.getStones()) {
                this.put(name, ModBlocks.registerBlock("stone_bench_" + name, () -> new StoneBench()));
            }
        }
    };
    public static final Dictionary<String, DeferredBlock<Block>> SIMPLE_STOOLS = new Hashtable<String, DeferredBlock<Block>>(){
        {
            for (String name : BlockSetsHelper.getWoods()) {
                this.put(name, ModBlocks.registerBlock("simple_stool_" + name, () -> new SimpleStool(name)));
            }
        }
    };
    public static final Dictionary<String, DeferredBlock<Block>> SETTEES = new Hashtable<String, DeferredBlock<Block>>(){
        {
            for (String name : BlockSetsHelper.COLORS) {
                this.put(name, ModBlocks.registerBlock("settee_" + name, () -> new Settee(name)));
            }
        }
    };
    public static final Dictionary<String, DeferredBlock<Block>> SOFAS = new Hashtable<String, DeferredBlock<Block>>(){
        {
            for (String name : BlockSetsHelper.COLORS) {
                this.put(name, ModBlocks.registerBlock("sofa_" + name, () -> new Sofa(name)));
            }
        }
    };
    public static final Dictionary<String, DeferredBlock<Block>> CUSHIONS = new Hashtable<String, DeferredBlock<Block>>(){
        {
            for (String name : BlockSetsHelper.COLORS) {
                this.put(name, ModBlocks.registerBlock("cushion_" + name, () -> new Cushion()));
            }
        }
    };

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, DeferredBlock<T> block) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

