/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticseating.block.custom;

import java.util.ArrayList;
import net.alminoris.aestheticseating.block.ModBlocks;
import net.alminoris.aestheticseating.block.custom.SeatingFurniture;
import net.alminoris.aestheticseating.item.ModItems;
import net.alminoris.aestheticseating.util.helper.VoxelShapeHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Sofa
extends SeatingFurniture {
    private static final VoxelShape SEAT = Block.box((double)0.0, (double)2.0, (double)1.0, (double)16.0, (double)7.0, (double)15.0);
    private static final VoxelShape SEAT_NORMAL = Block.box((double)1.0, (double)2.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty CUSHION = BooleanProperty.create((String)"cushion");
    public static final EnumProperty<Variant> VARIANT = EnumProperty.create((String)"variant", Variant.class);
    private final String name;

    public Sofa(String name) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BLACK_WOOL), -0.35);
        this.name = name;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(VARIANT, (Comparable)((Object)Variant.NORMAL))).setValue((Property)CUSHION, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, VARIANT, CUSHION});
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.getRotatedShape(state);
    }

    private VoxelShape getRotatedShape(BlockState state) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        Variant variant = (Variant)((Object)state.getValue(VARIANT));
        ArrayList<AABB> boxes = new ArrayList<AABB>();
        if (variant == Variant.NORMAL) {
            boxes.add(SEAT_NORMAL.bounds());
        } else {
            boxes.add(SEAT.bounds());
        }
        return VoxelShapeHelper.rotateShape(boxes, direction);
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        boolean currentCushion = (Boolean)state.getValue((Property)CUSHION);
        Variant currentVariant = (Variant)((Object)state.getValue(VARIANT));
        Direction currentFacing = (Direction)state.getValue((Property)FACING);
        if (stack.getItem() == ((Block)ModBlocks.CUSHIONS.get(this.name).get()).asItem() && !currentCushion) {
            if (!level.isClientSide) {
                level.setBlock(pos, (BlockState)((BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)currentFacing)).setValue((Property)CUSHION, (Comparable)Boolean.valueOf(true))).setValue(VARIANT, (Comparable)((Object)currentVariant)), 3);
                stack.shrink(1);
            }
            return ItemInteractionResult.SUCCESS;
        }
        if (stack.getItem() == ModItems.CUSHION_REMOVER.get() && currentCushion) {
            if (!level.isClientSide) {
                level.setBlock(pos, (BlockState)((BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)currentFacing)).setValue((Property)CUSHION, (Comparable)Boolean.valueOf(false))).setValue(VARIANT, (Comparable)((Object)currentVariant)), 3);
                if (stack.isDamageableItem()) {
                    stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                } else {
                    stack.shrink(1);
                }
                ItemStack carpetStack = new ItemStack((ItemLike)((Block)ModBlocks.CUSHIONS.get(this.name).get()).asItem());
                if (!player.getInventory().add(carpetStack)) {
                    player.drop(carpetStack, false);
                }
            }
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hit);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return this.updateSofaVariant(world, state, pos);
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean moving) {
        super.onPlace(state, level, pos, oldState, moving);
        this.updateSurroundingSofas(level, pos);
    }

    private void updateSurroundingSofas(Level world, BlockPos pos) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockState updatedState;
            BlockPos neighborPos = pos.relative(direction);
            BlockState neighborState = world.getBlockState(neighborPos);
            if (!(neighborState.getBlock() instanceof Sofa) || neighborState.equals(updatedState = this.updateSofaVariant((LevelAccessor)world, neighborState, neighborPos))) continue;
            world.setBlock(neighborPos, updatedState, 3);
        }
    }

    private BlockState updateSofaVariant(LevelAccessor world, BlockState state, BlockPos pos) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        BlockPos leftPos = pos.relative(facing.getCounterClockWise());
        BlockPos rightPos = pos.relative(facing.getClockWise());
        boolean leftConnected = this.isSofa(world, leftPos, facing, Variant.RIGHTCORNER);
        boolean rightConnected = this.isSofa(world, rightPos, facing, Variant.LEFTCORNER);
        if (this.isSofaL(world, rightPos.relative(facing.getCounterClockWise()).relative(facing.getClockWise().getClockWise()), facing)) {
            return (BlockState)state.setValue(VARIANT, (Comparable)((Object)Variant.RIGHTCORNER));
        }
        if (this.isSofaR(world, leftPos.relative(facing.getClockWise()).relative(facing.getCounterClockWise().getCounterClockWise()), facing)) {
            return (BlockState)state.setValue(VARIANT, (Comparable)((Object)Variant.LEFTCORNER));
        }
        if (leftConnected && rightConnected) {
            return (BlockState)state.setValue(VARIANT, (Comparable)((Object)Variant.CENTER));
        }
        if (leftConnected) {
            return (BlockState)state.setValue(VARIANT, (Comparable)((Object)Variant.RIGHT));
        }
        if (rightConnected) {
            return (BlockState)state.setValue(VARIANT, (Comparable)((Object)Variant.LEFT));
        }
        return (BlockState)state.setValue(VARIANT, (Comparable)((Object)Variant.NORMAL));
    }

    private boolean isSofa(LevelAccessor world, BlockPos pos, Direction expectedFacing, Variant variant) {
        BlockState state = world.getBlockState(pos);
        return state.getBlock() instanceof Sofa && (state.getValue((Property)FACING) == expectedFacing || state.getValue(VARIANT) == variant);
    }

    private boolean isSofaL(LevelAccessor world, BlockPos pos, Direction expectedFacing) {
        BlockState state = world.getBlockState(pos);
        return state.getBlock() instanceof Sofa && state.getValue((Property)FACING) == expectedFacing.getClockWise();
    }

    private boolean isSofaR(LevelAccessor world, BlockPos pos, Direction expectedFacing) {
        BlockState state = world.getBlockState(pos);
        return state.getBlock() instanceof Sofa && state.getValue((Property)FACING) == expectedFacing.getCounterClockWise();
    }

    public static enum Variant implements StringRepresentable
    {
        NORMAL("normal"),
        CENTER("center"),
        LEFT("left"),
        RIGHT("right"),
        LEFTCORNER("leftcorner"),
        RIGHTCORNER("rightcorner");

        private final String name;

        private Variant(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

