/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticseating.block.custom;

import java.util.ArrayList;
import net.alminoris.aestheticseating.block.custom.SeatingFurniture;
import net.alminoris.aestheticseating.util.helper.VoxelShapeHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SeatingLog
extends SeatingFurniture {
    private static final VoxelShape SEAT = Block.m_49796_((double)2.0, (double)0.0, (double)5.0, (double)14.0, (double)6.0, (double)11.0);
    private static final VoxelShape SEAT_CENTER = Block.m_49796_((double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)6.0, (double)11.0);
    private static final VoxelShape SEAT_LEFT = Block.m_49796_((double)2.0, (double)0.0, (double)5.0, (double)16.0, (double)6.0, (double)11.0);
    private static final VoxelShape SEAT_RIGHT = Block.m_49796_((double)0.0, (double)0.0, (double)5.0, (double)14.0, (double)6.0, (double)11.0);
    public static final EnumProperty<Variant> VARIANT = EnumProperty.m_61587_((String)"variant", Variant.class);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;

    public SeatingLog() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_), -0.45);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(VARIANT, (Comparable)((Object)Variant.NORMAL)));
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, VARIANT});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.getRotatedShape(state);
    }

    private VoxelShape getRotatedShape(BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        ArrayList<AABB> boxes = new ArrayList<AABB>();
        switch ((Variant)((Object)state.m_61143_(VARIANT))) {
            case NORMAL: {
                boxes.add(SEAT.m_83215_());
                break;
            }
            case CENTER: {
                boxes.add(SEAT_CENTER.m_83215_());
                break;
            }
            case LEFT: {
                boxes.add(SEAT_LEFT.m_83215_());
                break;
            }
            case RIGHT: {
                boxes.add(SEAT_RIGHT.m_83215_());
            }
        }
        return VoxelShapeHelper.rotateShape(boxes, direction);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return this.updateSeatingLogVariant(state, world, pos);
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        super.m_6807_(state, world, pos, oldState, notify);
        this.updateSurroundingLogs(world, pos);
    }

    private void updateSurroundingLogs(Level world, BlockPos pos) {
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockPos neighborPos = pos.m_142300_(dir);
            BlockState neighborState = world.m_8055_(neighborPos);
            if (!(neighborState.m_60734_() instanceof SeatingLog)) continue;
            world.m_7731_(neighborPos, this.updateSeatingLogVariant(neighborState, (LevelAccessor)world, neighborPos), 3);
        }
    }

    private BlockState updateSeatingLogVariant(BlockState state, LevelAccessor world, BlockPos pos) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockPos leftPos = pos.m_142300_(facing.m_122428_());
        BlockPos rightPos = pos.m_142300_(facing.m_122427_());
        boolean leftConnected = this.isFullSolidOrMatchingLog(world, leftPos, facing);
        boolean rightConnected = this.isFullSolidOrMatchingLog(world, rightPos, facing);
        if (leftConnected && rightConnected) {
            return (BlockState)state.m_61124_(VARIANT, (Comparable)((Object)Variant.CENTER));
        }
        if (leftConnected) {
            return (BlockState)state.m_61124_(VARIANT, (Comparable)((Object)Variant.RIGHT));
        }
        if (rightConnected) {
            return (BlockState)state.m_61124_(VARIANT, (Comparable)((Object)Variant.LEFT));
        }
        return (BlockState)state.m_61124_(VARIANT, (Comparable)((Object)Variant.NORMAL));
    }

    private boolean isFullSolidOrMatchingLog(LevelAccessor world, BlockPos pos, Direction facing) {
        BlockState state = world.m_8055_(pos);
        if (state.m_60734_() instanceof SeatingLog && state.m_61143_((Property)FACING) == facing) {
            return true;
        }
        return state.m_60804_((BlockGetter)world, pos) && state.m_60815_();
    }

    public static enum Variant implements StringRepresentable
    {
        NORMAL("normal"),
        CENTER("center"),
        LEFT("left"),
        RIGHT("right");

        private final String name;

        private Variant(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

