/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticseating.block.custom;

import java.util.ArrayList;
import net.alminoris.aestheticseating.block.custom.SeatingFurniture;
import net.alminoris.aestheticseating.item.ModItems;
import net.alminoris.aestheticseating.util.helper.VoxelShapeHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;

public class SimpleChair
extends SeatingFurniture {
    private static final VoxelShape SEAT = Block.m_49796_((double)3.2, (double)0.0, (double)3.0, (double)12.8, (double)8.0, (double)13.0);
    public static final EnumProperty<CarpetColor> CARPET_COLOR = EnumProperty.m_61587_((String)"carpet_color", CarpetColor.class);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty CARPETED = BooleanProperty.m_61465_((String)"carpeted");
    public static final BooleanProperty RECLINED = BooleanProperty.m_61465_((String)"reclined");

    public SimpleChair() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_), -0.3);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)RECLINED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CARPETED, (Comparable)Boolean.valueOf(false))).m_61124_(CARPET_COLOR, (Comparable)((Object)CarpetColor.BLACK)));
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, RECLINED, CARPETED, CARPET_COLOR});
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        boolean currentReclined = (Boolean)state.m_61143_((Property)RECLINED);
        boolean currentCarpeted = (Boolean)state.m_61143_((Property)CARPETED);
        if (stack.m_204117_(ItemTags.f_13172_) && !currentCarpeted) {
            if (!level.f_46443_) {
                Direction facing = (Direction)state.m_61143_((Property)FACING);
                String colorName = stack.m_41720_().m_5524_().replace("block.minecraft.", "").replace("_carpet", "");
                level.m_7731_(pos, (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)facing)).m_61124_((Property)RECLINED, (Comparable)Boolean.valueOf(currentReclined))).m_61124_((Property)CARPETED, (Comparable)Boolean.valueOf(true))).m_61124_(CARPET_COLOR, (Comparable)((Object)CarpetColor.fromString(colorName))), 3);
                stack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        if (stack.m_204117_(TagKey.m_203882_((ResourceKey)ForgeRegistries.ITEMS.getRegistryKey(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"aestheticseating", (String)"wrench")))) {
            if (!level.f_46443_) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)RECLINED, (Comparable)Boolean.valueOf(!currentReclined)), 3);
                stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(InteractionHand.MAIN_HAND));
            }
            return InteractionResult.SUCCESS;
        }
        if (stack.m_150930_((Item)ModItems.CUSHION_REMOVER.get())) {
            if (!level.f_46443_) {
                Direction facing = (Direction)state.m_61143_((Property)FACING);
                CarpetColor carpetColor = (CarpetColor)((Object)state.m_61143_(CARPET_COLOR));
                level.m_7731_(pos, (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)facing)).m_61124_((Property)RECLINED, (Comparable)Boolean.valueOf(currentReclined))).m_61124_((Property)CARPETED, (Comparable)Boolean.valueOf(false))).m_61124_(CARPET_COLOR, (Comparable)((Object)carpetColor)), 3);
                stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(InteractionHand.MAIN_HAND));
                Item carpetItem = (Item)Registry.f_122827_.m_7745_(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)(carpetColor.m_7912_() + "_carpet")));
                ItemStack carpetStack = new ItemStack((ItemLike)carpetItem);
                if (!player.m_150109_().m_36054_(carpetStack)) {
                    player.m_36176_(carpetStack, false);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext ctx) {
        return this.getRotatedShape(state);
    }

    private VoxelShape getRotatedShape(BlockState state) {
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        ArrayList<AABB> boxes = new ArrayList<AABB>();
        boxes.add(SEAT.m_83215_());
        return VoxelShapeHelper.rotateShape(boxes, dir);
    }

    public static enum CarpetColor implements StringRepresentable
    {
        BLACK("black"),
        BROWN("brown"),
        GRAY("gray"),
        LIGHT_GRAY("light_gray"),
        WHITE("white"),
        RED("red"),
        ORANGE("orange"),
        YELLOW("yellow"),
        PURPLE("purple"),
        MAGENTA("magenta"),
        PINK("pink"),
        BLUE("blue"),
        CYAN("cyan"),
        LIGHT_BLUE("light_blue"),
        GREEN("green"),
        LIME("lime");

        private final String name;

        private CarpetColor(String name) {
            this.name = name;
        }

        public static CarpetColor fromString(String name) {
            for (CarpetColor inside : CarpetColor.values()) {
                if (!inside.name.equalsIgnoreCase(name)) continue;
                return inside;
            }
            throw new IllegalArgumentException("No enum constant for name: " + name);
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

