/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticseating.block.custom;

import java.util.ArrayList;
import net.alminoris.aestheticseating.block.ModBlocks;
import net.alminoris.aestheticseating.block.custom.SeatingFurniture;
import net.alminoris.aestheticseating.item.ModItems;
import net.alminoris.aestheticseating.util.helper.VoxelShapeHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Sofa
extends SeatingFurniture {
    private static final VoxelShape SEAT = Block.m_49796_((double)0.0, (double)2.0, (double)1.0, (double)16.0, (double)7.0, (double)15.0);
    private static final VoxelShape SEAT_NORMAL = Block.m_49796_((double)1.0, (double)2.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty CUSHION = BooleanProperty.m_61465_((String)"cushion");
    public static final EnumProperty<Variant> VARIANT = EnumProperty.m_61587_((String)"variant", Variant.class);
    private final String name;

    public Sofa(String name) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50109_), -0.35);
        this.name = name;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(VARIANT, (Comparable)((Object)Variant.NORMAL))).m_61124_((Property)CUSHION, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, VARIANT, CUSHION});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.getRotatedShape(state);
    }

    private VoxelShape getRotatedShape(BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        Variant variant = (Variant)((Object)state.m_61143_(VARIANT));
        ArrayList<AABB> boxes = new ArrayList<AABB>();
        if (variant == Variant.NORMAL) {
            boxes.add(SEAT_NORMAL.m_83215_());
        } else {
            boxes.add(SEAT.m_83215_());
        }
        return VoxelShapeHelper.rotateShape(boxes, direction);
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        boolean currentCushion = (Boolean)state.m_61143_((Property)CUSHION);
        Variant currentVariant = (Variant)((Object)state.m_61143_(VARIANT));
        Direction currentFacing = (Direction)state.m_61143_((Property)FACING);
        if (stack.m_41720_() == ((Block)ModBlocks.CUSHIONS.get(this.name).get()).m_5456_() && !currentCushion) {
            if (!level.f_46443_) {
                level.m_7731_(pos, (BlockState)((BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)currentFacing)).m_61124_((Property)CUSHION, (Comparable)Boolean.valueOf(true))).m_61124_(VARIANT, (Comparable)((Object)currentVariant)), 3);
                stack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        if (stack.m_41720_() == ModItems.CUSHION_REMOVER.get() && currentCushion) {
            if (!level.f_46443_) {
                level.m_7731_(pos, (BlockState)((BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)currentFacing)).m_61124_((Property)CUSHION, (Comparable)Boolean.valueOf(false))).m_61124_(VARIANT, (Comparable)((Object)currentVariant)), 3);
                if (stack.m_41763_()) {
                    stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(InteractionHand.MAIN_HAND));
                } else {
                    stack.m_41774_(1);
                }
                ItemStack carpetStack = new ItemStack((ItemLike)((Block)ModBlocks.CUSHIONS.get(this.name).get()).m_5456_());
                if (!player.m_150109_().m_36054_(carpetStack)) {
                    player.m_36176_(carpetStack, false);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return this.updateSofaVariant(world, state, pos);
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean moving) {
        super.m_6807_(state, level, pos, oldState, moving);
        this.updateSurroundingSofas(level, pos);
    }

    private void updateSurroundingSofas(Level world, BlockPos pos) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockState updatedState;
            BlockPos neighborPos = pos.m_142300_(direction);
            BlockState neighborState = world.m_8055_(neighborPos);
            if (!(neighborState.m_60734_() instanceof Sofa) || neighborState.equals(updatedState = this.updateSofaVariant((LevelAccessor)world, neighborState, neighborPos))) continue;
            world.m_7731_(neighborPos, updatedState, 3);
        }
    }

    private BlockState updateSofaVariant(LevelAccessor world, BlockState state, BlockPos pos) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockPos leftPos = pos.m_142300_(facing.m_122428_());
        BlockPos rightPos = pos.m_142300_(facing.m_122427_());
        boolean leftConnected = this.isSofa(world, leftPos, facing, Variant.RIGHTCORNER);
        boolean rightConnected = this.isSofa(world, rightPos, facing, Variant.LEFTCORNER);
        if (this.isSofaL(world, rightPos.m_142300_(facing.m_122428_()).m_142300_(facing.m_122427_().m_122427_()), facing)) {
            return (BlockState)state.m_61124_(VARIANT, (Comparable)((Object)Variant.RIGHTCORNER));
        }
        if (this.isSofaR(world, leftPos.m_142300_(facing.m_122427_()).m_142300_(facing.m_122428_().m_122428_()), facing)) {
            return (BlockState)state.m_61124_(VARIANT, (Comparable)((Object)Variant.LEFTCORNER));
        }
        if (leftConnected && rightConnected) {
            return (BlockState)state.m_61124_(VARIANT, (Comparable)((Object)Variant.CENTER));
        }
        if (leftConnected) {
            return (BlockState)state.m_61124_(VARIANT, (Comparable)((Object)Variant.RIGHT));
        }
        if (rightConnected) {
            return (BlockState)state.m_61124_(VARIANT, (Comparable)((Object)Variant.LEFT));
        }
        return (BlockState)state.m_61124_(VARIANT, (Comparable)((Object)Variant.NORMAL));
    }

    private boolean isSofa(LevelAccessor world, BlockPos pos, Direction expectedFacing, Variant variant) {
        BlockState state = world.m_8055_(pos);
        return state.m_60734_() instanceof Sofa && (state.m_61143_((Property)FACING) == expectedFacing || state.m_61143_(VARIANT) == variant);
    }

    private boolean isSofaL(LevelAccessor world, BlockPos pos, Direction expectedFacing) {
        BlockState state = world.m_8055_(pos);
        return state.m_60734_() instanceof Sofa && state.m_61143_((Property)FACING) == expectedFacing.m_122427_();
    }

    private boolean isSofaR(LevelAccessor world, BlockPos pos, Direction expectedFacing) {
        BlockState state = world.m_8055_(pos);
        return state.m_60734_() instanceof Sofa && state.m_61143_((Property)FACING) == expectedFacing.m_122428_();
    }

    public static enum Variant implements StringRepresentable
    {
        NORMAL("normal"),
        CENTER("center"),
        LEFT("left"),
        RIGHT("right"),
        LEFTCORNER("leftcorner"),
        RIGHTCORNER("rightcorner");

        private final String name;

        private Variant(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

