/*
 * Decompiled with CFR 0.152.
 */
package dev.skir.commandapi.network;

import dev.skir.commandapi.exceptions.ProtocolVersionTooOldException;
import dev.skir.commandapi.network.CommandAPIPacket;
import dev.skir.commandapi.network.CommandAPIPacketHandler;
import dev.skir.commandapi.network.packets.ProtocolVersionTooOldPacket;
import dev.skir.commandapi.network.packets.SetVersionPacket;

public interface HandshakePacketHandler<InputChannel>
extends CommandAPIPacketHandler<InputChannel> {
    @Override
    default public void handlePacket(InputChannel sender, CommandAPIPacket packet) {
        if (packet instanceof SetVersionPacket) {
            SetVersionPacket p = (SetVersionPacket)packet;
            this.handleSetVersionPacket(sender, p);
        } else if (packet instanceof ProtocolVersionTooOldPacket) {
            ProtocolVersionTooOldPacket p = (ProtocolVersionTooOldPacket)packet;
            this.handleProtocolVersionTooOldPacket(sender, p);
        } else {
            throw new IllegalStateException("Tried to handle " + String.valueOf(packet) + " with HandshakePacketHandler. HandshakePacketHandler can't handle this packet.");
        }
    }

    public void handleSetVersionPacket(InputChannel var1, SetVersionPacket var2);

    default public void handleProtocolVersionTooOldPacket(InputChannel sender, ProtocolVersionTooOldPacket packet) {
        throw ProtocolVersionTooOldException.received(sender, packet.protocolVersion(), packet.reason());
    }
}

