/*
 * Decompiled with CFR 0.152.
 */
package dev.skir.config.languages;

import dev.skir.DiverseFX;
import dev.skir.config.Settings;
import dev.skir.config.languages.Locale;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\u0007J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\nJ\u0006\u0010\f\u001a\u00020\u0007J\u0006\u0010\r\u001a\u00020\nJ\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f2\u0006\u0010\u0010\u001a\u00020\u0006J\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0012J\u000e\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ldev/skir/config/languages/LM;", "", "<init>", "()V", "locales", "", "", "Ldev/skir/config/languages/Locale;", "getDefault", "loadLocales", "", "loadDefault", "getLocale", "reload", "getOverride", "Ljava/util/Optional;", "localeName", "getAll", "", "fix", "Companion", "DiverseFX"})
@SourceDebugExtension(value={"SMAP\nLM.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LM.kt\ndev/skir/config/languages/LM\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,80:1\n739#2,9:81\n37#3:90\n36#3,3:91\n*S KotlinDebug\n*F\n+ 1 LM.kt\ndev/skir/config/languages/LM\n*L\n77#1:81,9\n77#1:90\n77#1:91,3\n*E\n"})
public final class LM {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, Locale> locales = new ConcurrentHashMap();
    @Nullable
    private static LM instance;
    @NotNull
    private static final File FOLDER;
    @NotNull
    private static final String DEFAULT;

    public LM() {
        if (!FOLDER.exists()) {
            FOLDER.mkdirs();
        }
        this.loadDefault();
        this.loadLocales();
    }

    @NotNull
    public final Locale getDefault() {
        Locale locale = Companion.i().getOverride(DEFAULT).orElseThrow(LM::getDefault$lambda$0);
        Intrinsics.checkNotNullExpressionValue(locale, "orElseThrow(...)");
        return locale;
    }

    public final void loadLocales() {
        String[] stringArray = FOLDER.list();
        if (stringArray == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        for (String fileNames : stringArray) {
            String name = StringsKt.replace$default(fileNames, ".yml", "", false, 4, null);
            Locale locale = Locale.Companion.get(name);
            this.locales.put(name, locale);
        }
    }

    public final void loadDefault() {
        if (!new File(FOLDER, "en_US.yml").exists()) {
            DiverseFX.Companion.getInstance().saveResource("languages/en_US.yml", false);
        }
        if (!new File(FOLDER, "lt_LT.yml").exists()) {
            DiverseFX.Companion.getInstance().saveResource("languages/lt_LT.yml", false);
        }
    }

    @NotNull
    public final Locale getLocale() {
        Locale locale = this.locales.get(this.fix(Settings.Companion.i().getLanguage()));
        if (locale == null) {
            Locale locale2 = this.getOverride(DEFAULT).orElseThrow(LM::getLocale$lambda$1);
            Intrinsics.checkNotNullExpressionValue(locale2, "orElseThrow(...)");
            return locale2;
        }
        Locale locale3 = locale;
        return locale3;
    }

    public final void reload() {
        this.locales.clear();
        this.loadLocales();
    }

    @NotNull
    public final Optional<Locale> getOverride(@NotNull String localeName) {
        Intrinsics.checkNotNullParameter(localeName, "localeName");
        Optional<Locale> optional = Optional.ofNullable(this.locales.get(localeName));
        Intrinsics.checkNotNullExpressionValue(optional, "ofNullable(...)");
        return optional;
    }

    @NotNull
    public final List<Locale> getAll() {
        return new ArrayList<Locale>(this.locales.values());
    }

    @NotNull
    public final String fix(@NotNull String localeName) {
        List list;
        Intrinsics.checkNotNullParameter(localeName, "localeName");
        CharSequence charSequence = localeName;
        Regex regex = new Regex("_");
        int n = 0;
        List<String> $this$dropLastWhile$iv = regex.split(charSequence, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator<String> iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, iterator$iv.nextIndex() + 1);
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] strings = thisCollection$iv.toArray(new String[0]);
        String string = strings[0];
        charSequence = strings[1];
        java.util.Locale locale = java.util.Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
        String string2 = ((String)charSequence).toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue(string2, "toUpperCase(...)");
        return string + "_" + string2;
    }

    private static final NullPointerException getDefault$lambda$0() {
        return new NullPointerException("Who removed the english locale?");
    }

    private static final NullPointerException getLocale$lambda$1() {
        return new NullPointerException("Who removed the english locale?");
    }

    static {
        FOLDER = new File(DiverseFX.Companion.getInstance().getDataFolder(), "languages");
        DEFAULT = "en_US";
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0012\u001a\u00020\u0005R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0013"}, d2={"Ldev/skir/config/languages/LM$Companion;", "", "<init>", "()V", "instance", "Ldev/skir/config/languages/LM;", "getInstance", "()Ldev/skir/config/languages/LM;", "setInstance", "(Ldev/skir/config/languages/LM;)V", "FOLDER", "Ljava/io/File;", "getFOLDER", "()Ljava/io/File;", "DEFAULT", "", "getDEFAULT", "()Ljava/lang/String;", "i", "DiverseFX"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final LM getInstance() {
            return instance;
        }

        public final void setInstance(@Nullable LM lM) {
            instance = lM;
        }

        @NotNull
        public final File getFOLDER() {
            return FOLDER;
        }

        @NotNull
        public final String getDEFAULT() {
            return DEFAULT;
        }

        @NotNull
        public final LM i() {
            if (this.getInstance() == null) {
                this.setInstance(new LM());
            }
            LM lM = this.getInstance();
            Intrinsics.checkNotNull(lM, "null cannot be cast to non-null type dev.skir.config.languages.LM");
            return lM;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

