/*
 * Decompiled with CFR 0.152.
 */
package dev.skir.config.languages;

import de.exlll.configlib.Comment;
import de.exlll.configlib.Configuration;
import de.exlll.configlib.YamlConfigurationProperties;
import de.exlll.configlib.YamlConfigurations;
import dev.skir.config.languages.LM;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Configuration
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0003\u0010\u0011\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0013"}, d2={"Ldev/skir/config/languages/Locale;", "", "<init>", "()V", "general", "Ldev/skir/config/languages/Locale$General;", "getGeneral", "()Ldev/skir/config/languages/Locale$General;", "setGeneral", "(Ldev/skir/config/languages/Locale$General;)V", "shownVisuals", "Ldev/skir/config/languages/Locale$ShownVisuals;", "getShownVisuals", "()Ldev/skir/config/languages/Locale$ShownVisuals;", "setShownVisuals", "(Ldev/skir/config/languages/Locale$ShownVisuals;)V", "General", "ShownVisuals", "Companion", "DiverseFX"})
public final class Locale {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private General general = new General();
    @NotNull
    private ShownVisuals shownVisuals = new ShownVisuals();
    @NotNull
    private static final String CONFIG_HEADER = "DiverseFX Language File\n\nYOU CAN USE MINIMESSAGE FORMATTING HERE. BUT ONLY MINIMESSAGE FORMATTING.";
    @NotNull
    private static final YamlConfigurationProperties PROPERTIES;

    @NotNull
    public final General getGeneral() {
        return this.general;
    }

    public final void setGeneral(@NotNull General general) {
        Intrinsics.checkNotNullParameter(general, "<set-?>");
        this.general = general;
    }

    @NotNull
    public final ShownVisuals getShownVisuals() {
        return this.shownVisuals;
    }

    public final void setShownVisuals(@NotNull ShownVisuals shownVisuals) {
        Intrinsics.checkNotNullParameter(shownVisuals, "<set-?>");
        this.shownVisuals = shownVisuals;
    }

    static {
        YamlConfigurationProperties yamlConfigurationProperties = ((YamlConfigurationProperties.Builder)((YamlConfigurationProperties.Builder)YamlConfigurationProperties.newBuilder().charset(StandardCharsets.UTF_8)).header(CONFIG_HEADER)).build();
        Intrinsics.checkNotNullExpressionValue(yamlConfigurationProperties, "build(...)");
        PROPERTIES = yamlConfigurationProperties;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Ldev/skir/config/languages/Locale$Companion;", "", "<init>", "()V", "CONFIG_HEADER", "", "PROPERTIES", "Lde/exlll/configlib/YamlConfigurationProperties;", "get", "Ldev/skir/config/languages/Locale;", "localeCode", "DiverseFX"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Locale get(@NotNull String localeCode) {
            Intrinsics.checkNotNullParameter(localeCode, "localeCode");
            Path file = new File(LM.Companion.getFOLDER(), localeCode + ".yml").toPath();
            Locale locale = YamlConfigurations.load(file, Locale.class, PROPERTIES);
            Intrinsics.checkNotNullExpressionValue(locale, "load(...)");
            return locale;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Configuration
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000e\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\tR\u001a\u0010\u0010\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\t\u00a8\u0006\u0013"}, d2={"Ldev/skir/config/languages/Locale$General;", "", "<init>", "()V", "prefix", "", "getPrefix", "()Ljava/lang/String;", "setPrefix", "(Ljava/lang/String;)V", "reloading", "getReloading", "setReloading", "reloaded", "getReloaded", "setReloaded", "thisVisualIsDisabled", "getThisVisualIsDisabled", "setThisVisualIsDisabled", "DiverseFX"})
    public static final class General {
        @NotNull
        private String prefix = "<gradient:#6200ff:#00fffb>[Visuals]</gradient>";
        @NotNull
        private String reloading = "%prefix% <green>Reloading plugin...";
        @NotNull
        private String reloaded = "%prefix% <green>Plugin reloaded in %time%ms!";
        @NotNull
        private String thisVisualIsDisabled = "%prefix% <red>This visual is disabled!";

        @NotNull
        public final String getPrefix() {
            return this.prefix;
        }

        public final void setPrefix(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.prefix = string;
        }

        @NotNull
        public final String getReloading() {
            return this.reloading;
        }

        public final void setReloading(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.reloading = string;
        }

        @NotNull
        public final String getReloaded() {
            return this.reloaded;
        }

        public final void setReloaded(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.reloaded = string;
        }

        @NotNull
        public final String getThisVisualIsDisabled() {
            return this.thisVisualIsDisabled;
        }

        public final void setThisVisualIsDisabled(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.thisVisualIsDisabled = string;
        }
    }

    @Configuration
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b \b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001e\u0010\r\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\tR\u001a\u0010\u0010\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\tR\u001e\u0010\u0013\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0007\"\u0004\b\u0015\u0010\tR\u001a\u0010\u0016\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0007\"\u0004\b\u0018\u0010\tR\u001e\u0010\u0019\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0007\"\u0004\b\u001b\u0010\tR\u001a\u0010\u001c\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0007\"\u0004\b\u001e\u0010\tR\u001e\u0010\u001f\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0007\"\u0004\b!\u0010\tR\u001a\u0010\"\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0007\"\u0004\b$\u0010\t\u00a8\u0006%"}, d2={"Ldev/skir/config/languages/Locale$ShownVisuals;", "", "<init>", "()V", "fullscreen_no_timings", "", "getFullscreen_no_timings", "()Ljava/lang/String;", "setFullscreen_no_timings", "(Ljava/lang/String;)V", "fullscreen_timings", "getFullscreen_timings", "setFullscreen_timings", "transparent_no_timings", "getTransparent_no_timings", "setTransparent_no_timings", "transparent_timings", "getTransparent_timings", "setTransparent_timings", "freezing_no_timings", "getFreezing_no_timings", "setFreezing_no_timings", "freezing_timings", "getFreezing_timings", "setFreezing_timings", "fullscreen_gradient_no_timings", "getFullscreen_gradient_no_timings", "setFullscreen_gradient_no_timings", "fullscreen_gradient_timings", "getFullscreen_gradient_timings", "setFullscreen_gradient_timings", "bottom_gradient_no_timings", "getBottom_gradient_no_timings", "setBottom_gradient_no_timings", "bottom_gradient_timings", "getBottom_gradient_timings", "setBottom_gradient_timings", "DiverseFX"})
    public static final class ShownVisuals {
        @Comment(value={"\n        Message sent to the player when the visual is shown to another player with/without timings\n        %prefix% - Prefix of the plugin\n        %target% - Target player\n        %text% - Text of the visual\n        %fadeIn% - Time in milliseconds for the visual to fade in\n        %stay% - Time in milliseconds for the visual to stay\n        %fadeOut% - Time in milliseconds for the visual to fade out\n        \n        Others:\n        %title% - Title of the visual\n        %subtitle% - Subtitle of the visual\n        \n        Fullscreen Visual\n        "})
        @NotNull
        private String fullscreen_no_timings = "%prefix% <green>Showing fullscreen visual to <u>%target%</u> with text <u>%text%</u>.";
        @NotNull
        private String fullscreen_timings = "%prefix% <green>Showing fullscreen visual to <u>%target%</u> with text <u>%text%</u> for <u>%fadeIn%ms %stay%ms %fadeOut%ms</u>.";
        @Comment(value={"Transparent Visual"})
        @NotNull
        private String transparent_no_timings = "%prefix% <green>Showing transparent visual to <u>%target%</u> with text <u>%text%</u>.";
        @NotNull
        private String transparent_timings = "%prefix% <green>Showing transparent visual to <u>%target%</u> with text <u>%text%</u> for <u>%fadeIn%ms %stay%ms %fadeOut%ms</u>.";
        @Comment(value={"Freezing Visual"})
        @NotNull
        private String freezing_no_timings = "%prefix% <green>Showing freezing visual to <u>%target%</u> with title <u>%title%</u> and subtitle <u>%subtitle%</u>.";
        @NotNull
        private String freezing_timings = "%prefix% <green>Showing freezing visual to <u>%target%</u> with title <u>%title%</u> and subtitle <u>%subtitle%</u> for <u>%fadeIn%ms %stay%ms %fadeOut%ms</u>.";
        @Comment(value={"Fullscreen Gradient Visual"})
        @NotNull
        private String fullscreen_gradient_no_timings = "%prefix% <green>Showing fullscreen gradient visual to <u>%target%</u> with text <gradient:blue:green>%text%</gradient>.";
        @NotNull
        private String fullscreen_gradient_timings = "%prefix% <green>Showing fullscreen gradient visual to <u>%target%</u> with text <gradient:blue:green>%text%</gradient> for <u>%fadeIn%ms %stay%ms %fadeOut%ms</u>.";
        @Comment(value={"Bottom Gradient Visual"})
        @NotNull
        private String bottom_gradient_no_timings = "%prefix% <green>Showing bottom gradient visual to <u>%target%</u> with title <u>%title%</u> and subtitle <u>%subtitle%</u>.";
        @NotNull
        private String bottom_gradient_timings = "%prefix% <green>Showing bottom gradient visual to <u>%target%</u> with title <u>%title%</u> and subtitle <u>%subtitle%</u> for <u>%fadeIn%ms %stay%ms %fadeOut%ms</u>.";

        @NotNull
        public final String getFullscreen_no_timings() {
            return this.fullscreen_no_timings;
        }

        public final void setFullscreen_no_timings(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.fullscreen_no_timings = string;
        }

        @NotNull
        public final String getFullscreen_timings() {
            return this.fullscreen_timings;
        }

        public final void setFullscreen_timings(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.fullscreen_timings = string;
        }

        @NotNull
        public final String getTransparent_no_timings() {
            return this.transparent_no_timings;
        }

        public final void setTransparent_no_timings(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.transparent_no_timings = string;
        }

        @NotNull
        public final String getTransparent_timings() {
            return this.transparent_timings;
        }

        public final void setTransparent_timings(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.transparent_timings = string;
        }

        @NotNull
        public final String getFreezing_no_timings() {
            return this.freezing_no_timings;
        }

        public final void setFreezing_no_timings(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.freezing_no_timings = string;
        }

        @NotNull
        public final String getFreezing_timings() {
            return this.freezing_timings;
        }

        public final void setFreezing_timings(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.freezing_timings = string;
        }

        @NotNull
        public final String getFullscreen_gradient_no_timings() {
            return this.fullscreen_gradient_no_timings;
        }

        public final void setFullscreen_gradient_no_timings(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.fullscreen_gradient_no_timings = string;
        }

        @NotNull
        public final String getFullscreen_gradient_timings() {
            return this.fullscreen_gradient_timings;
        }

        public final void setFullscreen_gradient_timings(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.fullscreen_gradient_timings = string;
        }

        @NotNull
        public final String getBottom_gradient_no_timings() {
            return this.bottom_gradient_no_timings;
        }

        public final void setBottom_gradient_no_timings(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.bottom_gradient_no_timings = string;
        }

        @NotNull
        public final String getBottom_gradient_timings() {
            return this.bottom_gradient_timings;
        }

        public final void setBottom_gradient_timings(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.bottom_gradient_timings = string;
        }
    }
}

