/*
 * Decompiled with CFR 0.152.
 */
package com.kevsterking.imagemod.fabric.ImageBuilder;

import com.kevsterking.imagemod.fabric.ImageBuilder.ImageUtil;
import com.kevsterking.imagemod.fabric.ImageModClient;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.imageio.ImageIO;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2298;
import net.minecraft.class_2338;
import net.minecraft.class_2397;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2682;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;

@Environment(value=EnvType.CLIENT)
public class ImageBlock {
    private static final Set<class_2248> block_blacklist = new HashSet<class_2248>();
    public class_2680 state;
    public BufferedImage image;

    public static ImageBlock get_air() {
        ImageBlock ret = new ImageBlock();
        BufferedImage img = new BufferedImage(1, 1, 6);
        img.setRGB(0, 0, 0xFFFFFF);
        ret.state = null;
        ret.image = ImageUtil.load(img, 16, 16);
        return ret;
    }

    public static ImageBlock get(class_2248 block) throws IOException {
        ImageBlock ret = new ImageBlock();
        ret.state = block.method_9564();
        ret.image = ImageBlock.get_texture(ret.state);
        return ret;
    }

    public static boolean filter_block(class_2248 block) throws Exception {
        class_2680 state = block.method_9564();
        class_265 vs = state.method_26220((class_1922)class_2682.field_12294, class_2338.field_10980);
        if (!class_2248.method_9614((class_265)vs)) {
            throw new Exception("Is not full block");
        }
        if (block.method_9543()) {
            throw new Exception("Has dynamic shape");
        }
        if (state.method_26213() != 0) {
            throw new Exception("Emits light");
        }
        if (state.method_28498((class_2769)class_2741.field_12525) || state.method_28498((class_2769)class_2741.field_12481)) {
            throw new Exception("Directional block");
        }
        if (block instanceof class_2298) {
            throw new Exception("Is coral block");
        }
        if (block instanceof class_2397) {
            throw new Exception("Is leaves block");
        }
        if (block_blacklist.contains(block)) {
            throw new Exception("Is blacklisted");
        }
        return true;
    }

    private static BufferedImage get_texture(class_2680 state) throws IOException {
        class_310 client = class_310.method_1551();
        class_3300 resource_manager = client.method_1478();
        class_1087 model = client.method_1554().method_4743().method_3335(state);
        class_1058 sprite = model.method_68511();
        class_2960 block_id = sprite.method_45852();
        String path = sprite.method_45851().method_45816().method_12832();
        class_2960 location = class_2960.method_60655((String)block_id.method_12836(), (String)("textures/" + path + ".png"));
        ImageModClient.LOGGER.debug(location.method_12832());
        return ImageIO.read(((class_3298)resource_manager.method_14486(location).get()).method_14482());
    }

    static {
        block_blacklist.add(class_2246.field_16336);
        block_blacklist.add(class_2246.field_10342);
        block_blacklist.add(class_2246.field_37571);
        block_blacklist.add(class_2246.field_10295);
        block_blacklist.add(class_2246.field_10384);
        block_blacklist.add(class_2246.field_10110);
        block_blacklist.add(class_2246.field_10225);
    }
}

