/*
 * Decompiled with CFR 0.152.
 */
package com.kevsterking.imagemod.fabric.ImageBuilder.Mosaic;

import com.kevsterking.imagemod.fabric.ImageBuilder.Mosaic.MosaicGeneratorWorker;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public abstract class MosaicGenerator<TYPE, SRC, TILE, RES> {
    protected TILE[] tiles;
    protected TYPE[] tile_type;
    protected TYPE[][] source_type;
    protected int tile_size;
    protected int tile_cols;
    protected int tile_rows;

    protected abstract RES get_empty_result(int var1, int var2);

    protected abstract TYPE[] get_empty_type(int var1);

    protected abstract long compare(TYPE var1, TYPE var2);

    protected abstract TYPE[][] get_source_type(SRC var1, int var2, int var3);

    protected abstract TYPE get_tile_type(TILE var1, int var2);

    protected abstract void set_result(RES var1, TILE var2, int var3, int var4);

    protected abstract void generate_tiles(RES var1, int var2, int var3);

    public void set_tiles(TILE[] tiles, int tile_size) {
        this.tiles = tiles;
        this.tile_size = tile_size;
        this.tile_type = this.get_empty_type(tiles.length);
        for (int i = 0; i < tiles.length; ++i) {
            this.tile_type[i] = this.get_tile_type(tiles[i], tile_size);
        }
    }

    public RES generate(SRC src, int tile_cols, int tile_rows) {
        RES ret = this.get_empty_result(tile_cols, tile_rows);
        this.tile_cols = tile_cols;
        this.tile_rows = tile_rows;
        this.source_type = this.get_source_type(src, tile_cols, tile_rows);
        this.generate_tiles(ret, tile_cols, tile_rows);
        return ret;
    }

    public void generate_async(SRC src, int tile_cols, int tile_rows, Function<RES, Void> callback) {
        new MosaicGeneratorWorker(this).generate(src, tile_cols, tile_rows, callback);
    }

    protected void generate_at(RES res, int tile_x, int tile_y) {
        this.set_result(res, this.find_best(tile_x, tile_y), tile_x, tile_y);
    }

    private TILE find_best(int tile_x, int tile_y) {
        TILE record_tile = null;
        long record = Long.MAX_VALUE;
        for (int i = 0; i < this.tiles.length; ++i) {
            long score = this.compare(this.tile_type[i], this.source_type[tile_x][tile_y]);
            if (score >= record) continue;
            record_tile = this.tiles[i];
            record = score;
        }
        return record_tile;
    }
}

