/*
 * Decompiled with CFR 0.152.
 */
package com.kevsterking.imagemod.fabric.ImageBuilder.Mosaic;

import com.kevsterking.imagemod.fabric.ImageBuilder.ImageBlock;
import com.kevsterking.imagemod.fabric.ImageBuilder.ImageUtil;
import com.kevsterking.imagemod.fabric.ImageBuilder.Mosaic.IntColorVector;
import com.kevsterking.imagemod.fabric.ImageBuilder.Mosaic.MosaicGenerator;
import com.kevsterking.imagemod.fabric.ImageBuilder.Mosaic.MosaicIntColThreadWorker;
import com.kevsterking.imagemod.fabric.ImageModClient;
import com.kevsterking.imagemod.fabric.WorldTransformer.WorldStructure;
import java.awt.Color;
import java.awt.image.BufferedImage;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class MosaicIntColThread
extends MosaicGenerator<IntColorVector, BufferedImage, ImageBlock, WorldStructure> {
    @Override
    protected WorldStructure get_empty_result(int tile_cols, int tile_rows) {
        return new WorldStructure(tile_cols, tile_rows, 1);
    }

    protected IntColorVector[] get_empty_type(int size) {
        return new IntColorVector[size];
    }

    @Override
    protected void set_result(WorldStructure res, ImageBlock image_block, int x, int y) {
        res.structure[x][this.tile_rows - y - 1][0] = image_block.state;
    }

    @Override
    protected void generate_tiles(WorldStructure result, int tile_cols, int tile_rows) {
        int y;
        MosaicIntColThreadWorker[] worker = new MosaicIntColThreadWorker[tile_rows];
        for (y = 0; y < tile_rows; ++y) {
            MosaicIntColThreadWorker w;
            worker[y] = w = new MosaicIntColThreadWorker();
            w.start_task(result, this, tile_cols, y);
        }
        for (y = 0; y < tile_rows; ++y) {
            try {
                worker[y].join();
                continue;
            }
            catch (InterruptedException e) {
                ImageModClient.LOGGER.error("Failed to join threads: {}", (Object)e.getMessage());
            }
        }
    }

    @Override
    protected long compare(IntColorVector tile, IntColorVector image) {
        long ret = 0L;
        for (int i = 0; i < tile.a.length; i += 4) {
            int da = tile.a[i] - image.a[i];
            int db = tile.b[i] - image.b[i];
            int dg = tile.g[i] - image.g[i];
            int dr = tile.r[i] - image.r[i];
            ret += (long)db * (long)db + (long)dg * (long)dg + (long)dr * (long)dr + (long)da * (long)da;
        }
        return ret;
    }

    public static IntColorVector get_tile_colors(int[] in) {
        IntColorVector ret = new IntColorVector();
        ret.a = new int[in.length];
        ret.b = new int[in.length];
        ret.g = new int[in.length];
        ret.r = new int[in.length];
        for (int p = 0; p < in.length; ++p) {
            Color c = new Color(in[p], true);
            ret.a[p] = c.getAlpha();
            ret.b[p] = c.getBlue();
            ret.g[p] = c.getGreen();
            ret.r[p] = c.getRed();
        }
        return ret;
    }

    protected IntColorVector[][] get_source_type(BufferedImage src, int tile_cols, int tile_rows) {
        BufferedImage img = ImageUtil.load(src, tile_cols * this.tile_size, tile_rows * this.tile_size);
        IntColorVector[][] ret = new IntColorVector[tile_cols][tile_rows];
        int[] tmp = new int[this.tile_size * this.tile_size];
        for (int x = 0; x < tile_cols; ++x) {
            for (int y = 0; y < tile_rows; ++y) {
                img.getRGB(x * this.tile_size, y * this.tile_size, this.tile_size, this.tile_size, tmp, 0, this.tile_size);
                ret[x][y] = MosaicIntColThread.get_tile_colors(tmp);
            }
        }
        return ret;
    }

    @Override
    protected IntColorVector get_tile_type(ImageBlock image_block, int tile_size) {
        int[] ret = new int[tile_size * tile_size];
        ImageUtil.load(image_block.image, tile_size, tile_size).getRGB(0, 0, this.tile_size, this.tile_size, ret, 0, this.tile_size);
        return MosaicIntColThread.get_tile_colors(ret);
    }
}

