/*
 * Decompiled with CFR 0.152.
 */
package com.kevsterking.imagemod.fabric.WorldTransformer;

import com.kevsterking.imagemod.fabric.WorldTransformer.WorldStructure;
import com.kevsterking.imagemod.fabric.WorldTransformer.WorldTransform;
import java.util.Stack;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1132;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_310;
import net.minecraft.class_638;

@Environment(value=EnvType.CLIENT)
public class WorldTransformer {
    private final Stack<WorldTransform> undo_stack = new Stack();
    private final Stack<WorldTransform> redo_stack = new Stack();
    private final class_1132 server = class_310.method_1551().method_1576();

    public void undo() throws Exception {
        if (this.undo_stack.empty()) {
            throw new Exception("Undo stack is empty.");
        }
        WorldTransform action = this.undo_stack.pop();
        action.revert_transform();
        this.redo_stack.push(action);
    }

    public void redo() throws Exception {
        if (this.redo_stack.empty()) {
            throw new Exception("Redo stack is empty.");
        }
        WorldTransform action = this.redo_stack.pop();
        action.perform_transform();
        this.undo_stack.push(action);
    }

    public void undo_async(Function<Exception, Void> callback) {
        this.server.execute(() -> {
            try {
                this.undo();
                callback.apply(null);
            }
            catch (Exception e) {
                callback.apply(e);
            }
        });
    }

    public void redo_async(Function<Exception, Void> callback) {
        this.server.execute(() -> {
            try {
                this.redo();
                callback.apply(null);
            }
            catch (Exception e) {
                callback.apply(e);
            }
        });
    }

    public void place_async(class_638 world, WorldStructure structure, class_2338 position, class_2350 direction_x, class_2350 direction_y, class_2350 direction_z, Function<Void, Void> callback) throws Exception {
        if (this.server == null) {
            throw new Exception("Multiplayer support comming soon...");
        }
        WorldTransform ret = new WorldTransform((class_1937)this.server.method_3847(world.method_27983()), position, direction_x, direction_y, direction_z, structure);
        this.server.execute(() -> {
            ret.perform_transform();
            this.undo_stack.push(ret);
            callback.apply(null);
        });
    }
}

