/*
 * Decompiled with CFR 0.152.
 */
package com.kevsterking.imagemod.fabric.commands;

import com.kevsterking.imagemod.fabric.ImageBuilder.ImageBlock;
import com.kevsterking.imagemod.fabric.ImageBuilder.Mosaic.MosaicIntColThread;
import com.kevsterking.imagemod.fabric.ImageModClient;
import com.kevsterking.imagemod.fabric.WorldTransformer.WorldStructure;
import com.kevsterking.imagemod.fabric.WorldTransformer.WorldTransformer;
import com.kevsterking.imagemod.fabric.util.DirectoryArgument;
import com.kevsterking.imagemod.fabric.util.ImageFileArgument;
import com.kevsterking.imagemod.fabric.util.PathArgument;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1297;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_7157;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class ImageCommand {
    private final PathArgument image_argument = new ImageFileArgument();
    private final PathArgument directory_argument = new DirectoryArgument();
    private final ArrayList<ImageBlock> image_blocks = new ArrayList();
    private final MosaicIntColThread image_builder = new MosaicIntColThread();
    private WorldTransformer world_transformer;

    public void update_block_list() {
        ImageModClient.LOGGER.info("Loading block list");
        for (class_2248 block : class_7923.field_41175.method_10220().toList()) {
            try {
                if (!ImageBlock.filter_block(block)) continue;
                this.image_blocks.add(ImageBlock.get(block));
                ImageModClient.LOGGER.debug("{} - ACCEPTED", (Object)block.method_9518().getString());
            }
            catch (Exception e) {
                ImageModClient.LOGGER.debug("{} - REJECTED: {}", (Object)block.method_9518().getString(), (Object)e.getMessage());
            }
        }
        this.image_blocks.add(ImageBlock.get_air());
        ImageBlock[] blocks = new ImageBlock[this.image_blocks.size()];
        for (int i = 0; i < this.image_blocks.size(); ++i) {
            blocks[i] = this.image_blocks.get(i);
        }
        this.image_builder.set_tiles(blocks, 16);
        ImageModClient.LOGGER.info("Block list loading complete.");
    }

    private int create_execute(CommandContext<FabricClientCommandSource> ctx) throws CommandSyntaxException {
        int h;
        int w;
        class_310 client = class_310.method_1551();
        FabricClientCommandSource source = (FabricClientCommandSource)ctx.getSource();
        if (client.method_1576() == null) {
            source.sendError((class_2561)class_2561.method_43470((String)"Failed: Multiplayer image creation coming soon..."));
            return 0;
        }
        class_638 level = source.getWorld();
        class_1297 entity = source.getEntity();
        if (entity == null) {
            source.sendError((class_2561)class_2561.method_43470((String)"Failed: Source is not an entity"));
            return 0;
        }
        class_2350 direction_view = entity.method_58149();
        class_2350 direction_right = direction_view.method_10170();
        class_2338 position = entity.method_24515().method_10079(direction_view, 2);
        int input_width = 0;
        int input_height = 0;
        boolean width_set = false;
        boolean height_set = false;
        try {
            input_width = IntegerArgumentType.getInteger(ctx, (String)"width");
            width_set = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            input_height = IntegerArgumentType.getInteger(ctx, (String)"height");
            height_set = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        Path path = this.image_argument.get_path(ctx, "src");
        BufferedImage image = null;
        try {
            image = ImageIO.read(path.toFile());
        }
        catch (IOException e) {
            throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"Failed: Could not load image.")).create();
        }
        if (image == null) {
            throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"Failed: Could not load image.")).create();
        }
        if (width_set && height_set) {
            w = input_width;
            h = input_height;
        } else if (width_set) {
            w = input_width;
            h = (int)((double)input_width * ((double)image.getHeight() / (double)image.getWidth()));
        } else if (height_set) {
            h = input_height;
            w = (int)((double)input_height * ((double)image.getWidth() / (double)image.getHeight()));
        } else {
            throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"Failed: No width or height set.")).create();
        }
        this.image_builder.generate_async(image, w, h, structure -> {
            try {
                this.world_transformer.place_async(level, (WorldStructure)structure, position, direction_right, class_2350.field_11036, direction_view, v -> {
                    source.sendFeedback((class_2561)class_2561.method_43470((String)String.format("Successfully created %dx%d image", w, h)));
                    return null;
                });
            }
            catch (Exception e) {
                source.sendError((class_2561)class_2561.method_43470((String)("Failed: " + e.getMessage())));
                return null;
            }
            return null;
        });
        return 1;
    }

    private int reload_execute(CommandContext<FabricClientCommandSource> ctx) throws CommandSyntaxException {
        this.update_block_list();
        ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Reloaded block list"));
        return 1;
    }

    private int undo_execute(CommandContext<FabricClientCommandSource> ctx) throws CommandSyntaxException {
        this.world_transformer.undo_async(e -> {
            if (e != null) {
                ((FabricClientCommandSource)ctx.getSource()).sendError((class_2561)class_2561.method_43470((String)("Failed: " + e.getMessage())));
                return null;
            }
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Successfully reverted last WorldTransform"));
            return null;
        });
        return 1;
    }

    private int redo_execute(CommandContext<FabricClientCommandSource> ctx) throws CommandSyntaxException {
        this.world_transformer.redo_async(e -> {
            if (e != null) {
                ((FabricClientCommandSource)ctx.getSource()).sendError((class_2561)class_2561.method_43470((String)("Failed: " + e.getMessage())));
                return null;
            }
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Successful redo of last undone WorldTransform"));
            return null;
        });
        return 1;
    }

    private int set_directory_execute(CommandContext<FabricClientCommandSource> ctx) {
        Path dir = this.directory_argument.get_path(ctx, "dir");
        try {
            this.image_argument.set_root_directory(dir.toString());
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Successfully set image directory to \"" + String.valueOf(dir) + "\"")));
            return 1;
        }
        catch (NotDirectoryException e) {
            ((FabricClientCommandSource)ctx.getSource()).sendError((class_2561)class_2561.method_43470((String)"Provided path is not a directory"));
        }
        catch (FileNotFoundException e) {
            ((FabricClientCommandSource)ctx.getSource()).sendError((class_2561)class_2561.method_43470((String)"Provided path could not be found"));
        }
        return 0;
    }

    public void register(CommandDispatcher<FabricClientCommandSource> ctx, class_7157 access) {
        ImageModClient.LOGGER.info("Registering Commands...");
        this.world_transformer = new WorldTransformer();
        this.update_block_list();
        LiteralArgumentBuilder root = ClientCommandManager.literal((String)"image");
        LiteralArgumentBuilder createLiteral = ClientCommandManager.literal((String)"create");
        LiteralArgumentBuilder wLiteral = ClientCommandManager.literal((String)"-width");
        LiteralArgumentBuilder hLiteral = ClientCommandManager.literal((String)"-height");
        LiteralArgumentBuilder whInfoLiteral = ClientCommandManager.literal((String)"~ ~");
        RequiredArgumentBuilder srcArgument = ClientCommandManager.argument((String)"src", (ArgumentType)this.image_argument);
        RequiredArgumentBuilder wArgument = ClientCommandManager.argument((String)"width", (ArgumentType)IntegerArgumentType.integer());
        RequiredArgumentBuilder wArgumentFinal = (RequiredArgumentBuilder)ClientCommandManager.argument((String)"width", (ArgumentType)IntegerArgumentType.integer()).executes(this::create_execute);
        RequiredArgumentBuilder hArgumentFinal = (RequiredArgumentBuilder)ClientCommandManager.argument((String)"height", (ArgumentType)IntegerArgumentType.integer()).executes(this::create_execute);
        wLiteral.then((ArgumentBuilder)wArgumentFinal);
        hLiteral.then((ArgumentBuilder)hArgumentFinal);
        wArgument.then((ArgumentBuilder)hArgumentFinal);
        ((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)srcArgument.then((ArgumentBuilder)wLiteral)).then((ArgumentBuilder)hLiteral)).then((ArgumentBuilder)whInfoLiteral)).then((ArgumentBuilder)wArgument);
        createLiteral.then((ArgumentBuilder)srcArgument);
        LiteralArgumentBuilder reload = (LiteralArgumentBuilder)ClientCommandManager.literal((String)"reload").executes(this::reload_execute);
        LiteralArgumentBuilder undoLiteral = (LiteralArgumentBuilder)ClientCommandManager.literal((String)"undo").executes(this::undo_execute);
        LiteralArgumentBuilder redoLiteral = (LiteralArgumentBuilder)ClientCommandManager.literal((String)"redo").executes(this::redo_execute);
        LiteralArgumentBuilder setDirectoryLiteral = ClientCommandManager.literal((String)"setDirectory");
        RequiredArgumentBuilder directoryArgument = (RequiredArgumentBuilder)ClientCommandManager.argument((String)"dir", (ArgumentType)this.directory_argument).executes(this::set_directory_execute);
        setDirectoryLiteral.then((ArgumentBuilder)directoryArgument);
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)root.then((ArgumentBuilder)createLiteral)).then((ArgumentBuilder)setDirectoryLiteral)).then((ArgumentBuilder)reload)).then((ArgumentBuilder)undoLiteral)).then((ArgumentBuilder)redoLiteral);
        ctx.register(root);
        ImageModClient.LOGGER.info("Commands Registered.");
    }
}

