/*
 * Decompiled with CFR 0.152.
 */
package com.kevsterking.imagemod.neoforge.ImageBuilder;

import com.kevsterking.imagemod.neoforge.ImageBuilder.ImageUtil;
import com.kevsterking.imagemod.neoforge.ImageModClient;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CoralBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ImageBlock {
    private static final Set<Block> block_blacklist = new HashSet<Block>();
    public BlockState state;
    public BufferedImage image;

    public static ImageBlock get_air() {
        ImageBlock ret = new ImageBlock();
        BufferedImage img = new BufferedImage(1, 1, 6);
        img.setRGB(0, 0, 0xFFFFFF);
        ret.state = null;
        ret.image = ImageUtil.load(img, 16, 16);
        return ret;
    }

    public static ImageBlock get(Block block) throws IOException {
        ImageBlock ret = new ImageBlock();
        ret.state = block.defaultBlockState();
        ret.image = ImageBlock.get_texture(ret.state);
        return ret;
    }

    public static boolean filter_block(Block block) throws Exception {
        BlockState state = block.defaultBlockState();
        VoxelShape vs = state.getCollisionShape((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.ZERO);
        if (!Block.isShapeFullBlock((VoxelShape)vs)) {
            throw new Exception("Is not full block");
        }
        if (block.hasDynamicShape()) {
            throw new Exception("Has dynamic shape");
        }
        if (state.getLightEmission((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.ZERO) != 0) {
            throw new Exception("Emits light");
        }
        if (state.hasProperty((Property)BlockStateProperties.FACING) || state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            throw new Exception("Directional block");
        }
        if (block instanceof CoralBlock) {
            throw new Exception("Is coral block");
        }
        if (block instanceof LeavesBlock) {
            throw new Exception("Is leaves block");
        }
        if (block_blacklist.contains(block)) {
            throw new Exception("Is blacklisted");
        }
        return true;
    }

    private static BufferedImage get_texture(BlockState state) throws IOException {
        ResourceManager resource_manager = Minecraft.getInstance().getResourceManager();
        BlockModelShaper bms = Minecraft.getInstance().getModelManager().getBlockModelShaper();
        assert (Minecraft.getInstance().level != null);
        TextureAtlasSprite sprite = bms.getParticleIcon(state, (BlockAndTintGetter)Minecraft.getInstance().level, BlockPos.ZERO);
        ResourceLocation block_id = sprite.atlasLocation();
        String path = sprite.contents().name().getPath();
        ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)block_id.getNamespace(), (String)("textures/" + path + ".png"));
        Optional resource = resource_manager.getResource(location);
        ImageModClient.LOGGER.debug(location.getPath());
        if (resource.isPresent()) {
            return ImageIO.read(((Resource)resource_manager.getResource(location).get()).open());
        }
        throw new IOException("Resource is not present");
    }

    static {
        block_blacklist.add(Blocks.CARTOGRAPHY_TABLE);
        block_blacklist.add(Blocks.DRIED_KELP_BLOCK);
        block_blacklist.add(Blocks.SCULK_SHRIEKER);
        block_blacklist.add(Blocks.ICE);
        block_blacklist.add(Blocks.BLUE_ICE);
        block_blacklist.add(Blocks.FROSTED_ICE);
        block_blacklist.add(Blocks.PACKED_ICE);
    }
}

